<?php
/**
 * Request Helper Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-components/web-io-connect
 * @subpackage  Helpers
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 Wassilios Meletiadis <https://www.bplan-solutions.de/>
 * /Δ\
 */

 namespace BplanComponents\WebIoConnect\Helpers;


 /**
  * Request Helper Class
  *
  * @version     1.0.0 / 2025-04-26
  * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
  */
class RequestHelper
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * Liefert einen Array mit Parametern aus dem raw Body eines Requests
     *
     * Der raw Body kann mit $Request->getContent() aus dem Request-Objekt ermittelt
     * werden.
     *
     * @param       string $body
     *
     * @return      array
     *
     * @version     1.0.0 / 2025-04-26
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public static function parseRawBody(string $body): array
    {
        $normalizedBody = str_replace(["\r\n", "\r"], "\n", $body);

        $lines = explode("\n", $normalizedBody);

        $result = [];

        foreach ($lines as $line) {
            if (trim($line) === '') {
                continue;
            }
            [$key, $value] = explode('=', $line, 2);

            $result[trim($key)] = trim($value);
        }
        return $result;

    } // parseRawBody()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class RequestHelper {}