<?php
/**
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-modules/card-manager
 * @subpackage  Seeders
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanModules\CardManager\Database\Seeders;


use BplanBase\Globals\Models\EntityTypeModel;
use Illuminate\Database\Seeder;
use Illuminate\Support\Str;


/**
 *
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class RegisterEntityTypeModelSeeder extends Seeder
{

    /**
     * Run the database seeds.
     *
     * @return      void
     *
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function run()
    {
        $date = date('Y-m-d H:i:s');

        EntityTypeModel::insert([
            [
                'uuid' => Str::uuid(),
                "active" => 1,
                "created_at" => $date,
                "updated_at" => $date,
                "identifier" => 'CarmaCard',
                "fully_qualified_class_name" => 'BplanModules\\CardManager\\Models\\CarmaCard',
                "resource_name" => 'carma-cards',
                "table_name" => 'carma_cards',
            ],

        ]);

    } // run()

} // class RegisterEntityTypeModelSeeder extends Seeder {}
