<x-global-components::global.modals.base name="basicDataLayoutsAdd" x-on:show-basic-data-layouts-add-modal.window="show">
    <x-slot:header>
        <x-global-components::global.modals.base-header>
            <x-slot:icon>
                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor" class="size-6">
                    <path fill-rule="evenodd"
                        d="M12 3.75a.75.75 0 0 1 .75.75v6.75h6.75a.75.75 0 0 1 0 1.5h-6.75v6.75a.75.75 0 0 1-1.5 0v-6.75H4.5a.75.75 0 0 1 0-1.5h6.75V4.5a.75.75 0 0 1 .75-.75Z"
                        clip-rule="evenodd" />
                </svg>
            </x-slot>

            <x-slot:title>
                @lang('card-manager::carma-card-layouts.caption.add')
            </x-slot>
        </x-global-components::global.modals.base-header>
    </x-slot>

    <x-slot:body>
        <div class="grid gap-4 mb-4 sm:grid-cols-2">

            <x-fields.file-input id="iniFile" :label="__('card-manager::carma-card-layouts.upload.ini')" />
            <x-fields.file-input id="pdfFile" :label="__('card-manager::carma-card-layouts.upload.pdf')" />
            <x-fields.file-input id="otherFiles" :label="__('card-manager::carma-card-layouts.upload.other')" />

        </div>
    </x-slot>

    <x-slot:footer>
        <x-button wire:click="add" wire:loading.remove>
            @lang('globals::global.action.save')
        </x-button>
        <x-global-components::global.loading-spinner wire:loading wire:target="add" />
    </x-slot>

    <x-slot:alpineScript>
        <script>
            document.addEventListener('alpine:init', () => {
                Alpine.data('basicDataLayoutsAdd', () => ({
                    isModalVisible: false,

                    hide() {
                        this.isModalVisible = false;
                    },
                    show(id) {
                        this.isModalVisible = true;

                        setTimeout(() => {
                            // onShow
                        }, 100);
                    },
                }));
            });
        </script>
    </x-slot>
</x-global-components::global.modals.base>
