<x-global-components::global.modals.base name="basicDataCardTypesAdd" x-on:show-basic-data-card-types-add-modal.window="show" x-on:card-type-added="added">
    <x-slot:header>
        <x-global-components::global.modals.base-header>
            <x-slot:icon>
                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor" class="size-6">
                    <path fill-rule="evenodd"
                        d="M12 3.75a.75.75 0 0 1 .75.75v6.75h6.75a.75.75 0 0 1 0 1.5h-6.75v6.75a.75.75 0 0 1-1.5 0v-6.75H4.5a.75.75 0 0 1 0-1.5h6.75V4.5a.75.75 0 0 1 .75-.75Z"
                        clip-rule="evenodd" />
                </svg>
            </x-slot>

            <x-slot:title>
                @lang('card-manager::carma-card-types.caption.add')
            </x-slot>
        </x-global-components::global.modals.base-header>
    </x-slot>

    <x-slot:body>
        <div class="grid gap-4 mb-4 sm:grid-cols-2">
            <x-global-components::inputs.input :label="__('card-manager::carma-card-types.field.chip_type')" wire:model="chiptype" :placeholder="__('card-manager::carma-card-types.placeholder.chip_type')" class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500"/>
            <x-global-components::inputs.input :label="__('card-manager::carma-card-types.field.labeling')" wire:model="labeling" :placeholder="__('card-manager::carma-card-types.placeholder.labeling')" class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500"/>
            <x-global-components::inputs.input :label="__('card-manager::carma-card-types.field.memory')" type="number" wire:model="memory" :placeholder="__('card-manager::carma-card-types.placeholder.memory')" class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500"/>
            <x-global-components::inputs.input :label="__('card-manager::carma-card-types.field.frequency')" type="number" wire:model="frequency" :placeholder="__('card-manager::carma-card-types.placeholder.frequency')" class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500"/>
            <div class="sm:col-span-2">
                <label for="description"
                    class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">
                    @lang('card-manager::carma-card-types.field.note')
                </label>
                <textarea id="description" rows="5"
                    class="block p-2.5 w-full text-sm text-gray-900 bg-gray-50 rounded-lg border border-gray-300 focus:ring-primary-500 focus:border-primary-500 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500"
                    placeholder="@lang('card-manager::carma-card-types.placeholder.note')"></textarea>
            </div>
        </div>
    </x-slot>

    <x-slot:footer>
        <x-button wire:click="add" wire:loading.remove>
            @lang('globals::global.action.save')
        </x-button>
        <x-global-components::global.loading-spinner wire:loading wire:target="add"/>
    </x-slot>

    <x-slot:alpineScript>
        <script>
            document.addEventListener('alpine:init', () => {
                Alpine.data('basicDataCardTypesAdd', () => ({
                    isModalVisible: false,

                    hide() {
                        this.isModalVisible = false;
                    },
                    show() {
                        this.isModalVisible = true;

                        setTimeout(() => {
                            // onShow
                        }, 100);
                    },
                    added()
                    {
                        this.hide();
                    }
                }));
            });
        </script>
    </x-slot>
</x-global-components::global.modals.base>
