<x-global-components::global.modals.base name="targetDataEdit" x-on:show-carma-cards-edit-modal.window="show" maxWidth="4xl">
    <x-slot:header>
        <x-global-components::global.modals.base-header>
            <x-slot:icon>
                <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5"
                    stroke="currentColor" class="size-6">
                    <path stroke-linecap="round" stroke-linejoin="round"
                        d="m16.862 4.487 1.687-1.688a1.875 1.875 0 1 1 2.652 2.652L10.582 16.07a4.5 4.5 0 0 1-1.897 1.13L6 18l.8-2.685a4.5 4.5 0 0 1 1.13-1.897l8.932-8.931Zm0 0L19.5 7.125M18 14v4.75A2.25 2.25 0 0 1 15.75 21H5.25A2.25 2.25 0 0 1 3 18.75V8.25A2.25 2.25 0 0 1 5.25 6H10" />
                </svg>
            </x-slot>

            <x-slot:title>
                @lang('card-manager::carma-cards.caption.edit')
            </x-slot>
        </x-global-components::global.modals.base-header>
    </x-slot>

    <x-slot:body>
        @if (!empty($fieldDefinition))
            <x-global-components::global.tabs.standard-container>
                <x-global-components::global.tabs.standard-list-item id="main_data">
                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor" class="size-6 me-2">
                        <path fill-rule="evenodd"
                            d="M7.5 6a4.5 4.5 0 1 1 9 0 4.5 4.5 0 0 1-9 0ZM3.751 20.105a8.25 8.25 0 0 1 16.498 0 .75.75 0 0 1-.437.695A18.683 18.683 0 0 1 12 22.5c-2.786 0-5.433-.608-7.812-1.7a.75.75 0 0 1-.437-.695Z"
                            clip-rule="evenodd" />
                    </svg>
                    @lang('card-manager::carma-cards.tab.main')

                    @if (
                        !empty(array_intersect(
                                [
                                    'formOfAddress',
                                    'firstName',
                                    'lastName',
                                    'dateOfBirth',
                                    'street',
                                    'houseNumber',
                                    'zipCode',
                                    'city',
                                    'email',
                                    'phoneNumberCountryCode',
                                    'phoneNumber',
                                    'mobilePhoneNumberCountryCode',
                                    'mobilePhoneNumber',
                                ],
                                array_keys($errors->toArray()))
                        ))
                        <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5"
                            stroke="currentColor" class="size-6 ms-2 text-red-500">
                            <path stroke-linecap="round" stroke-linejoin="round"
                                d="M12 9v3.75m9-.75a9 9 0 1 1-18 0 9 9 0 0 1 18 0Zm-9 3.75h.008v.008H12v-.008Z" />
                        </svg>
                    @endif
                </x-global-components::global.tabs.standard-list-item>
                <x-global-components::global.tabs.standard-list-item id="company">
                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor" class="size-6 me-2">
                        <path fill-rule="evenodd"
                            d="M4.5 2.25a.75.75 0 0 0 0 1.5v16.5h-.75a.75.75 0 0 0 0 1.5h16.5a.75.75 0 0 0 0-1.5h-.75V3.75a.75.75 0 0 0 0-1.5h-15ZM9 6a.75.75 0 0 0 0 1.5h1.5a.75.75 0 0 0 0-1.5H9Zm-.75 3.75A.75.75 0 0 1 9 9h1.5a.75.75 0 0 1 0 1.5H9a.75.75 0 0 1-.75-.75ZM9 12a.75.75 0 0 0 0 1.5h1.5a.75.75 0 0 0 0-1.5H9Zm3.75-5.25A.75.75 0 0 1 13.5 6H15a.75.75 0 0 1 0 1.5h-1.5a.75.75 0 0 1-.75-.75ZM13.5 9a.75.75 0 0 0 0 1.5H15A.75.75 0 0 0 15 9h-1.5Zm-.75 3.75a.75.75 0 0 1 .75-.75H15a.75.75 0 0 1 0 1.5h-1.5a.75.75 0 0 1-.75-.75ZM9 19.5v-2.25a.75.75 0 0 1 .75-.75h4.5a.75.75 0 0 1 .75.75v2.25a.75.75 0 0 1-.75.75h-4.5A.75.75 0 0 1 9 19.5Z"
                            clip-rule="evenodd" />
                    </svg>

                    @lang('card-manager::carma-cards.tab.company')

                    @if (
                        !empty(array_intersect(
                                [
                                    'company',
                                    'companyCity',
                                    'companyHouseNumber',
                                    'companyStreet',
                                    'companyZipCode',
                                    'dateOfEntry',
                                    'department',
                                    'function',
                                    'identificationNumber',
                                    'location',
                                    'personnelNumber',
                                ],
                                array_keys($errors->toArray()))
                        ))
                        <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5"
                            stroke="currentColor" class="size-6 ms-2 text-red-500">
                            <path stroke-linecap="round" stroke-linejoin="round"
                                d="M12 9v3.75m9-.75a9 9 0 1 1-18 0 9 9 0 0 1 18 0Zm-9 3.75h.008v.008H12v-.008Z" />
                        </svg>
                    @endif
                </x-global-components::global.tabs.standard-list-item>
                <x-global-components::global.tabs.standard-list-item id="card">
                    <svg class="size-6 me-2" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor">
                        <path d="M4.5 3.75a3 3 0 0 0-3 3v.75h21v-.75a3 3 0 0 0-3-3h-15Z" />
                        <path fill-rule="evenodd"
                            d="M22.5 9.75h-21v7.5a3 3 0 0 0 3 3h15a3 3 0 0 0 3-3v-7.5Zm-18 3.75a.75.75 0 0 1 .75-.75h6a.75.75 0 0 1 0 1.5h-6a.75.75 0 0 1-.75-.75Zm.75 2.25a.75.75 0 0 0 0 1.5h3a.75.75 0 0 0 0-1.5h-3Z"
                            clip-rule="evenodd" />
                    </svg>
                    @lang('card-manager::carma-cards.tab.card')
                </x-global-components::global.tabs.standard-list-item>
            </x-global-components::global.tabs.standard-container>

            {{-- PERSONAL --}}
            <div x-show="currentTab == 'main_data'">
                <div class="grid gap-4 mb-4 sm:grid-cols-2">
                    <x-global-components::inputs.input wire:model="formOfAddress" :active="$fieldDefinition['FormOfAddress']->active" :mandatory="$fieldDefinition['FormOfAddress']->mandatory" :readonly="$fieldDefinition['FormOfAddress']->readonly"
                        label="{{ __('card-manager::carma-cards.field.form_of_address') }}"
                        class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500" />
                    <div class="col-start-1">
                        <x-global-components::inputs.input wire:model="firstName" :active="$fieldDefinition['FirstName']->active" :mandatory="$fieldDefinition['FirstName']->mandatory" :readonly="$fieldDefinition['FirstName']->readonly"
                            label="{{ __('card-manager::carma-cards.field.first_name') }}"
                            class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500" />
                    </div>
                    <x-global-components::inputs.input wire:model="lastName" :active="$fieldDefinition['LastName']->active" :mandatory="$fieldDefinition['LastName']->mandatory" :readonly="$fieldDefinition['LastName']->readonly"
                        label="{{ __('card-manager::carma-cards.field.last_name') }}"
                        class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500" />
                    <x-global-components::inputs.input wire:model="dateOfBirth" :active="$fieldDefinition['DateOfBirth']->active" :mandatory="$fieldDefinition['DateOfBirth']->mandatory" :readonly="$fieldDefinition['DateOfBirth']->readonly"
                        type="date" label="{{ __('card-manager::carma-cards.field.date_of_birth') }}"
                        class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500" />
                    <div class="col-start-1">
                        <x-global-components::inputs.input wire:model="street" :active="$fieldDefinition['Street']->active" :mandatory="$fieldDefinition['Street']->mandatory" :readonly="$fieldDefinition['Street']->readonly"
                            label="{{ __('card-manager::carma-cards.field.street') }}"
                            class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500" />
                    </div>
                    <x-global-components::inputs.input wire:model="houseNumber" :active="$fieldDefinition['HouseNumber']->active" :mandatory="$fieldDefinition['HouseNumber']->mandatory" :readonly="$fieldDefinition['HouseNumber']->readonly"
                        label="{{ __('card-manager::carma-cards.field.house_number') }}"
                        class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500" />
                    <x-global-components::inputs.input wire:model="zipCode" :active="$fieldDefinition['ZipCode']->active" :mandatory="$fieldDefinition['ZipCode']->mandatory" :readonly="$fieldDefinition['ZipCode']->readonly"
                        label="{{ __('card-manager::carma-cards.field.zip_code') }}"
                        class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500" />
                    <x-global-components::inputs.input wire:model="city" :active="$fieldDefinition['City']->active" :mandatory="$fieldDefinition['City']->mandatory" :readonly="$fieldDefinition['City']->readonly"
                        label="{{ __('card-manager::carma-cards.field.city') }}"
                        class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500" />
                    <div class="col-start-1">
                        <x-global-components::inputs.input wire:model="email" :active="$fieldDefinition['Email']->active" :mandatory="$fieldDefinition['Email']->mandatory" :readonly="$fieldDefinition['Email']->readonly"
                            label="{{ __('card-manager::carma-cards.field.email') }}"
                            class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500" />
                    </div>
                    <div class="col-start-1">
                        <x-global-components::inputs.input wire:model="phoneNumberCountryCode" :active="$fieldDefinition['PhoneNumberCountryCode']->active" :mandatory="$fieldDefinition['PhoneNumberCountryCode']->mandatory"
                            :readonly="$fieldDefinition['PhoneNumberCountryCode']->readonly" label="{{ __('card-manager::carma-cards.field.phone_number_country_code') }}"
                            class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500" />
                    </div>
                    <x-global-components::inputs.input wire:model="phoneNumber" :active="$fieldDefinition['PhoneNumber']->active" :mandatory="$fieldDefinition['PhoneNumber']->mandatory" :readonly="$fieldDefinition['PhoneNumber']->readonly"
                        label="{{ __('card-manager::carma-cards.field.phone_number') }}"
                        class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500" />
                    <x-global-components::inputs.input wire:model="mobilePhoneNumberCountryCode" :active="$fieldDefinition['MobilePhoneNumberCountryCode']->active" :mandatory="$fieldDefinition['MobilePhoneNumberCountryCode']->mandatory"
                        :readonly="$fieldDefinition['MobilePhoneNumberCountryCode']->readonly" label="{{ __('card-manager::carma-cards.field.mobile_phone_number_country_code') }}"
                        class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500" />
                    <x-global-components::inputs.input wire:model="mobilePhoneNumber" :active="$fieldDefinition['MobilePhoneNumber']->active" :mandatory="$fieldDefinition['MobilePhoneNumber']->mandatory"
                        :readonly="$fieldDefinition['MobilePhoneNumber']->readonly" label="{{ __('card-manager::carma-cards.field.mobile_phone_number') }}"
                        class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500" />
                </div>
            </div>
            {{-- COMPANY --}}
            <div x-show="currentTab == 'company'">
                <div class="grid gap-4 mb-4 sm:grid-cols-2">
                    <x-global-components::inputs.input wire:model="company" :active="$fieldDefinition['Company']->active" :mandatory="$fieldDefinition['Company']->mandatory" :readonly="$fieldDefinition['Company']->readonly"
                        label="{{ __('card-manager::carma-cards.field.company') }}"
                        class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500" />
                    <x-global-components::inputs.input wire:model="companyCity" :active="$fieldDefinition['CompanyCity']->active" :mandatory="$fieldDefinition['CompanyCity']->mandatory" :readonly="$fieldDefinition['CompanyCity']->readonly"
                        label="{{ __('card-manager::carma-cards.field.company_city') }}"
                        class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500" />
                    <x-global-components::inputs.input wire:model="companyHouseNumber" :active="$fieldDefinition['CompanyHouseNumber']->active" :mandatory="$fieldDefinition['CompanyHouseNumber']->mandatory"
                        :readonly="$fieldDefinition['CompanyHouseNumber']->readonly" label="{{ __('card-manager::carma-cards.field.company_house_number') }}"
                        class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500" />
                    <x-global-components::inputs.input wire:model="companyStreet" :active="$fieldDefinition['CompanyStreet']->active" :mandatory="$fieldDefinition['CompanyStreet']->mandatory" :readonly="$fieldDefinition['CompanyStreet']->readonly"
                        label="{{ __('card-manager::carma-cards.field.company_street') }}"
                        class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500" />
                    <x-global-components::inputs.input wire:model="companyZipCode" :active="$fieldDefinition['CompanyZipCode']->active" :mandatory="$fieldDefinition['CompanyZipCode']->mandatory"
                        :readonly="$fieldDefinition['CompanyZipCode']->readonly" label="{{ __('card-manager::carma-cards.field.company_zip_code') }}"
                        class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500" />
                    <x-global-components::inputs.input wire:model="dateOfEntry" :active="$fieldDefinition['DateOfEntry']->active" :mandatory="$fieldDefinition['DateOfEntry']->mandatory" :readonly="$fieldDefinition['DateOfEntry']->readonly"
                        type="date" label="{{ __('card-manager::carma-cards.field.date_of_entry') }}"
                        class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500" />
                    <x-global-components::inputs.input wire:model="department" :active="$fieldDefinition['Department']->active" :mandatory="$fieldDefinition['Department']->mandatory" :readonly="$fieldDefinition['Department']->readonly"
                        label="{{ __('card-manager::carma-cards.field.department') }}"
                        class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500" />
                    <x-global-components::inputs.input wire:model="function" :active="$fieldDefinition['Function']->active" :mandatory="$fieldDefinition['Function']->mandatory" :readonly="$fieldDefinition['Function']->readonly"
                        label="{{ __('card-manager::carma-cards.field.function') }}"
                        class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500" />
                    <x-global-components::inputs.input wire:model="identificationNumber" :active="$fieldDefinition['IdentificationNumber']->active" :mandatory="$fieldDefinition['IdentificationNumber']->mandatory"
                        :readonly="$fieldDefinition['IdentificationNumber']->readonly" label="{{ __('card-manager::carma-cards.field.identification_number') }}"
                        class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500" />
                    <x-global-components::inputs.input wire:model="location" :active="$fieldDefinition['Location']->active" :mandatory="$fieldDefinition['Location']->mandatory" :readonly="$fieldDefinition['Location']->readonly"
                        label="{{ __('card-manager::carma-cards.field.location') }}"
                        class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500" />
                    <x-global-components::inputs.input wire:model="personnelNumber" :active="$fieldDefinition['PersonnelNumber']->active" :mandatory="$fieldDefinition['PersonnelNumber']->mandatory"
                        :readonly="$fieldDefinition['PersonnelNumber']->readonly" label="{{ __('card-manager::carma-cards.field.personnel_number') }}"
                        class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500" />
                </div>
            </div>
            {{-- CARD --}}
            <div x-show="currentTab == 'card'">
                <div class="grid gap-4 mb-4 sm:grid-cols-2">
                    <div>
                        <x-label value="{{ __('card-manager::carma-cards.field.card_layout') }}" />
                        <x-global-components::inputs.combo-box itemsKey="cardLayouts" :items="$filteredComboBoxData['cardLayouts']" :placeholder="__('card-manager::carma-cards.placeholder.card_layout')"
                            :multiple="false" />
                        <div class="mt-2">
                            @foreach ($comboBoxData['cardLayouts'] as $index => $comboBoxCardLayout)
                                @if (isset($comboBoxCardLayout['isSelected']) && $comboBoxCardLayout['isSelected'])
                                    <x-global-components::inputs.combo-box-badge :imageRounded="false" :imageUrl="$comboBoxCardLayout['image_url']" :label="$comboBoxCardLayout['label']"
                                        itemsKey="cardLayouts" :index="$index" />
                                @endif
                            @endforeach
                        </div>
                    </div>
                    <div>
                        <x-label value="{{ __('card-manager::carma-cards.field.card_type') }}" />
                        <x-global-components::inputs.combo-box itemsKey="cardTypes" :items="$filteredComboBoxData['cardTypes']" :placeholder="__('card-manager::carma-cards.placeholder.card_type')"
                            :multiple="false" />
                        <div class="mt-2">
                            @foreach ($comboBoxData['cardTypes'] as $index => $comboBoxCardType)
                                @if (isset($comboBoxCardType['isSelected']) && $comboBoxCardType['isSelected'])
                                    <x-global-components::inputs.combo-box-badge :imageUrl="$comboBoxCardType['image_url']" :label="$comboBoxCardType['label'] ?? ''"
                                        itemsKey="cardTypes" :index="$index" />
                                @endif
                            @endforeach
                        </div>
                    </div>
                    <div>
                        <x-label value="{{ __('card-manager::carma-cards.field.group') }}" />
                        <x-global-components::inputs.combo-box itemsKey="groups" :items="$filteredComboBoxData['groups']" :placeholder="__('card-manager::carma-cards.placeholder.group')"
                            :multiple="false" />
                    </div>
                    <div>
                        <x-label value="{{ __('card-manager::carma-cards.field.printer') }}" />
                        <x-global-components::inputs.combo-box itemsKey="printers" :items="$filteredComboBoxData['printers']" :placeholder="__('card-manager::carma-cards.placeholder.printer')"
                            :multiple="false" />
                        <div class="mt-2">
                            @foreach ($comboBoxData['printers'] as $index => $comboBoxPrinter)
                                @if (isset($comboBoxPrinter['isSelected']) && $comboBoxPrinter['isSelected'])
                                    <x-global-components::inputs.combo-box-badge :imageUrl="$comboBoxPrinter['image_url']" :label="$comboBoxPrinter['label'] ?? ''" itemsKey="printers"
                                        :index="$index" />
                                @endif
                            @endforeach
                        </div>
                    </div>
                </div>
            </div>
        @endif

    </x-slot>

    <x-slot:footer>
        <div class="flex items-center space-x-4">
            <button type="submit"
                class="text-white bg-primary-700 hover:bg-primary-800 focus:ring-4 focus:outline-none focus:ring-primary-300 font-medium rounded-lg text-sm px-5 py-2.5 text-center dark:bg-primary-600 dark:hover:bg-primary-700 dark:focus:ring-primary-800">
                @lang('globals::global.action.save')
            </button>
            <button type="button"
                class="text-red-600 inline-flex items-center hover:text-white border border-red-600 hover:bg-red-600 focus:ring-4 focus:outline-none focus:ring-red-300 font-medium rounded-lg text-sm px-5 py-2.5 text-center dark:border-red-500 dark:text-red-500 dark:hover:text-white dark:hover:bg-red-600 dark:focus:ring-red-900">
                <svg class="mr-1 -ml-1 w-5 h-5" fill="currentColor" viewBox="0 0 20 20"
                    xmlns="http://www.w3.org/2000/svg">
                    <path fill-rule="evenodd"
                        d="M9 2a1 1 0 00-.894.553L7.382 4H4a1 1 0 000 2v10a2 2 0 002 2h8a2 2 0 002-2V6a1 1 0 100-2h-3.382l-.724-1.447A1 1 0 0011 2H9zM7 8a1 1 0 012 0v6a1 1 0 11-2 0V8zm5-1a1 1 0 00-1 1v6a1 1 0 102 0V8a1 1 0 00-1-1z"
                        clip-rule="evenodd"></path>
                </svg>
                @lang('globals::global.action.delete')
            </button>
        </div>
    </x-slot>

    <x-slot:alpineScript>
        <script>
            document.addEventListener('alpine:init', () => {
                Alpine.data('targetDataEdit', () => ({
                    isModalVisible: false,
                    currentTab: 'main_data',

                    hide() {
                        this.isModalVisible = false;
                    },
                    show(id) {
                        this.isModalVisible = true;

                        setTimeout(() => {
                            // onShow
                        }, 100);
                    },
                }));
            });
        </script>
    </x-slot>
</x-global-components::global.modals.base>
