<?php
/**
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-module/card-manager
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

use BplanModules\CardManager\Http\Controllers\CarmaBasicController;
use BplanModules\CardManager\Http\Controllers\CarmaCardController;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Storage;


$packagePrefix = 'carma';


Route::prefix($packagePrefix)
    ->middleware([
        'web',
        'auth:sanctum',
        config('jetstream.auth_session'),
        'verified',

    ])->group(function () {
        Route::get('/basics', [CarmaBasicController::class, 'index'])->name('carma-basics');
        Route::get('/cards',  [CarmaCardController::class, 'index'])->name('carma-cards');

    }
);


Route::prefix($packagePrefix)
    ->middleware([
        'web',
        'auth:sanctum',
        config('jetstream.auth_session'),
        'verified',

    ])->group(function () {
        Route::get('card-layouts/temp/{path}', function (string $path) {
            return Storage::disk('carma-card-layouts')->download($path);

        })->name('carma-card-layouts.temp');
    }
);


Route::prefix($packagePrefix)
    ->middleware([
        'web',
        'auth:sanctum',
        config('jetstream.auth_session'),
        'verified',

    ])->group(function () {
        Route::get('/images/{filename}', function (string $filename) {
            $path = __DIR__.'/../resources/assets/img/'.$filename;

            if (!file_exists($path)) {
                abort(404);
            }
            return response()->file($path);

        })->where('filename', '.*');
    }
);
