<?php #CodeGenerator Δ 4f65191f954502bec154619638dc0547 Δ DYNAMICALLY GENERATED FILE - Do not modify this line! Remove it completely to protect the file from changes.
/**
 * Form Request Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @generated   2025-06-01 21:12:24
 * @package     bplan-modules/card-manager
 * @subpackage  FormRequests
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanModules\CardManager\Http\Requests\CarmaCards;


use BplanBase\Globals\Traits\FormRequestKeyPrefix;
use Illuminate\Foundation\Http\FormRequest;


/**
 * Form Request Class
 *
 * @version     1.0.0 / 2025-06-01
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class UpdateRequest extends FormRequest
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    use FormRequestKeyPrefix;


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var         null|string $_prefix
     */
    protected null|string $_prefix;


    /**
     * @var         int|string|null $_recordId
     */
    protected int|string|null $_recordId;


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * Get the ID
     *
     * @return      int|string|null
     *
     * @version     1.0.0 / 2025-06-01
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _resolveRecordId(): int|string|null
    {
        if ($this->_recordId !== null) {
            return $this->_recordId;
        }
        /*
            Implement the logic to get the ID out of the request.
        return $this->route('user') ?? $this->input('id');
        */
        return null;

    } // _resolveRecordId()


    /**
     * Determine if the user is authorized to make this request
     *
     * @return      bool
     *
     * @version     1.0.0 / 2025-06-01
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function authorize(): bool
    {
        return true;

    } // authorize()


    /**
     * Get the validation rules that apply to the request
     *
     * @return      array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     *
     * @version     1.0.0 / 2025-06-01
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function rules(): array
    {
        $recordId = $this->_resolveRecordId();

        $rules = [
            'active'                           => ['sometimes', 'required', 'boolean'],
            'card_layout_id'                   => ['nullable', 'integer'],
            'card_type_id'                     => ['nullable', 'integer'],
            'city'                             => ['nullable', 'string', 'max:50'],
            'company'                          => ['nullable', 'string', 'max:100'],
            'company_city'                     => ['nullable', 'string', 'max:50'],
            'company_house_number'             => ['nullable', 'string', 'max:5'],
            'company_street'                   => ['nullable', 'string', 'max:50'],
            'company_zip_code'                 => ['nullable', 'string', 'max:10'],
            'date_of_birth'                    => ['nullable'],
            'date_of_entry'                    => ['nullable'],
            'department'                       => ['nullable', 'string', 'max:20'],
            'email'                            => ['nullable', 'string', 'max:255'],
            'entity_id'                        => ['sometimes', 'required', 'integer'],
            'entity_type_id'                   => ['sometimes', 'required', 'integer'],
            'first_name'                       => ['nullable', 'string', 'max:30'],
            'form_of_address'                  => ['nullable', 'string', 'max:10'],
            'function'                         => ['nullable', 'string', 'max:20'],
            'group_id'                         => ['nullable', 'integer'],
            'house_number'                     => ['nullable', 'string', 'max:5'],
            'identification_number'            => ['nullable', 'string', 'max:25'],
            'last_name'                        => ['nullable', 'string', 'max:30'],
            'location'                         => ['nullable', 'string', 'max:100'],
            'mobile_phone_number'              => ['nullable', 'string', 'max:20'],
            'mobile_phone_number_country_code' => ['nullable', 'string', 'max:4'],
            'personnel_number'                 => ['nullable', 'string', 'max:10'],
            'phone_number'                     => ['nullable', 'string', 'max:20'],
            'phone_number_country_code'        => ['nullable', 'string', 'max:4'],
            'photo'                            => ['nullable', 'string', 'max:255'],
            'printer_id'                       => ['nullable', 'integer'],
            'street'                           => ['nullable', 'string', 'max:50'],
            'zip_code'                         => ['nullable', 'string', 'max:10'],

        ];
        if ($this->_prefix === null) {
            return $rules;
        }
        return $this->_prependValidationRuleKeys($rules, $this->_prefix);

    } // rules()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * Set the ID and get the validation rules that apply to the request
     *
     * @param       int|string $recordId
     *
     * @param       null|string $prefix
     *
     * @return      array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     *
     * @version     1.0.0 / 2025-06-01
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public static function getRules(int|string $recordId, null|string $prefix = null): array
    {
        $Instance = new static();

        $Instance->_recordId = $recordId;
        $Instance->_prefix = $prefix;

        return $Instance->rules();

    } // getRules()


} // class UpdateRequest extends FormRequest {}
