<?php #CodeGenerator Δ 1c2333840c87497882c43ca2c3002bff Δ DYNAMICALLY GENERATED FILE - Do not modify this line! Remove it completely to protect the file from changes.
/**
 * JSON:API Schema Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @generated   2025-05-18 20:28:29
 * @package     bplan-modules/card-manager
 * @subpackage  Schemas
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanModules\CardManager\JsonApi\Data\CarmaCards;


use BplanModules\CardManager\Models\CarmaCard;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Http\Request;
use LaravelJsonApi\Eloquent\Contracts\Paginator;
use LaravelJsonApi\Eloquent\Fields\Boolean;
use LaravelJsonApi\Eloquent\Fields\DateTime;
use LaravelJsonApi\Eloquent\Fields\ID;
use LaravelJsonApi\Eloquent\Fields\Number;
use LaravelJsonApi\Eloquent\Fields\Relations\BelongsTo;
use LaravelJsonApi\Eloquent\Fields\Str;
use LaravelJsonApi\Eloquent\Filters\WhereIdIn;
use LaravelJsonApi\Eloquent\Pagination\PagePagination;
use LaravelJsonApi\Eloquent\Schema;


/**
 * JSON:API Schema Class
 *
 * @version     2.2.0 / 2025-05-18
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class CarmaCardSchema extends Schema
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * The maximum include path depth.
     *
     * @var int
     */
    protected int $maxDepth = 2;


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * The model the schema corresponds to.
     *
     * @var         string
     */
    public static string $model = CarmaCard::class;


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * Get the resource fields.
     *
     * @return      array
     *
     * @version     1.3.0 / 2025-05-18
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function fields(): array
    {

        $timezone = config('app.timezone');

        return [
            ID::make(),

            Boolean::make('active')->sortable(),
            DateTime::make('createdAt')->serializeUsing(
                static fn($value) => $value ? Carbon::parse($value)->setTimezone($timezone)->format('c') : null
            )->readOnly()->sortable(),

            DateTime::make('deletedAt')->serializeUsing(
                static fn($value) => $value ? Carbon::parse($value)->setTimezone($timezone)->format('c') : null
            )->readOnly()->sortable(),

            DateTime::make('updatedAt')->serializeUsing(
                static fn($value) => $value ? Carbon::parse($value)->setTimezone($timezone)->format('c') : null
            )->readOnly()->sortable(),

            Str::make('uuid')->readOnly()->sortable(),

            Str::make('city'),
            Str::make('company'),
            Str::make('companyCity'),
            Str::make('companyHouseNumber'),
            Str::make('companyStreet'),
            Str::make('companyZipCode'),
            Str::make('dateOfBirth'),
            Str::make('dateOfEntry'),
            Str::make('department'),
            Str::make('email'),
            Number::make('entityId'),
            Str::make('firstName'),
            Str::make('formOfAddress'),
            Str::make('function'),
            Str::make('houseNumber'),
            Str::make('identificationNumber'),
            Str::make('lastName'),
            Str::make('location'),
            Str::make('mobilePhoneNumber'),
            Str::make('mobilePhoneNumberCountryCode'),
            Str::make('personnelNumber'),
            Str::make('phoneNumber'),
            Str::make('phoneNumberCountryCode'),
            Str::make('photo'),
            Str::make('street'),
            Str::make('zipCode'),
            /*
            **  Appended fields */
            Str::make('photoUrl'),
            /*
            **  Relations */
            BelongsTo::make('card-layout')->type('carma-card-layouts')->serializeUsing(
                static fn($Relation) => $Relation->alwaysShowData()
            ),
            BelongsTo::make('card-type')->type('carma-card-types')->serializeUsing(
                static fn($Relation) => $Relation->alwaysShowData()
            ),
            BelongsTo::make('entity-type')->type('entity-types')->serializeUsing(
                static fn($Relation) => $Relation->alwaysShowData()
            ),
            BelongsTo::make('group')->type('carma-groups')->serializeUsing(
                static fn($Relation) => $Relation->alwaysShowData()
            ),
            BelongsTo::make('printer')->type('carma-printers')->serializeUsing(
                static fn($Relation) => $Relation->alwaysShowData()
            ),

        ];
    } // fields()


    /**
     * Get the resource filters.
     *
     * @return      array
     *
     * @version     1.0.0 / 2025-05-18
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function filters(): array
    {
        return [
            WhereIdIn::make($this),
        ];
    } // filters()


    /**
     * Build an index query for this resource.
     *
     * @param       Request|null $Request
     *
     * @param       Builder $Query
     *
     * @return      Builder

     * @version     1.0.0 / 2025-05-18
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function indexQuery(?Request $Request, Builder $Query): Builder
    {
        return $Query->where(function (Builder $Query) {
            return $Query;
        });
    } // indexQuery()


    /**
     * Get the resource paginator.
     *
     * @return      null|Paginator
     *
     * @version     1.0.0 / 2025-05-18
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function pagination(): ?Paginator
    {
        return PagePagination::make();

    } // pagination()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class CarmaCardSchema extends Schema {}
