<?php
/**
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-module/card-manager
 * @subpackage  LivewireComponent
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanModules\CardManager\Livewire\CarmaCardTypes\Modals;


use App\Helpers\LogHelper;
use BplanModules\CardManager\Services\CarmaCardTypeService;
use Livewire\Component;


/**
 * @version     1.0.0 / 2025-03-14
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 */
class Add extends Component
{
    public string $chiptype;
    public string $labeling;
    public string $memory;
    public string $frequency;

    protected CarmaCardTypeService $carmaCardTypeService;

    public function boot(CarmaCardTypeService $carmaCardTypeService)
    {
        $this->carmaCardTypeService = $carmaCardTypeService;
    }

    public function render()
    {
        return view('card-manager::livewire.carma-card-types.modals.add');
    }

    public function add()
    {
        try {
            $this->carmaCardTypeService->create([
                'chip_type' => $this->chiptype,
                'labeling' => $this->labeling,
                'memory' => $this->memory,
                'frequency' => $this->frequency,
            ]);
            $this->dispatch('card-type-added');

        } catch (\Throwable $th) {
            LogHelper::logException($th);
        }
    }
}
