<?php
/**
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-module/card-manager
 * @subpackage  LivewireComponent
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanModules\CardManager\Livewire\CarmaCards\Modals;


use App\Traits\WithComboBoxInput;
use BplanBase\EntityType\Models\EntityType;
use BplanBase\EntityType\Models\EntityTypeFieldDefinition;
use BplanModules\CardManager\Models\CarmaCardLayout;
use BplanModules\CardManager\Models\CarmaCardType;
use BplanModules\CardManager\Models\CarmaGroup;
use BplanModules\CardManager\Models\CarmaPrinter;
use BplanModules\CardManager\Services\CarmaCardService;
use BplanModules\CardManager\Traits\WithCarmaFields;
use Illuminate\Database\Eloquent\Collection;
use Livewire\Component;
use Illuminate\Support\Str;


/**
 * @version     1.0.0 / 2025-03-14
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 */
class Edit extends Component
{
    use WithComboBoxInput;
    use WithCarmaFields;

    public ?Collection $fieldDefinition;

    protected CarmaCardService $carmaCardService;

    public function rules()
    {
        foreach ($this->fieldDefinition as $fieldDefinitionIndex => $fieldDefinition) {
            if($fieldDefinition->active && $fieldDefinition->mandatory)
            {
                $columnCamelCase = Str::camel($fieldDefinition->identifier);
                $rules[$columnCamelCase] = 'required';
            }
        }

        return $rules;
    }

    public function boot(CarmaCardService $carmaCardService)
    {
        $this->carmaCardService = $carmaCardService;
    }

    public function mount()
    {
        $this->_setComboBoxData();
        $this->_setFieldDefinition();
    }

    public function render()
    {
        return view('card-manager::livewire.carma-cards.modals.edit');
    }

    private function _setComboBoxData()
    {
        $this->setComboBoxData('cardLayouts', CarmaCardLayout::all()->map(function ($layout) {
            return [
                'id' => $layout->id,
                'label' => $layout->name,
                // 'tag' => $cardType->labeling,
                'image_url' => $layout->preview_image_url,
            ];
        })->toArray());

        $this->setComboBoxData('cardTypes', CarmaCardType::all()->map(function ($cardType) {
            return [
                'id' => $cardType->id,
                'label' => $cardType->chip_type,
                'tag' => $cardType->labeling,
                'image_url' => asset("img/card-types/{$cardType->identifier}.png"),
            ];
        })->toArray());

        $this->setComboBoxData('groups', CarmaGroup::all()->toArray());

        $this->setComboBoxData('printers', CarmaPrinter::all()->map(function ($printer) {
            return [
                'id' => $printer->id,
                'label' => $printer->name,
                'tag' => $printer->type,
                'image_url' => asset("img/printers/{$printer->identifier}.png"),
            ];
        })->toArray());
    }

    private function _setFieldDefinition()
    {
        $this->fieldDefinition = new Collection();
        $entityType = EntityType::where('identifier', 'CarmaCard.Employee')->first();

        if(isset($entityType))
        {
            $this->fieldDefinition = $entityType->fieldDefinitions()->with('field')->get()->keyBy('field.identifier');
        }
    }
}
