<?php
/**
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-module/card-manager
 * @subpackage  LivewireComponent
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanModules\CardManager\Livewire\CarmaPrinters\Modals;


use App\Helpers\LogHelper;
use BplanModules\CardManager\Services\CarmaPrinterService;
use Livewire\Component;


/**
 * @version     1.0.0 / 2025-03-14
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 */
class Add extends Component
{
    public string $name;
    public string $type;
    public string $cardCapacity;
    public string $cardReader;
    public string $dns;

    protected CarmaPrinterService $carmaPrinterService;

    public function boot(CarmaPrinterService $carmaPrinterService)
    {
        $this->carmaPrinterService = $carmaPrinterService;
    }


    public function render()
    {
        return view('card-manager::livewire.carma-printers.modals.add');
    }

    public function add()
    {
        try {

            $this->carmaPrinterService->create([
                'name' => $this->name,
                'type' => $this->type,
                'cardCapacity' => $this->cardCapacity,
                'cardReader' => $this->cardReader,
                'dns' => $this->dns,
            ]);

            $this->dispatch('printer-added');
        } catch (\Throwable $th) {
            LogHelper::logException($th);
        }
    }
}
