<?php #CodeGenerator Δ 3c767197e2c75a4fc94c12669fefd965 Δ DYNAMICALLY GENERATED FILE - Do not modify this line! Remove it completely to protect the file from changes.
/**
 * Model Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @generated   2025-05-27 10:23:47
 * @package     bplan-modules/card-manager
 * @subpackage  Models
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanModules\CardManager\Models;


use BplanBase\Globals\Models\EntityType;
use BplanBase\Globals\Traits\HasActiveScope;
use BplanModules\CardManager\Observers\CarmaCardObserver;
use Illuminate\Database\Eloquent\Attributes\ObservedBy;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\SoftDeletes;


/**
 * Model Class
 *
 * @version     1.4.0 / 2025-05-27
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
#[ObservedBy([CarmaCardObserver::class])]
class CarmaCard extends Model
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    use HasActiveScope;
    use SoftDeletes;


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * The accessors to append to the model's array form.
     *
     * @var         array<int, string> $appends
     *
     * @version     1.0.0 / 2025-05-27
     */
    protected $appends = [
        'photo_url',
    ];


    /**
     * @var         array<string, string> $casts
     *
     * @version     1.0.0 / 2025-05-27
     */
    protected $casts = [
        'active'        => 'boolean',
        'created_at'    => 'datetime',
        'date_of_birth' => 'date',
        'date_of_entry' => 'date',
        'deleted_at'    => 'datetime',
        'updated_at'    => 'datetime',
    ];


    /**
     * The attributes that are mass assignable.
     *
     * @var         array<int, string> $fillable
     *
     * @version     1.0.0 / 2025-05-27
     */
    protected $fillable = [
        'active',
        'card_layout_id',
        'card_type_id',
        'city',
        'company',
        'company_city',
        'company_house_number',
        'company_street',
        'company_zip_code',
        'date_of_birth',
        'date_of_entry',
        'department',
        'email',
        'entity_id',
        'entity_type_id',
        'first_name',
        'form_of_address',
        'function',
        'group_id',
        'house_number',
        'identification_number',
        'last_name',
        'location',
        'mobile_phone_number',
        'mobile_phone_number_country_code',
        'personnel_number',
        'phone_number',
        'phone_number_country_code',
        'photo',
        'printer_id',
        'street',
        'zip_code',
    ];


    /**
     * The attributes that aren't mass assignable.
     *
     * @var         array<int, string> $guarded
     *
     * @version     1.0.0 / 2025-05-27
     */
    protected $guarded = [
        'created_at',
        'deleted_at',
        'updated_at',
        'uuid',
    ];


    /**
     * The attributes that should be hidden for serialization.
     *
     * @var         array<int, string> $hidden
     *
     * @version     1.0.0 / 2025-05-27
     */
    protected $hidden = [];


    /**
     * The table associated with the model.
     *
     * @var         string $table
     */
    protected $table = 'carma_cards';


    /**
     * Indicates if the model should be timestamped.
     *
     * @var         bool $timestamps
     */
    public $timestamps = true;


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @return      BelongsTo
     *
     * @version     1.0.0 / 2025-05-27
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function cardLayout(): BelongsTo
    {
        return $this->belongsTo(CarmaCardLayout::class, 'card_layout_id');

    } // cardLayout()


    /**
     *
     * @return      BelongsTo
     *
     * @version     1.0.0 / 2025-05-27
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function cardType(): BelongsTo
    {
        return $this->belongsTo(CarmaCardType::class, 'card_type_id');

    } // cardType()


    /**
     *
     * @return      BelongsTo
     *
     * @version     1.0.0 / 2025-05-27
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function entityType(): BelongsTo
    {
        return $this->belongsTo(EntityType::class, 'entity_type_id');

    } // entityType()


    /**
     *
     * @return      mixed
     *
     * @version     1.0.0 / 2025-05-27
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function getPhotoUrlAttribute(): mixed
    {
        return null;

    } // getPhotoUrlAttribute()


    /**
     *
     * @return      BelongsTo
     *
     * @version     1.0.0 / 2025-05-27
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function group(): BelongsTo
    {
        return $this->belongsTo(CarmaGroup::class, 'group_id');

    } // group()


    /**
     *
     * @return      BelongsTo
     *
     * @version     1.0.0 / 2025-05-27
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function printer(): BelongsTo
    {
        return $this->belongsTo(CarmaPrinter::class, 'printer_id');

    } // printer()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class CarmaCard extends Model {}
