<?php
/**
 * Migration Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-modules/card-manager
 * @subpackage  Migrations
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <http://www.bplan-solutions.de/>
 * /Δ\
 */


use BplanBase\CodeGenerator\Loaders\CodeGenerator;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;


/**
 * Migration Class
 *
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
return new class extends Migration
{


    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('carma_printers');

    } // down()


    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('carma_printers', function (Blueprint $Table) {
            $Table->id();
            $Table->uuid('uuid');
            $Table->boolean('active')->default(1);

            $Table->timestamp('created_at');
            $Table->softDeletes('deleted_at');
            $Table->timestamp('updated_at');

            // Verursacht einen Fehler: Syntax error or access violation: 1075 Incorrect table definition; there can be only one auto column and it must be defined as a key
            //$Table->unsignedInteger('card_count', 30)->nullable();
            $Table->string('dns', 15)->nullable();
            $Table->string('identifier', 30)->nullable()->unique('carma_printers_UK_identifier');
            $Table->string('name', 30);
            $Table->string('reader_type', 30)->nullable();
            $Table->string('type', 30)->nullable();

            new CodeGenerator($Table, [
                'columns' => [
                    'uuid' => [
                        'guarded' => true,
                    ],
                    'active' => [
                        'sortable' => true,
                    ],
                    'card_count' => [
                        'sortable' => true,
                    ],
                    'name' => [
                        'sortable' => true,
                    ],
                    'reader_type' => [
                        'sortable' => true,
                    ],
                    'type' => [
                        'sortable' => true,
                    ],
                ],
                'routing' => [
                    'terminal' => 'readOnly',
                ],
                'traits' => [
                    'laravel.model' => [
                        'BplanBase\\Globals\Traits\\HasActiveScope',
                    ],
                ],
            ]);

        });
    } // up()


};
