<?php
/**
 * Migration Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-modules/card-manager
 * @subpackage  Migrations
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <http://www.bplan-solutions.de/>
 * /Δ\
 */


use BplanBase\CodeGenerator\Loaders\CodeGenerator;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;


/**
 * Migration Class
 *
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
return new class extends Migration
{


    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('carma_groups');

    } // down()


    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('carma_groups', function (Blueprint $Table) {
            $Table->id();
            $Table->uuid('uuid');
            $Table->boolean('active')->default(1);

            $Table->timestamp('created_at');
            $Table->softDeletes('deleted_at');
            $Table->timestamp('updated_at');

            $Table->foreignId('card_layout_id')->nullable()->constrained(table: 'carma_card_layouts', indexName: 'carma_groups_FK_card_layout_id');
            $Table->foreignId('card_type_id')->nullable()->constrained(table: 'carma_card_types', indexName: 'carma_groups_FK_card_type_id');
            $Table->foreignId('printer_id')->nullable()->constrained(table: 'carma_printers', indexName: 'carma_groups_FK_printer_id');

            $Table->index('card_layout_id', 'carma_groups_FKI_card_layout_id');
            $Table->index('card_type_id',   'carma_groups_FKI_card_type_id');
            $Table->index('printer_id',     'carma_groups_FKI_printer_id');

            new CodeGenerator($Table, [
                'columns' => [
                    'uuid' => [
                        'guarded' => true,
                    ],
                    'active' => [
                        'sortable' => true,
                    ],
                    'card_layout_id' => [
                        'sortable' => true,
                    ],
                    'card_type_id' => [
                        'sortable' => true,
                    ],
                    'printer_id' => [
                        'sortable' => true,
                    ],
                ],
                'routing' => [
                    'terminal' => 'readOnly',
                ],
                'traits' => [
                    'laravel.model' => [
                        'BplanBase\\Globals\Traits\\HasActiveScope',
                    ],
                ],
            ]);

        });
    } // up()


};
