<?php
/**
 * Migration Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-modules/card-manager
 * @subpackage  Migrations
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <http://www.bplan-solutions.de/>
 * /Δ\
 */


use BplanBase\CodeGenerator\Loaders\CodeGenerator;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;


/**
 * Migration Class
 *
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
return new class extends Migration
{


    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('carma_cards');

    } // down()


    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('carma_cards', function (Blueprint $Table) {
            $Table->id();
            $Table->uuid('uuid');
            $Table->boolean('active')->default(1);

            $Table->timestamp('created_at');
            $Table->softDeletes('deleted_at');
            $Table->timestamp('updated_at');

            $Table->string('city', 50)->nullable();
            $Table->foreignId('card_layout_id')->nullable()->constrained(table: 'carma_card_layouts', indexName: 'carma_cards_FK_card_layout_id');
            $Table->foreignId('card_type_id')->nullable()->constrained(table: 'carma_card_types', indexName: 'carma_cards_FK_card_type_id');
            $Table->string('company', 100)->nullable();
            $Table->string('company_city', 50)->nullable();
            $Table->string('company_house_number', 5)->nullable();
            $Table->string('company_street', 50)->nullable();
            $Table->string('company_zip_code', 10)->nullable();
            $Table->date('date_of_birth')->nullable();
            $Table->date('date_of_entry')->nullable();
            $Table->string('department', 20)->nullable();
            $Table->string('email', 255)->nullable();
            $Table->unsignedInteger('entity_id');
            $Table->foreignId('entity_type_id')->constrained(table: 'entity_types', indexName: 'carma_cards_FK_entity_type_id');
            $Table->string('first_name', 30)->nullable();
            $Table->string('form_of_address', 10)->nullable();
            $Table->string('function', 20)->nullable();
            $Table->foreignId('group_id')->nullable()->constrained(table: 'carma_groups', indexName: 'carma_cards_FK_group_id');
            $Table->string('house_number', 5)->nullable();
            $Table->string('identification_number', 25)->nullable();
            $Table->string('last_name', 30)->nullable();
            $Table->string('location', 100)->nullable();
            $Table->string('mobile_phone_number', 20)->nullable();
            $Table->string('mobile_phone_number_country_code', 4)->nullable();
            $Table->string('personnel_number', 10)->nullable();
            $Table->string('phone_number', 20)->nullable();
            $Table->string('phone_number_country_code', 4)->nullable();
            $Table->foreignId('printer_id')->nullable()->constrained(table: 'carma_printers', indexName: 'carma_cards_FK_printer_id');
            $Table->string('photo', 255)->nullable();
            $Table->string('street', 50)->nullable();
            $Table->string('zip_code', 10)->nullable();

            $Table->index('card_layout_id', 'carma_cards_FKI_card_layout_id');
            $Table->index('card_type_id',   'carma_cards_FKI_card_type_id');
            $Table->index('entity_type_id', 'carma_cards_FKI_entity_type_id');
            $Table->index('printer_id',     'carma_cards_FKI_printer_id');

            new CodeGenerator($Table, [
                'appends' => [
                    /*
                    **  Es wird aktuell nur der Methodenrumpf erzeugt. */
                    'photo_url' => CodeGenerator::APPENDS_JSONAPI_SCHEMA + CodeGenerator::APPENDS_LARAVEL_MODEL_ARRAY + CodeGenerator::APPENDS_LARAVEL_MODEL_METHOD,
                ],
                'columns' => [
                    'uuid' => [
                        'guarded' => true,
                    ],
                    'active' => [
                        'sortable' => true,
                    ],
                ],
                'entity-type' => true,
                'routing' => [
                    'terminal' => 'readOnly',
                ],
                'traits' => [
                    'laravel.model' => [
                        'BplanBase\\Globals\Traits\\HasActiveScope',
                    ],
                ],
            ]);

        });
    } // up()


};
