<?php
/**
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-modules/card-manager
 * @subpackage  Seeders
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanModules\CardManager\Database\Seeders;


use BplanModules\CardManager\Models\CarmaCardType;
use Illuminate\Database\Seeder;
use Illuminate\Support\Str;


/**
 *
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class CarmaCardTypeSeeder extends Seeder
{

    /**
     * Run the database seeds.
     *
     * @return      void
     *
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function run()
    {

        $date = date('Y-m-d H:i:s');

        CarmaCardType::insert([
            [
                'uuid' => Str::uuid(),
                'active' => 1,
                'created_at' => $date,
                'updated_at' => $date,
                'deleted_at' => null,
                'chip_type' => 'Mifare Desfire EV1',
                'frequency' => 13.56,
                'identifier' => 'mifare',
                'iso' => null,
                'labeling' => 'MF3ICD41',
                'memory' => 4096,
            ], [
                'uuid' => Str::uuid(),
                'active' => 1,
                'created_at' => $date,
                'updated_at' => $date,
                'deleted_at' => null,
                'chip_type' => 'Wallet',
                'frequency' => null,
                'identifier' => 'wallet',
                'iso' => null,
                'labeling' => 'PKPassSample',
                'memory' => null,
            ],

        ]);

    } // run()

} // class CarmaCardTypeSeeder extends Seeder {}
