<?php
/**
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-modules/card-manager
 * @subpackage  Seeders
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanModules\CardManager\Database\Seeders;


use BplanModules\CardManager\Models\CarmaPrinter;
use Illuminate\Database\Seeder;
use Illuminate\Support\Str;


/**
 *
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class CarmaPrinterSeeder extends Seeder
{

    /**
     * Run the database seeds.
     *
     * @return      void
     *
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function run()
    {
        $date = date('Y-m-d H:i:s');

        CarmaPrinter::insert([
            [
                'uuid' => Str::uuid(),
                'active' => 1,
                'created_at' => '2025-02-26 13:51:02',
                'updated_at' => '2025-02-26 13:51:02',
                'deleted_at' => null,
                'dns' => '198.168.178.1',
                'identifier' => 'evolis_kc_prime',
                'name' => 'KC Prime',
                'reader_type' => null,
                'type' => 'Evolis',
            ],

        ]);

    } // run()

} // class CarmaPrinterSeeder extends Seeder {}
