<?php
/**
 * Seeder Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-modules/card-manager
 * @subpackage  Seeders
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanModules\CardManager\Database\Seeders;


use Illuminate\Database\Seeder;


/**
 * Seeder Class
 *
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class DatabaseSeeder extends Seeder
{


    /**
     * Seed the application's database.
     */
    public function run(): void
    {
        $env = strtolower(config('app.env'));

        $seeds = [
            RegisterModuleSeeder::class,
            RegisterEntityTypeModelSeeder::class,
            RegisterEntityTypeSeeder::class,
            RegisterEntityTypeFieldSeeder::class,

            CarmaCardTypeSeeder::class,
            CarmaPrinterSeeder::class,

        ];
        if ($env === 'production') {
            //

        } elseif (str_starts_with($env, 'demo') === true) {
            $seeds[] = Dev\CarmaCardLayoutSeeder::class;

        } else {
            //

        }
        $this->call($seeds);

    } // run()


} // class DatabaseSeeder extends Seeder
