<?php
/**
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-modules/card-manager
 * @subpackage  Seeders
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanModules\CardManager\Database\Seeders;

use BplanBase\Globals\Models\EntityType;
use BplanBase\Globals\Models\EntityTypeField;
use Illuminate\Database\Seeder;
use Illuminate\Support\Str;


/**
 *
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class RegisterEntityTypeFieldSeeder extends Seeder
{

    /**
     * Run the database seeds.
     *
     * @return      void
     *
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function run()
    {
        //$entitTypes = EntityTypeField::where('')->get();

        $date = date('Y-m-d H:i:s');

        $EntityType = EntityType::where('identifier', '=', 'CarmaCard')->first();

        EntityTypeField::insert([
            [
                'uuid' => Str::uuid(),
                'active' => 1,
                'created_at' => $date,
                'updated_at' => $date,
                'deleted_at' => null,
                'api_field_name' => null,
                'db_field_name' => 'city',
                'entity_type_id' => $EntityType->id,
                'identifier' => 'City',
            ],
            [
                'uuid' => Str::uuid(),
                'active' => 1,
                'created_at' => $date,
                'updated_at' => $date,
                'deleted_at' => null,
                'api_field_name' => null,
                'db_field_name' => 'card_layout_id',
                'entity_type_id' => $EntityType->id,
                'identifier' => 'CardLayoutId',
            ],
            [
                'uuid' => Str::uuid(),
                'active' => 1,
                'created_at' => $date,
                'updated_at' => $date,
                'deleted_at' => null,
                'api_field_name' => null,
                'db_field_name' => 'card_type_id',
                'entity_type_id' => $EntityType->id,
                'identifier' => 'CardTypeId',
            ],
            [
                'uuid' => Str::uuid(),
                'active' => 1,
                'created_at' => $date,
                'updated_at' => $date,
                'deleted_at' => null,
                'api_field_name' => null,
                'db_field_name' => 'company',
                'entity_type_id' => $EntityType->id,
                'identifier' => 'Company',
            ],
            [
                'uuid' => Str::uuid(),
                'active' => 1,
                'created_at' => $date,
                'updated_at' => $date,
                'deleted_at' => null,
                'api_field_name' => null,
                'db_field_name' => 'company_city',
                'entity_type_id' => $EntityType->id,
                'identifier' => 'CompanyCity',
            ],
            [
                'uuid' => Str::uuid(),
                'active' => 1,
                'created_at' => $date,
                'updated_at' => $date,
                'deleted_at' => null,
                'api_field_name' => null,
                'db_field_name' => 'company_house_number',
                'entity_type_id' => $EntityType->id,
                'identifier' => 'CompanyHouseNumber',
            ],
            [
                'uuid' => Str::uuid(),
                'active' => 1,
                'created_at' => $date,
                'updated_at' => $date,
                'deleted_at' => null,
                'api_field_name' => null,
                'db_field_name' => 'company_street',
                'entity_type_id' => $EntityType->id,
                'identifier' => 'CompanyStreet',
            ],
            [
                'uuid' => Str::uuid(),
                'active' => 1,
                'created_at' => $date,
                'updated_at' => $date,
                'deleted_at' => null,
                'api_field_name' => null,
                'db_field_name' => 'company_zip_code',
                'entity_type_id' => $EntityType->id,
                'identifier' => 'CompanyZipCode',
            ],
            [
                'uuid' => Str::uuid(),
                'active' => 1,
                'created_at' => $date,
                'updated_at' => $date,
                'deleted_at' => null,
                'api_field_name' => null,
                'db_field_name' => 'date_of_birth',
                'entity_type_id' => $EntityType->id,
                'identifier' => 'DateOfBirth',
            ],
            [
                'uuid' => Str::uuid(),
                'active' => 1,
                'created_at' => $date,
                'updated_at' => $date,
                'deleted_at' => null,
                'api_field_name' => null,
                'db_field_name' => 'date_of_entry',
                'entity_type_id' => $EntityType->id,
                'identifier' => 'DateOfEntry',
            ],
            [
                'uuid' => Str::uuid(),
                'active' => 1,
                'created_at' => $date,
                'updated_at' => $date,
                'deleted_at' => null,
                'api_field_name' => null,
                'db_field_name' => 'department',
                'entity_type_id' => $EntityType->id,
                'identifier' => 'Department',
            ],
            [
                'uuid' => Str::uuid(),
                'active' => 1,
                'created_at' => $date,
                'updated_at' => $date,
                'deleted_at' => null,
                'api_field_name' => null,
                'db_field_name' => 'email',
                'entity_type_id' => $EntityType->id,
                'identifier' => 'Email',
            ],
            [
                'uuid' => Str::uuid(),
                'active' => 1,
                'created_at' => $date,
                'updated_at' => $date,
                'deleted_at' => null,
                'api_field_name' => null,
                'db_field_name' => 'first_name',
                'entity_type_id' => $EntityType->id,
                'identifier' => 'FirstName',
            ],
            [
                'uuid' => Str::uuid(),
                'active' => 1,
                'created_at' => $date,
                'updated_at' => $date,
                'deleted_at' => null,
                'api_field_name' => null,
                'db_field_name' => 'form_of_address',
                'entity_type_id' => $EntityType->id,
                'identifier' => 'FormOfAddress',
            ],
            [
                'uuid' => Str::uuid(),
                'active' => 1,
                'created_at' => $date,
                'updated_at' => $date,
                'deleted_at' => null,
                'api_field_name' => null,
                'db_field_name' => 'function',
                'entity_type_id' => $EntityType->id,
                'identifier' => 'Function',
            ],
            [
                'uuid' => Str::uuid(),
                'active' => 1,
                'created_at' => $date,
                'updated_at' => $date,
                'deleted_at' => null,
                'api_field_name' => null,
                'db_field_name' => 'group_id',
                'entity_type_id' => $EntityType->id,
                'identifier' => 'GroupId',
            ],
            [
                'uuid' => Str::uuid(),
                'active' => 1,
                'created_at' => $date,
                'updated_at' => $date,
                'deleted_at' => null,
                'api_field_name' => null,
                'db_field_name' => 'house_number',
                'entity_type_id' => $EntityType->id,
                'identifier' => 'HouseNumber',
            ],
            [
                'uuid' => Str::uuid(),
                'active' => 1,
                'created_at' => $date,
                'updated_at' => $date,
                'deleted_at' => null,
                'api_field_name' => null,
                'db_field_name' => 'identification_number',
                'entity_type_id' => $EntityType->id,
                'identifier' => 'IdentificationNumber',
            ],
            [
                'uuid' => Str::uuid(),
                'active' => 1,
                'created_at' => $date,
                'updated_at' => $date,
                'deleted_at' => null,
                'api_field_name' => null,
                'db_field_name' => 'last_name',
                'entity_type_id' => $EntityType->id,
                'identifier' => 'LastName',
            ],
            [
                'uuid' => Str::uuid(),
                'active' => 1,
                'created_at' => $date,
                'updated_at' => $date,
                'deleted_at' => null,
                'api_field_name' => null,
                'db_field_name' => 'location',
                'entity_type_id' => $EntityType->id,
                'identifier' => 'Location',
            ],
            [
                'uuid' => Str::uuid(),
                'active' => 1,
                'created_at' => $date,
                'updated_at' => $date,
                'deleted_at' => null,
                'api_field_name' => null,
                'db_field_name' => 'mobile_phone_number',
                'entity_type_id' => $EntityType->id,
                'identifier' => 'MobilePhoneNumber',
            ],
            [
                'uuid' => Str::uuid(),
                'active' => 1,
                'created_at' => $date,
                'updated_at' => $date,
                'deleted_at' => null,
                'api_field_name' => null,
                'db_field_name' => 'mobile_phone_number_country_code',
                'entity_type_id' => $EntityType->id,
                'identifier' => 'MobilePhoneNumberCountryCode',
            ],
            [
                'uuid' => Str::uuid(),
                'active' => 1,
                'created_at' => $date,
                'updated_at' => $date,
                'deleted_at' => null,
                'api_field_name' => null,
                'db_field_name' => 'personnel_number',
                'entity_type_id' => $EntityType->id,
                'identifier' => 'PersonnelNumber',
            ],
            [
                'uuid' => Str::uuid(),
                'active' => 1,
                'created_at' => $date,
                'updated_at' => $date,
                'deleted_at' => null,
                'api_field_name' => null,
                'db_field_name' => 'phone_number',
                'entity_type_id' => $EntityType->id,
                'identifier' => 'PhoneNumber',
            ],
            [
                'uuid' => Str::uuid(),
                'active' => 1,
                'created_at' => $date,
                'updated_at' => $date,
                'deleted_at' => null,
                'api_field_name' => null,
                'db_field_name' => 'phone_number_country_code',
                'entity_type_id' => $EntityType->id,
                'identifier' => 'PhoneNumberCountryCode',
            ],
            [
                'uuid' => Str::uuid(),
                'active' => 1,
                'created_at' => $date,
                'updated_at' => $date,
                'deleted_at' => null,
                'api_field_name' => null,
                'db_field_name' => 'printer_id',
                'entity_type_id' => $EntityType->id,
                'identifier' => 'PrinterId',
            ],
            [
                'uuid' => Str::uuid(),
                'active' => 1,
                'created_at' => $date,
                'updated_at' => $date,
                'deleted_at' => null,
                'api_field_name' => null,
                'db_field_name' => 'street',
                'entity_type_id' => $EntityType->id,
                'identifier' => 'Street',
            ],
            [
                'uuid' => Str::uuid(),
                'active' => 1,
                'created_at' => $date,
                'updated_at' => $date,
                'deleted_at' => null,
                'api_field_name' => null,
                'db_field_name' => 'zip_code',
                'entity_type_id' => $EntityType->id,
                'identifier' => 'ZipCode',
            ],
        ]);

    } // run()

} // class RegisterFieldDefinitionSeeder extends Seeder {}
