<div x-data="basicDataIndex" class="max-w-7xl mx-auto sm:px-6 lg:px-8">
    <div class="border-b border-gray-200 dark:border-gray-700 mb-4">
        <ul class="flex flex-wrap -mb-px text-sm font-medium text-center text-gray-500 dark:text-gray-400">
            <li class="me-2">
                <button x-on:click="currentTab = 'cardTypes'"
                    :class="{
                        'text-primary-600 border-primary-600 dark:text-primary-500 dark:border-primary-500 active': currentTab ==
                            'cardTypes',
                        'border-transparent hover:text-gray-600 hover:border-gray-300 dark:hover:text-gray-300': currentTab !=
                            'cardTypes'
                    }"
                    class="inline-flex items-center justify-center p-4 border-b-2 rounded-t-lg group">
                    <svg class="size-6 me-2" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor">
                        <path d="M4.5 3.75a3 3 0 0 0-3 3v.75h21v-.75a3 3 0 0 0-3-3h-15Z" />
                        <path fill-rule="evenodd"
                            d="M22.5 9.75h-21v7.5a3 3 0 0 0 3 3h15a3 3 0 0 0 3-3v-7.5Zm-18 3.75a.75.75 0 0 1 .75-.75h6a.75.75 0 0 1 0 1.5h-6a.75.75 0 0 1-.75-.75Zm.75 2.25a.75.75 0 0 0 0 1.5h3a.75.75 0 0 0 0-1.5h-3Z"
                            clip-rule="evenodd" />
                    </svg>
                    @lang('card-manager::global.carma-card-types')
                </button>
            </li>
            <li class="me-2">
                <button x-on:click="currentTab = 'printers'"
                    :class="{
                        'text-primary-600 border-primary-600 dark:text-primary-500 dark:border-primary-500 active': currentTab ==
                            'printers',
                        'border-transparent hover:text-gray-600 hover:border-gray-300 dark:hover:text-gray-300': currentTab !=
                            'printers'
                    }"
                    class="inline-flex items-center justify-center p-4 border-b-2 rounded-t-lg group">
                    <svg class="size-6 me-2" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor">
                        <path fill-rule="evenodd"
                            d="M7.875 1.5C6.839 1.5 6 2.34 6 3.375v2.99c-.426.053-.851.11-1.274.174-1.454.218-2.476 1.483-2.476 2.917v6.294a3 3 0 0 0 3 3h.27l-.155 1.705A1.875 1.875 0 0 0 7.232 22.5h9.536a1.875 1.875 0 0 0 1.867-2.045l-.155-1.705h.27a3 3 0 0 0 3-3V9.456c0-1.434-1.022-2.7-2.476-2.917A48.716 48.716 0 0 0 18 6.366V3.375c0-1.036-.84-1.875-1.875-1.875h-8.25ZM16.5 6.205v-2.83A.375.375 0 0 0 16.125 3h-8.25a.375.375 0 0 0-.375.375v2.83a49.353 49.353 0 0 1 9 0Zm-.217 8.265c.178.018.317.16.333.337l.526 5.784a.375.375 0 0 1-.374.409H7.232a.375.375 0 0 1-.374-.409l.526-5.784a.373.373 0 0 1 .333-.337 41.741 41.741 0 0 1 8.566 0Zm.967-3.97a.75.75 0 0 1 .75-.75h.008a.75.75 0 0 1 .75.75v.008a.75.75 0 0 1-.75.75H18a.75.75 0 0 1-.75-.75V10.5ZM15 9.75a.75.75 0 0 0-.75.75v.008c0 .414.336.75.75.75h.008a.75.75 0 0 0 .75-.75V10.5a.75.75 0 0 0-.75-.75H15Z"
                            clip-rule="evenodd" />
                    </svg>

                    @lang('card-manager::global.carma-printers')
                </button>
            </li>
            <li class="me-2">
                <button x-on:click="currentTab = 'connectors'"
                    :class="{
                        'text-primary-600 border-primary-600 dark:text-primary-500 dark:border-primary-500 active': currentTab ==
                            'connectors',
                        'border-transparent hover:text-gray-600 hover:border-gray-300 dark:hover:text-gray-300': currentTab !=
                            'connectors'
                    }"
                    class="inline-flex items-center justify-center p-4 border-b-2 rounded-t-lg group">
                    <svg class="size-6 me-2" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                        stroke-width="1.5" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round"
                            d="M13.19 8.688a4.5 4.5 0 0 1 1.242 7.244l-4.5 4.5a4.5 4.5 0 0 1-6.364-6.364l1.757-1.757m13.35-.622 1.757-1.757a4.5 4.5 0 0 0-6.364-6.364l-4.5 4.5a4.5 4.5 0 0 0 1.242 7.244" />
                    </svg>
                    @lang('card-manager::global.connectors')
                </button>
            </li>
            <li class="me-2">
                <button x-on:click="currentTab = 'layouts'"
                    :class="{
                        'text-primary-600 border-primary-600 dark:text-primary-500 dark:border-primary-500 active': currentTab ==
                            'layouts',
                        'border-transparent hover:text-gray-600 hover:border-gray-300 dark:hover:text-gray-300': currentTab !=
                            'layouts'
                    }"
                    class="inline-flex items-center justify-center p-4 border-b-2 rounded-t-lg group">
                    <svg class="size-6 me-2" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor">
                        <path fill-rule="evenodd"
                            d="M1.5 7.125c0-1.036.84-1.875 1.875-1.875h6c1.036 0 1.875.84 1.875 1.875v3.75c0 1.036-.84 1.875-1.875 1.875h-6A1.875 1.875 0 0 1 1.5 10.875v-3.75Zm12 1.5c0-1.036.84-1.875 1.875-1.875h5.25c1.035 0 1.875.84 1.875 1.875v8.25c0 1.035-.84 1.875-1.875 1.875h-5.25a1.875 1.875 0 0 1-1.875-1.875v-8.25ZM3 16.125c0-1.036.84-1.875 1.875-1.875h5.25c1.036 0 1.875.84 1.875 1.875v2.25c0 1.035-.84 1.875-1.875 1.875h-5.25A1.875 1.875 0 0 1 3 18.375v-2.25Z"
                            clip-rule="evenodd" />
                    </svg>

                    @lang('card-manager::global.carma-card-layouts')
                </button>
            </li>
        </ul>
    </div>


    {{-- TABS --}}

    {{-- cardTypes --}}
    <div x-show="currentTab == 'cardTypes'">
        <livewire:card-manager::carma-card-types.index />
        <livewire:card-manager::carma-card-types.modals.create />
    </div>

    {{-- printers --}}
    <div x-show="currentTab == 'printers'" x-cloak>
        <livewire:card-manager::carma-printers.index />
        <livewire:card-manager::carma-printers.modals.create />
    </div>

    {{-- layouts --}}
    <div x-show="currentTab == 'layouts'" x-cloak>
        <livewire:card-manager::carma-card-layouts.index />
        <livewire:card-manager::carma-card-layouts.modals.create />
    </div>

    <script>
        document.addEventListener('alpine:init', () => {
            Alpine.data('basicDataIndex', () => ({
                visible: false,
                currentTab: 'cardTypes',

                hide() {
                    this.visible = false;
                },
                show(id) {
                    this.visible = true;

                    setTimeout(() => {
                        // document.getElementById('firstname').focus();
                    }, 100);
                },
            }));
        });
    </script>

</div>
