<x-global-components::global.modals.base name="targetDataImport" x-on:show-carma-cards-import-modal.window="show">
    <x-slot:header>
        <x-global-components::global.modals.base-header>
            <x-slot:icon>
                <svg class="size-6" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5"
                    stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round"
                        d="M9 8.25H7.5a2.25 2.25 0 0 0-2.25 2.25v9a2.25 2.25 0 0 0 2.25 2.25h9a2.25 2.25 0 0 0 2.25-2.25v-9a2.25 2.25 0 0 0-2.25-2.25H15m0-3-3-3m0 0-3 3m3-3V15" />
                </svg>
            </x-slot>

            <x-slot:title>
                Zieldaten importieren
            </x-slot>
        </x-global-components::global.modals.base-header>
    </x-slot>

    <x-slot:body>
        <div class="mb-4">

            <x-global-components::inputs.file-input label="Importdatei" />
            <p class="mt-1 text-sm text-gray-500 dark:text-gray-300" id="file_input_help">
                @lang('card-manager::carma-cards.hint.import-file-types')
            </p>


            <!-- Progress Bar -->
            <div x-show="uploading">
                <progress max="100" x-bind:value="progress"></progress>
            </div>
        </div>
    </x-slot>

    <x-slot:footer>
        <button x-on:click="sync()"
            class="text-white inline-flex w-full justify-center bg-primary-700 hover:bg-primary-800 focus:ring-4 focus:outline-none focus:ring-primary-300 font-medium rounded-lg text-sm px-5 py-2.5 text-center dark:bg-primary-600 dark:hover:bg-primary-700 dark:focus:ring-primary-800">
            Import
        </button>
    </x-slot>

    <x-slot:alpineScript>
        <script>
            document.addEventListener('alpine:init', () => {
                Alpine.data('targetDataImport', () => ({
                    isModalVisible: false,

                    hide() {
                        this.isModalVisible = false;
                    },
                    show(id) {
                        this.isModalVisible = true;

                        setTimeout(() => {
                            // onShow
                        }, 100);
                    },
                }));
            });
        </script>
    </x-slot>
</x-global-components::global.modals.base>
