<x-global-components::global.modals.base name="targetDataPrintObj" x-on:show-carma-cards-print-obj-modal.window="show">
    <x-slot:header>
        <x-global-components::global.modals.base-header>
            <x-slot:icon>
                <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5"
                    stroke="currentColor" class="size-6">
                    <path stroke-linecap="round" stroke-linejoin="round"
                        d="M6.72 13.829c-.24.03-.48.062-.72.096m.72-.096a42.415 42.415 0 0 1 10.56 0m-10.56 0L6.34 18m10.94-4.171c.24.03.48.062.72.096m-.72-.096L17.66 18m0 0 .229 2.523a1.125 1.125 0 0 1-1.12 1.227H7.231c-.662 0-1.18-.568-1.12-1.227L6.34 18m11.318 0h1.091A2.25 2.25 0 0 0 21 15.75V9.456c0-1.081-.768-2.015-1.837-2.175a48.055 48.055 0 0 0-1.913-.247M6.34 18H5.25A2.25 2.25 0 0 1 3 15.75V9.456c0-1.081.768-2.015 1.837-2.175a48.041 48.041 0 0 1 1.913-.247m10.5 0a48.536 48.536 0 0 0-10.5 0m10.5 0V3.375c0-.621-.504-1.125-1.125-1.125h-8.25c-.621 0-1.125.504-1.125 1.125v3.659M18 10.5h.008v.008H18V10.5Zm-3 0h.008v.008H15V10.5Z" />
                </svg>
            </x-slot>

            <x-slot:title>
                Zieldatensatz drucken
            </x-slot>
        </x-global-components::global.modals.base-header>
    </x-slot>

    <x-slot:body>
        {{-- PRINT --}}
        <div x-show="!loading && !printTriggered">
            <p class="text-gray-500 dark:text-gray-400 mb-4">Bitte wählen Sie den gewünschten Drucker aus:</p>
            <ul class="space-y-4 mb-4" x-data="{checked: null}">
                <li>
                    <input type="radio" name="printer" id="printer-1" value="printer-1" x-model="checked" class="hidden peer" />
                    <label for="printer-1"
                        class="inline-flex items-center justify-between w-full p-5 text-gray-900 bg-white border border-gray-200 rounded-lg cursor-pointer dark:hover:text-gray-300 dark:border-gray-500 dark:peer-checked:text-primary-500 peer-checked:border-primary-600 dark:peer-checked:border-primary-600 peer-checked:text-primary-600 hover:text-gray-900 hover:bg-gray-100 dark:text-white dark:bg-gray-600 dark:hover:bg-gray-500">
                        <div class="block">
                            <div class="w-full text-lg font-semibold">KC Prime</div>
                            <div class="w-full text-gray-500 dark:text-gray-400">Köln, Obergeschoss</div>
                        </div>
                        <svg x-show="checked == 'printer-1'" class="size-5 text-primary-600" viewBox="0 0 20 20" fill="currentColor" aria-hidden="true"
                            data-slot="icon">
                            <path fill-rule="evenodd"
                                d="M10 18a8 8 0 1 0 0-16 8 8 0 0 0 0 16Zm3.857-9.809a.75.75 0 0 0-1.214-.882l-3.483 4.79-1.88-1.88a.75.75 0 1 0-1.06 1.061l2.5 2.5a.75.75 0 0 0 1.137-.089l4-5.5Z"
                                clip-rule="evenodd" />
                        </svg>
                    </label>
                </li>
                <li>
                    <input type="radio" name="printer" id="printer-2" value="printer-2" x-model="checked" class="hidden peer" />
                    <label for="printer-2"
                        class="inline-flex items-center justify-between w-full p-5 text-gray-900 bg-white border border-gray-200 rounded-lg cursor-pointer dark:hover:text-gray-300 dark:border-gray-500 dark:peer-checked:text-primary-500 peer-checked:border-primary-600 dark:peer-checked:border-primary-600 peer-checked:text-primary-600 hover:text-gray-900 hover:bg-gray-100 dark:text-white dark:bg-gray-600 dark:hover:bg-gray-500">
                        <div class="block">
                            <div class="w-full text-lg font-semibold">Primacy</div>
                            <div class="w-full text-gray-500 dark:text-gray-400">Köln, Obergeschoss</div>
                        </div>
                        <svg x-show="checked == 'printer-2'" class="size-5 text-primary-600" viewBox="0 0 20 20" fill="currentColor" aria-hidden="true"
                            data-slot="icon">
                            <path fill-rule="evenodd"
                                d="M10 18a8 8 0 1 0 0-16 8 8 0 0 0 0 16Zm3.857-9.809a.75.75 0 0 0-1.214-.882l-3.483 4.79-1.88-1.88a.75.75 0 1 0-1.06 1.061l2.5 2.5a.75.75 0 0 0 1.137-.089l4-5.5Z"
                                clip-rule="evenodd" />
                        </svg>
                    </label>
                </li>
                <li>
                    <input type="radio" name="printer" id="printer-3" value="printer-3" x-model="checked" class="hidden peer" />
                    <label for="printer-3"
                        class="inline-flex items-center justify-between w-full p-5 text-gray-900 bg-white border border-gray-200 rounded-lg cursor-pointer dark:hover:text-gray-300 dark:border-gray-500 dark:peer-checked:text-primary-500 peer-checked:border-primary-600 dark:peer-checked:border-primary-600 peer-checked:text-primary-600 hover:text-gray-900 hover:bg-gray-100 dark:text-white dark:bg-gray-600 dark:hover:bg-gray-500">
                        <div class="block">
                            <div class="w-full text-lg font-semibold">KC Prime</div>
                            <div class="w-full text-gray-500 dark:text-gray-400">Hamburg, Erdgeschoss</div>
                        </div>
                        <svg x-show="checked == 'printer-3'" class="size-5 text-primary-600" viewBox="0 0 20 20" fill="currentColor" aria-hidden="true"
                            data-slot="icon">
                            <path fill-rule="evenodd"
                                d="M10 18a8 8 0 1 0 0-16 8 8 0 0 0 0 16Zm3.857-9.809a.75.75 0 0 0-1.214-.882l-3.483 4.79-1.88-1.88a.75.75 0 1 0-1.06 1.061l2.5 2.5a.75.75 0 0 0 1.137-.089l4-5.5Z"
                                clip-rule="evenodd" />
                        </svg>
                    </label>
                </li>
            </ul>
        </div>
        {{-- LOADING SPINNER --}}
        <div class="flex items-center justify-center">
            <x-global-components::global.loading-spinner x-show="loading" />
        </div>
        {{-- PRINT SUCCESSFULLY TRIGGERD --}}
        <div x-show="!loading && printTriggered" class="text-center">
            <div
                class="w-12 h-12 rounded-full bg-green-100 dark:bg-green-900 p-2 flex items-center justify-center mx-auto mb-3.5">
                <svg aria-hidden="true" class="w-8 h-8 text-green-500 dark:text-green-400" fill="currentColor"
                    viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
                    <path fill-rule="evenodd"
                        d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z"
                        clip-rule="evenodd"></path>
                </svg>
                <span class="sr-only">Success</span>
            </div>
            <p class="mb-4 text-lg font-semibold text-gray-900 dark:text-white">
                @lang('carma-cardsprint_triggered_successfully')
            </p>
            <button x-on:click="hide()" type="button"
                class="py-2 px-3 text-sm font-medium text-center text-white rounded-lg bg-primary-600 hover:bg-primary-700 focus:ring-4 focus:outline-none focus:ring-primary-300 dark:focus:ring-primary-900">
                @lang('globals::global.action.close')
            </button>
        </div>
    </x-slot>

    <x-slot:footer>
        <button x-show="!loading && !printTriggered" x-on:click="print()"
            class="text-white inline-flex w-full justify-center bg-primary-700 hover:bg-primary-800 focus:ring-4 focus:outline-none focus:ring-primary-300 font-medium rounded-lg text-sm px-5 py-2.5 text-center dark:bg-primary-600 dark:hover:bg-primary-700 dark:focus:ring-primary-800">
            Drucken
        </button>
    </x-slot>

    <x-slot:alpineScript>
        <script>
            document.addEventListener('alpine:init', () => {
                Alpine.data('targetDataPrintObj', () => ({
                    isModalVisible: false,
                    loading: false,
                    printTriggered: false,

                    hide() {
                        this.isModalVisible = false;
                        this.loading = false;
                        this.printTriggered = false;
                    },
                    show(id) {
                        this.isModalVisible = true;

                        setTimeout(() => {
                            // onShow
                        }, 100);
                    },
                    print() {
                        this.loading = true;
                        setTimeout(() => {
                            this.loading = false;
                            this.printTriggered = true;
                        }, 1500);
                    }
                }));
            });
        </script>
    </x-slot>
</x-global-components::global.modals.base>
