<x-global-components::global.modals.base name="targetDataSync" x-on:show-carma-cards-sync-modal.window="show">
    <x-slot:header>
        <x-global-components::global.modals.base-header>
            <x-slot:icon>
                <svg class="size-6" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5"
                    stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round"
                        d="M19.5 12c0-1.232-.046-2.453-.138-3.662a4.006 4.006 0 0 0-3.7-3.7 48.678 48.678 0 0 0-7.324 0 4.006 4.006 0 0 0-3.7 3.7c-.017.22-.032.441-.046.662M19.5 12l3-3m-3 3-3-3m-12 3c0 1.232.046 2.453.138 3.662a4.006 4.006 0 0 0 3.7 3.7 48.656 48.656 0 0 0 7.324 0 4.006 4.006 0 0 0 3.7-3.7c.017-.22.032-.441.046-.662M4.5 12l3 3m-3-3-3 3" />
                </svg>
            </x-slot>

            <x-slot:title>
                Zieldaten synchronisieren
            </x-slot>
        </x-global-components::global.modals.base-header>
    </x-slot>

    <x-slot:body>
        <div class="p-4 md:p-5" x-show="!loading && !syncTriggered">
            <p class="text-sm font-normal text-gray-500 dark:text-gray-400">
                Sync your targetdata with
            </p>
            <ul class="my-4 space-y-3">
                <li x-data="{checked: false}">
                    <input type="checkbox" id="job-1" class="hidden peer" x-model="checked" />
                    <label for="job-1"
                        class="inline-flex items-center justify-between w-full p-5 text-gray-900 bg-white border border-gray-200 rounded-lg cursor-pointer dark:hover:text-gray-300 dark:border-gray-500 dark:peer-checked:text-primary-500 peer-checked:border-primary-600 dark:peer-checked:border-primary-600 peer-checked:text-primary-600 hover:text-gray-900 hover:bg-gray-100 dark:text-white dark:bg-gray-600 dark:hover:bg-gray-500">
                        <img class="size-4"
                            src="data:image/webp;base64,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"
                            alt="image" />
                        <span class="flex-1 ms-3 whitespace-nowrap">Azure</span>
                        <svg x-show="checked" class="size-5 text-primary-600" viewBox="0 0 20 20" fill="currentColor" aria-hidden="true"
                            data-slot="icon">
                            <path fill-rule="evenodd"
                                d="M10 18a8 8 0 1 0 0-16 8 8 0 0 0 0 16Zm3.857-9.809a.75.75 0 0 0-1.214-.882l-3.483 4.79-1.88-1.88a.75.75 0 1 0-1.06 1.061l2.5 2.5a.75.75 0 0 0 1.137-.089l4-5.5Z"
                                clip-rule="evenodd" />
                        </svg>
                    </label>
                </li>
            </ul>
            {{-- <div>
                <a href="#"
                    class="inline-flex items-center text-xs font-normal text-gray-500 hover:underline dark:text-gray-400">
                    <svg class="w-3 h-3 me-2" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none"
                        viewBox="0 0 20 20">
                        <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M7.529 7.988a2.502 2.502 0 0 1 5 .191A2.441 2.441 0 0 1 10 10.582V12m-.01 3.008H10M19 10a9 9 0 1 1-18 0 9 9 0 0 1 18 0Z" />
                    </svg>
                    Why do I need to connect with my wallet?</a>
            </div> --}}
        </div>
        {{-- LOADING SPINNER --}}
        <div class="flex items-center justify-center">
            <x-global-components::global.loading-spinner x-show="loading" />
        </div>
        {{-- PRINT SUCCESSFULLY TRIGGERD --}}
        <div x-show="!loading && syncTriggered" class="text-center">
            <div
                class="w-12 h-12 rounded-full bg-green-100 dark:bg-green-900 p-2 flex items-center justify-center mx-auto mb-3.5">
                <svg aria-hidden="true" class="w-8 h-8 text-green-500 dark:text-green-400" fill="currentColor"
                    viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
                    <path fill-rule="evenodd"
                        d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z"
                        clip-rule="evenodd"></path>
                </svg>
                <span class="sr-only">Success</span>
            </div>
            <p class="mb-4 text-lg font-semibold text-gray-900 dark:text-white">
                @lang('carma-cardssync_triggered_successfully')
            </p>
            <button x-on:click="hide()" type="button"
                class="py-2 px-3 text-sm font-medium text-center text-white rounded-lg bg-primary-600 hover:bg-primary-700 focus:ring-4 focus:outline-none focus:ring-primary-300 dark:focus:ring-primary-900">
                @lang('globals::global.action.close')
            </button>
        </div>
    </x-slot>

    <x-slot:footer>
        <button x-show="!loading && !syncTriggered" x-on:click="sync()"
            class="text-white inline-flex w-full justify-center bg-primary-700 hover:bg-primary-800 focus:ring-4 focus:outline-none focus:ring-primary-300 font-medium rounded-lg text-sm px-5 py-2.5 text-center dark:bg-primary-600 dark:hover:bg-primary-700 dark:focus:ring-primary-800">
            Sync
        </button>
    </x-slot>

    <x-slot:alpineScript>
        <script>
            document.addEventListener('alpine:init', () => {
                Alpine.data('targetDataSync', () => ({
                    isModalVisible: false,
                    loading: false,
                    syncTriggered: false,

                    hide() {
                        this.isModalVisible = false;
                        this.loading = false;
                        this.syncTriggered = false;
                    },
                    show(id) {
                        this.isModalVisible = true;

                        setTimeout(() => {
                            // onShow
                        }, 100);
                    },
                    sync() {
                        this.loading = true;
                        setTimeout(() => {
                            this.loading = false;
                            this.syncTriggered = true;
                        }, 1500);
                    }
                }));
            });
        </script>
    </x-slot>
</x-global-components::global.modals.base>
