<?php
/**
 * Livewire Component
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @generated   2025-06-01 14:13:22
 * @package     bplan-modules/card-manager
 * @subpackage  LivewireComponents
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanModules\CardManager\Livewire\CarmaCards\Modals;


use App\Traits\WithComboBoxInput;
use BplanBase\Globals\Models\EntityType;
use BplanBase\Globals\Models\EntityTypeFields;
use BplanModules\CardManager\Models\CarmaCardLayout;
use BplanModules\CardManager\Models\CarmaCardType;
use BplanModules\CardManager\Models\CarmaGroup;
use BplanModules\CardManager\Models\CarmaPrinter;
use BplanModules\CardManager\Services\CarmaCardService;
use BplanModules\CardManager\Traits\WithCarmaFields;
use Illuminate\Database\Eloquent\Collection;
use Livewire\Component;
use Illuminate\Support\Str;


/**
 * Livewire Component
 *
 * @version     1.0.0 / 2025-03-14
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class Edit extends Component
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    use WithComboBoxInput;
    use WithCarmaFields;


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var         ?Collection $fieldDefinition
     */
    public ?Collection $fieldDefinition;


    /**
     * @var         CarmaCardService $carmaCardService
     */
    protected CarmaCardService $carmaCardService;


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @param       CarmaCardService $Service
     *
     * @version     1.0.0 / 2025-06-01
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    private function _setComboBoxData()
    {
        $this->setComboBoxData('cardLayouts', CarmaCardLayout::all()->map(function ($layout) {
            return [
                'id' => $layout->id,
                'label' => $layout->name,
                // 'tag' => $cardType->labeling,
                'image_url' => $layout->preview_image_url,
            ];
        })->toArray());

        $this->setComboBoxData('cardTypes', CarmaCardType::all()->map(function ($cardType) {
            return [
                'id' => $cardType->id,
                'label' => $cardType->chip_type,
                'tag' => $cardType->labeling,
                'image_url' => asset("img/card-types/{$cardType->identifier}.png"),
            ];
        })->toArray());

        $this->setComboBoxData('groups', CarmaGroup::all()->toArray());

        $this->setComboBoxData('printers', CarmaPrinter::all()->map(function ($printer) {
            return [
                'id' => $printer->id,
                'label' => $printer->name,
                'tag' => $printer->type,
                'image_url' => asset("img/printers/{$printer->identifier}.png"),
            ];
        })->toArray());
    }


    /**
     *
     * @param       CarmaCardService $Service
     *
     * @version     1.0.0 / 2025-06-01
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    private function _setFieldDefinition()
    {
        $this->fieldDefinition = new Collection();
        $entityType = EntityType::where('identifier', 'CarmaCard.Employee')->first();

        if(isset($entityType))
        {
            $this->fieldDefinition = $entityType->fields()->with('field')->get()->keyBy('field.identifier');
        }

    }


    /**
     *
     * @param       CarmaCardService $Service
     *
     * @version     1.0.0 / 2025-06-01
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function boot(CarmaCardService $carmaCardService)
    {
        $this->carmaCardService = $carmaCardService;

    } // boot()


    /**
     *
     * @version     1.0.0 / 2025-06-01
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function mount()
    {
        $this->_setComboBoxData();
        $this->_setFieldDefinition();

    } // mount()


    /**
     *
     * @version     1.0.0 / 2025-06-01
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function render()
    {
        return view('card-manager::livewire.carma-cards.modals.edit');

    } // render();


    /**
     *
     * @return      array
     *
     * @version     1.0.0 / 2025-06-01
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function rules()
    {
        foreach ($this->fieldDefinition as $fieldDefinitionIndex => $fieldDefinition) {
            if ($fieldDefinition->active && $fieldDefinition->mandatory)
            {
                $columnCamelCase = Str::camel($fieldDefinition->identifier);
                $rules[$columnCamelCase] = 'required';
            }
        }

        return $rules;

    } // rules()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class Edit extends Component {}
