<?php
/**
 * Livewire Component
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @generated   2025-06-01 14:13:26
 * @package     bplan-modules/card-manager
 * @subpackage  LivewireComponents
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanModules\CardManager\Livewire\CarmaPrinters\Modals;


use BplanBase\Globals\Helpers\LogHelper;
use BplanModules\CardManager\Services\CarmaPrinterService;
use Livewire\Component;


/**
 * Livewire Component
 *
 * @version     1.0.0 / 2025-03-14
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class Create extends Component
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    public string $name;
    public string $type;
    public string $cardCapacity;
    public string $cardReader;
    public string $dns;

    protected CarmaPrinterService $carmaPrinterService;


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @version     1.0.0 / 2025-06-01
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function add()
    {
        try {

            $this->carmaPrinterService->create([
                'name' => $this->name,
                'type' => $this->type,
                'cardCapacity' => $this->cardCapacity,
                'cardReader' => $this->cardReader,
                'dns' => $this->dns,
            ]);

            $this->dispatch('printer-added');
        } catch (\Throwable $th) {
            LogHelper::logException($th);
        }
    }


    /**
     *
     * @version     1.0.0 / 2025-06-01
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function boot(CarmaPrinterService $carmaPrinterService)
    {
        $this->carmaPrinterService = $carmaPrinterService;
    }




    /**
     *
     * @version     1.0.0 / 2025-06-01
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function render()
    {
        return view('card-manager::livewire.carma-printers.modals.create');
    }


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class Create extends Component {}
