<?php
/**
 * Model Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @generated   2025-02-26 14:41:55
 * @package     bplan-modules/card-manager
 * @subpackage  Models
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanModules\CardManager\Models;


use BplanBase\Globals\Traits\HasActiveScope;
use BplanModules\CardManager\Observers\CarmaCardLayoutObserver;
use Illuminate\Database\Eloquent\Attributes\ObservedBy;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Facades\Storage;


/**
 * Model Class
 *
 * @version     1.4.0 / 2025-02-26
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
#[ObservedBy([CarmaCardLayoutObserver::class])]
class CarmaCardLayout extends Model
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    use HasActiveScope;
    use SoftDeletes;


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * The accessors to append to the model's array form.
     *
     * @var         array<int, string> $appends
     *
     * @version     1.0.0 / 2025-02-26
     */
    protected $appends = [
        'preview_image_url',
    ];


    /**
     * @var         array<string, string> $casts
     *
     * @version     1.0.0 / 2025-02-26
     */
    protected $casts = [
        'active'     => 'boolean',
        'created_at' => 'datetime',
        'deleted_at' => 'datetime',
        'updated_at' => 'datetime',
    ];


    /**
     * The attributes that are mass assignable.
     *
     * @var         array<int, string> $fillable
     *
     * @version     1.0.0 / 2025-02-26
     */
    protected $fillable = [
        'active',
        'description',
        'ini_file_name',
        'name',
        'preview_image',
    ];


    /**
     * The attributes that aren't mass assignable.
     *
     * @var         array<int, string> $guarded
     *
     * @version     1.0.0 / 2025-02-26
     */
    protected $guarded = [
        'created_at',
        'deleted_at',
        'updated_at',
        'uuid',
    ];


    /**
     * The attributes that should be hidden for serialization.
     *
     * @var         array<int, string> $hidden
     *
     * @version     1.0.0 / 2025-02-26
     */
    protected $hidden = [];


    /**
     * The table associated with the model.
     *
     * @var         string $table
     */
    protected $table = 'carma_card_layouts';


    /**
     * Indicates if the model should be timestamped.
     *
     * @var         bool $timestamps
     */
    public $timestamps = true;


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @return      HasMany
     *
     * @version     1.0.0 / 2025-02-26
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function carmaCards(): HasMany
    {
        return $this->hasMany(CarmaCard::class, 'card_layout_id');

    } // carmaCards()


    /**
     *
     * @return      HasMany
     *
     * @version     1.0.0 / 2025-02-26
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function carmaGroups(): HasMany
    {
        return $this->hasMany(CarmaGroup::class, 'card_layout_id');

    } // carmaGroups()


    /**
     *
     * @return      mixed
     *
     * @version     1.0.0 / 2025-02-26
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function getPreviewImageUrlAttribute(): mixed
    {
        return $this->preview_image
            ? Storage::disk('carma-card-layouts')
                ->temporaryUrl($this->preview_image, now()->addMinutes(5))

            : null;

    } // getPreviewImageUrlAttribute()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class CarmaCardLayout extends Model {}
