<?php
/**
 * Package Service Provider Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-modules/card-manager
 * @subpackage  Providers
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanModules\CardManager;

use BplanBase\Globals\Registries\SeederRegistry;
use BplanBase\Globals\Support\LivewireComponentAutoDiscovery;
use Illuminate\Support\ServiceProvider;
use Livewire\Livewire;


/**
 * Package Service Provider Class
 *
 * @version     1.2.0 / 2025-04-28
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class PackageServiceProvider extends ServiceProvider
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var         string $_basePath
     */
    protected string $_basePath;


    /**
     * @var         string $_baseNamespace
     */
    protected string $_baseNamespace = 'BplanModules\\CardManager';


    /**
     * Indicates if loading of the provider is deferred.
     *
     * @var         bool $defer
     */
    protected bool $defer = false;


    /**
     * @var         int $_packageKey
     */
    protected int $_packageKey = 1500;


    /**
     * @var         string $_packageName
     */
    protected string $_packageName = 'card-manager';


    /**
     * @var         string $_vendorPackageName
     */
    protected string $_vendorPackageName = 'bplan-modules/card-manager';


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @return 	    void
     *
     * @version     1.0.0 / 2025-
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    private function _registerFilesystems(): void
    {
        config([
            'filesystems.disks.carma-card-layouts' => [
                'driver' => 'local',
                'root' => storage_path('app/carma/card-layouts'),
                'serve' => true,
                'throw' => false,
                'report' => false,
            ],
        ]);
    } // _registerFilesystems()


    /**
     * Bootstrap the application events.
     *
     * @return      void
     *
     * @version     1.3.0 / 2025-04-28
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function boot(): void
    {
        /*
        **  Inform Laravel about translations. */
        $this->loadTranslationsFrom($this->_basePath.'/lang', 'card-manager');
        /*
        **  Inform Laravel about views. */
        $this->loadViewsFrom($this->_basePath.'/resources/views', 'card-manager');

        if ($this->app->runningInConsole()) {
            /*
            **  Inform Laravel about migrations. */
            $this->loadMigrationsFrom($this->_basePath.'/database/migrations');
        }
        $this->_registerFilesystems();

        LivewireComponentAutoDiscovery::register($this->_baseNamespace.'\\Livewire', $this->_basePath.'/src/Livewire', $this->_packageName);
        /*
        **  Load package routes. */
        $this->loadRoutesFrom($this->_basePath.'/routes/api.php');
        $this->loadRoutesFrom($this->_basePath.'/routes/web.php');

    } // boot()


    /**
     * Register the service provider.
     *
     * @return      void
     *
     * @version     1.0.0 / 2025-03-05
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function register(): void
    {
        $this->_basePath = str_replace('\\', '/', realpath(__DIR__.'/..'));

        if ($this->app->runningInConsole()) {
            SeederRegistry::register($this->_packageKey, $this->_vendorPackageName, \BplanModules\CardManager\Database\Seeders\DatabaseSeeder::class);
        }
    } // register()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class PackageServiceProvider extends ServiceProvider {}
