<?php
/**
 * Migration Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-modules/visitor-management
 * @subpackage  Migrations
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <http://www.bplan-solutions.de/>
 * /Δ\
 */


use BplanBase\CodeGenerator\Loaders\CodeGenerator;
use BplanModules\VisitorManagement\Enums\EntryPointType;
use BplanModules\VisitorManagement\Enums\EntryPointDirection;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;


/**
 * Migration Class
 *
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
return new class extends Migration
{


    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('visit_entry_points');

    } // down()


    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('visit_entry_points', function (Blueprint $Table) {
            $Table->id();
            $Table->boolean('active')->default(1);

            $Table->timestamps();
            $Table->softDeletes('deleted_at');

            $Table->enum('direction', array_column(EntryPointDirection::cases(), 'name'))->default(EntryPointDirection::Moot->name);
            $Table->enum('entry_point_type', array_column(EntryPointType::cases(), 'name'));
            $Table->string('label', 100);
            $Table->string('token', 6)->comment('Ein eindeutiger Bezeichner für jeden EntryPoint. Aufbau: EP#### ("EP" gefolgt von 4 Ziffern). Bei Kamera-/Schrankensystemen entspricht die Zahl dem verwendeten Port.');

            $Table->unique('token', 'entry_points_UK_token');

            new CodeGenerator($Table, [
                'columns' => [
                    'active' => [
                        'sortable' => true,
                    ],
                    'direction' => [
                        'rules' => [
                            'required',
                            'Rule::enum(EntryPointDirection::class)'
                        ],
                        'sortable' => true,
                    ],
                    'entry_point_type' => [
                        'rules' => [
                            'required',
                            'Rule::enum(EntryPointType::class)'
                        ],
                        'sortable' => true,
                    ],
                    'label' => [
                        'sortable' => true,
                    ],
                ],
                'routing' => [
                    'terminal' => 'readOnly',
                ],
                'uses' => [
                    'jsonapi.request' => [
                        'BplanModules\\VisitorManagement\\Enums\\EntryPointType',
                        'Illuminate\\Validation\\Rule',
                    ],
                    'laravel.repository' => [
                        'BplanModules\\VisitorManagement\\Enums\\EntryPointDirection',
                    ],
                ],
            ]);

        });
    } // up()


};
