<?php
/**
 * Migration Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-modules/visitor-management
 * @subpackage  Migrations
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <http://www.bplan-solutions.de/>
 * /Δ\
 */


use BplanBase\CodeGenerator\Loaders\CodeGenerator;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;


/**
 * Migration Class
 *
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
return new class extends Migration
{


    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('visit_reasons');

    } // down()


    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('visit_reasons', function (Blueprint $Table) {
            $Table->id();
            $Table->boolean('active')->default(1);

            $Table->timestamps();
            $Table->softDeletes('deleted_at');

            $Table->string('identifier', 30)->nullable();
            $Table->boolean('internal')->default(0);
            $Table->json('labels');
            $Table->foreignId('visit_type_id')->constrained(table: 'visit_types', indexName: 'visit_reasons_FK_visit_type_id');

            $Table->index('visit_type_id', 'visit_reasons_FKI_visit_type_id');

            $Table->comment('Individuelle Besuchsgründe der Installation.');

            new CodeGenerator($Table, [
                'columns' => [
                    'active' => [
                        'sortable' => true,
                    ],
                    'identifier' => [
                        'sortable' => true,
                    ],
                    'labels' => [
                        'jsonType' => CodeGenerator::JSON_TYPE_OBJECT,
                        'sortable' => true,
                    ],
                ],
                'routing' => [
                    'terminal' => 'readOnly',
                ],
            ]);

        });
    } // up()


};
