<?php
/**
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-modules/visitor-management
 * @subpackage  Seeders
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanModules\VisitorManagement\Database\Seeders\Dev;


use App\Models\User;
use BplanModules\VisitorManagement\Enums\ProcessStatus;
use BplanModules\VisitorManagement\Enums\TokenPrefix;
use BplanModules\VisitorManagement\Models\VisitAppointment;
use Illuminate\Database\Seeder;


/**
 *
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class VisitAppointmentSeeder extends Seeder
{


    /**
     * Run the database seeds.
     *
     * @return void
     *
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function run()
    {
        $date = date('Y-m-d H:i');
        $id = 0;
        $bulkCounter = 0;

        $CreateUser = User::where('email', '=', config('globals.dev.seeder-create-user'))
            ->first();

        VisitAppointment::insert([
            [
                //  Vergangener Termin
                "id" => ++$id,
                'uuid' => 'AAAAAAAA-AAAA-AAAA-AAAA-0000000000'.str_pad($id, 2, '0', STR_PAD_LEFT),
                "active" => 1,
                "created_at" => $date,
                "updated_at" => $date,
                "deleted_at" => null,
                "bulk_appointment_id" => null,
                "bulk_informations" => null,
                "checked_in_at" => null,
                'create_user_id' => $CreateUser->id,
                "drive_on_area_permitted" => 0,
                "license_plate" => null,
                "license_plate_formatted" => null,
                "loading_ramp_id" => null,
                "main_employee_id" => 1,
                "main_visitor_id" => $id,
                "order_number" => null,
                "organizer_employee_id" => null,
                "process_status" => ProcessStatus::Finished->value,
                "require_escort" => 0,
                "subject" => "Past SingleVisit",
                "token" => TokenPrefix::Appointment->value.'123456',
                "valid_from" => '2024-11-23 14:00',
                "valid_until" => '2024-11-23 16:00',
                "visit_reason_id" => 12,
                "visitors" => null,
                "web_token" => TokenPrefix::Web->value.'000000000000000000000000000000'.str_pad($id, 2, '0', STR_PAD_LEFT),
                "with_minors" => 0,
            ], [
                //  Einzelbesuch (offen)
                "id" => ++$id,
                'uuid' => 'AAAAAAAA-AAAA-AAAA-AAAA-0000000000'.str_pad($id, 2, '0', STR_PAD_LEFT),
                "active" => 1,
                "created_at" => $date,
                "updated_at" => $date,
                "deleted_at" => null,
                "bulk_appointment_id" => null,
                "bulk_informations" => null,
                "checked_in_at" => null,
                'create_user_id' => $CreateUser->id,
                "drive_on_area_permitted" => 0,
                "license_plate" => null,
                "license_plate_formatted" => null,
                "loading_ramp_id" => null,
                "main_employee_id" => 1,
                "main_visitor_id" => $id,
                "order_number" => null,
                "organizer_employee_id" => null,
                "process_status" => ProcessStatus::Open->value,
                "require_escort" => 0,
                "subject" => "SingleVisit",
                "token" => TokenPrefix::Appointment->value.'single',
                "valid_from" => date('Y-m-d H:i:s', time()),
                "valid_until" => date('Y-m-d', time()).' 19:00:00',
                "visit_reason_id" => 12,
                "visitors" => null,
                "web_token" => TokenPrefix::Web->value.'000000000000000000000000000000'.str_pad($id, 2, '0', STR_PAD_LEFT),
                "with_minors" => 0,
            ], [
                //  Gruppenbesuch (offen)
                "id" => ++$id,
                'uuid' => 'AAAAAAAA-AAAA-AAAA-AAAA-0000000000'.str_pad($id, 2, '0', STR_PAD_LEFT),
                "active" => 1,
                "created_at" => $date,
                "updated_at" => $date,
                "deleted_at" => null,
                "bulk_appointment_id" => null,
                "bulk_informations" => null,
                "checked_in_at" => null,
                'create_user_id' => $CreateUser->id,
                "drive_on_area_permitted" => 0,
                "license_plate" => null,
                "license_plate_formatted" => null,
                "loading_ramp_id" => null,
                "main_employee_id" => 1,
                "main_visitor_id" => $id,
                "order_number" => null,
                "organizer_employee_id" => null,
                "process_status" => ProcessStatus::Open->value,
                "require_escort" => 1,
                "subject" => "GroupVisit",
                "token" => TokenPrefix::Appointment->value.'group',
                "valid_from" => date('Y-m-d H:i:s', time()),
                "valid_until" => date('Y-m-d', time()).' 19:00:00',
                "visit_reason_id" => 11,
                "visitors" => '[{"id": "-1", "email": "ludwig.lastwagen@lucky-pc.de", "company": "Besucher GmbH", "last_name": "Lastwagen", "first_name": "Ludwig", "mobile_phone_number": "+491638441315"}]',
                "web_token" => TokenPrefix::Web->value.'000000000000000000000000000000'.str_pad($id, 2, '0', STR_PAD_LEFT),
                "with_minors" => 0,
            ], [
                //  Anlieferung (offen)
                "id" => ++$id,
                'uuid' => 'AAAAAAAA-AAAA-AAAA-AAAA-0000000000'.str_pad($id, 2, '0', STR_PAD_LEFT),
                "active" => 1,
                "created_at" => $date,
                "updated_at" => $date,
                "deleted_at" => null,
                "bulk_appointment_id" => null,
                "bulk_informations" => null,
                "checked_in_at" => null,
                'create_user_id' => $CreateUser->id,
                "drive_on_area_permitted" => 1,
                "license_plate" => 'NRLX399',
                "license_plate_formatted" => 'NR LX 399',
                "loading_ramp_id" => null,
                "main_employee_id" => 1,
                "main_visitor_id" => $id,
                "order_number" => "O345678901",
                "organizer_employee_id" => null,
                "process_status" => ProcessStatus::Open->value,
                "require_escort" => 0,
                "subject" => "Delivery",
                "token" => TokenPrefix::Appointment->value.'delive',
                "valid_from" => date('Y-m-d H:i:s', time()),
                "valid_until" => date('Y-m-d', time()).' 19:00:00',
                "visit_reason_id" => 19,
                "visitors" => null,
                "web_token" => TokenPrefix::Web->value.'000000000000000000000000000000'.str_pad($id, 2, '0', STR_PAD_LEFT),
                "with_minors" => 0,
            ], [
                //  Anlieferung & Abholung (offen)
                "id" => ++$id,
                'uuid' => 'AAAAAAAA-AAAA-AAAA-AAAA-0000000000'.str_pad($id, 2, '0', STR_PAD_LEFT),
                "active" => 1,
                "created_at" => $date,
                "updated_at" => $date,
                "deleted_at" => null,
                "bulk_appointment_id" => null,
                "bulk_informations" => null,
                "checked_in_at" => null,
                'create_user_id' => $CreateUser->id,
                "drive_on_area_permitted" => 1,
                "license_plate" => 'NRLX99',
                "license_plate_formatted" => 'NR LX 99',
                "loading_ramp_id" => null,
                "main_employee_id" => 1,
                "main_visitor_id" => $id,
                "order_number" => "O345678901",
                "organizer_employee_id" => null,
                "process_status" => ProcessStatus::Open->value,
                "require_escort" => 0,
                "subject" => "Delivery & Pickup",
                "token" => TokenPrefix::Appointment->value.'delpic',
                "valid_from" => date('Y-m-d H:i:s', time()),
                "valid_until" => date('Y-m-d', time()).' 19:00:00',
                "visit_reason_id" => 26,
                "visitors" => null,
                "web_token" => TokenPrefix::Web->value.'000000000000000000000000000000'.str_pad($id, 2, '0', STR_PAD_LEFT),
                "with_minors" => 0,
            ], [
                //  Abholung (offen)
                "id" => ++$id,
                'uuid' => 'AAAAAAAA-AAAA-AAAA-AAAA-0000000000'.str_pad($id, 2, '0', STR_PAD_LEFT),
                "active" => 1,
                "created_at" => $date,
                "updated_at" => $date,
                "deleted_at" => null,
                "bulk_appointment_id" => null,
                "bulk_informations" => null,
                "checked_in_at" => null,
                'create_user_id' => $CreateUser->id,
                "drive_on_area_permitted" => 1,
                "license_plate" => 'NRLX339',
                "license_plate_formatted" => 'NR LX 339',
                "loading_ramp_id" => null,
                "main_employee_id" => 1,
                "main_visitor_id" => $id,
                "order_number" => "O456789012",
                "organizer_employee_id" => null,
                "process_status" => ProcessStatus::Open->value,
                "require_escort" => 0,
                "subject" => "Pickup",
                "token" => TokenPrefix::Appointment->value.'pickup',
                "valid_from" => date('Y-m-d H:i:s', time()),
                "valid_until" => date('Y-m-d', time()).' 19:00:00',
                "visit_reason_id" => 23,
                "visitors" => null,
                "web_token" => TokenPrefix::Web->value.'000000000000000000000000000000'.str_pad($id, 2, '0', STR_PAD_LEFT),
                "with_minors" => 0,
            ], [
                //  Paketdienst (offen)
                "id" => ++$id,
                'uuid' => 'AAAAAAAA-AAAA-AAAA-AAAA-0000000000'.str_pad($id, 2, '0', STR_PAD_LEFT),
                "active" => 1,
                "created_at" => $date,
                "updated_at" => $date,
                "deleted_at" => null,
                "bulk_appointment_id" => null,
                "bulk_informations" => null,
                "checked_in_at" => null,
                'create_user_id' => $CreateUser->id,
                "drive_on_area_permitted" => 1,
                "license_plate" => 'KAA1234',
                "license_plate_formatted" => 'K AA 1234',
                "loading_ramp_id" => null,
                "main_employee_id" => 1,
                "main_visitor_id" => $id,
                "order_number" => null,
                "organizer_employee_id" => null,
                "process_status" => ProcessStatus::Open->value,
                "require_escort" => 0,
                "subject" => "ParcelService",
                "token" => TokenPrefix::Appointment->value.'parcel',
                "valid_from" => date('Y-m-d H:i:s', time()),
                "valid_until" => date('Y-m-d', time() + 86400).' 19:00:00',
                "visit_reason_id" => 22,
                "visitors" => null,
                "web_token" => TokenPrefix::Web->value.'000000000000000000000000000000'.str_pad($id, 2, '0', STR_PAD_LEFT),
                "with_minors" => 0,
            ], [
                //  Shunting (offen)
                "id" => ++$id,
                'uuid' => 'AAAAAAAA-AAAA-AAAA-AAAA-0000000000'.str_pad($id, 2, '0', STR_PAD_LEFT),
                "active" => 1,
                "created_at" => $date,
                "updated_at" => $date,
                "deleted_at" => null,
                "bulk_appointment_id" => null,
                "bulk_informations" => null,
                "checked_in_at" => null,
                'create_user_id' => $CreateUser->id,
                "drive_on_area_permitted" => 1,
                "license_plate" => 'SUAB456',
                "license_plate_formatted" => 'SU AB 456',
                "loading_ramp_id" => null,
                "main_employee_id" => 1,
                "main_visitor_id" => $id,
                "order_number" => "O678901234",
                "organizer_employee_id" => null,
                "process_status" => ProcessStatus::Open->value,
                "require_escort" => 0,
                "subject" => "Shunting",
                "token" => TokenPrefix::Appointment->value.'shunti',
                "valid_from" => date('Y-m-d H:i:s', time()),
                "valid_until" => date('Y-m-d', time() + 86400).' 19:00:00',
                "visit_reason_id" => 24,
                "visitors" => null,
                "web_token" => TokenPrefix::Web->value.'000000000000000000000000000000'.str_pad($id, 2, '0', STR_PAD_LEFT),
                "with_minors" => 0,
            ], [
                //  Fremdfirma (offen)
                "id" => ++$id,
                'uuid' => 'AAAAAAAA-AAAA-AAAA-AAAA-0000000000'.str_pad($id, 2, '0', STR_PAD_LEFT),
                "active" => 1,
                "created_at" => $date,
                "updated_at" => $date,
                "deleted_at" => null,
                "bulk_appointment_id" => null,
                "bulk_informations" => null,
                "checked_in_at" => null,
                'create_user_id' => $CreateUser->id,
                "drive_on_area_permitted" => 0,
                "license_plate" => null,
                "license_plate_formatted" => null,
                "loading_ramp_id" => null,
                "main_employee_id" => 1,
                "main_visitor_id" => $id,
                "order_number" => "O789012345",
                "organizer_employee_id" => null,
                "process_status" => ProcessStatus::Open->value,
                "require_escort" => 1,
                "subject" => "Contractor",
                "token" => TokenPrefix::Appointment->value.'contra',
                "valid_from" => date('Y-m-d H:i:s', time()),
                "valid_until" => date('Y-m-d', time()).' 19:00:00',
                "visit_reason_id" => 20,
                "visitors" => null,
                "web_token" => TokenPrefix::Web->value.'000000000000000000000000000000'.str_pad($id, 2, '0', STR_PAD_LEFT),
                "with_minors" => 0,
            ], [
                //  Zufahrtsberechtigung (offen)
                "id" => ++$id,
                'uuid' => 'AAAAAAAA-AAAA-AAAA-AAAA-0000000000'.str_pad($id, 2, '0', STR_PAD_LEFT),
                "active" => 1,
                "created_at" => $date,
                "updated_at" => $date,
                "deleted_at" => null,
                "bulk_appointment_id" => null,
                "bulk_informations" => null,
                "checked_in_at" => null,
                'create_user_id' => $CreateUser->id,
                "drive_on_area_permitted" => 1,
                "license_plate" => 'MCP784',
                "license_plate_formatted" => 'M CP 784',
                "loading_ramp_id" => null,
                "main_employee_id" => 1,
                "main_visitor_id" => $id,
                "order_number" => null,
                "organizer_employee_id" => null,
                "process_status" => ProcessStatus::CalledIn->value,
                "require_escort" => 0,
                "subject" => "AccessAuthorization",
                "token" => TokenPrefix::Appointment->value.'access',
                "valid_from" => date('Y-m-d H:i:s', time() - 86400),
                "valid_until" => date('Y-m-d', time() + (86400 * 30)).' 23:59:59',
                "visit_reason_id" => 1,
                "visitors" => null,
                "web_token" => TokenPrefix::Web->value.'000000000000000000000000000000'.str_pad($id, 2, '0', STR_PAD_LEFT),
                "with_minors" => 0,
            ], [
                //  Einzelbesuch, mehrtägig (offen)
                "id" => ++$id,
                'uuid' => 'AAAAAAAA-AAAA-AAAA-AAAA-0000000000'.str_pad($id, 2, '0', STR_PAD_LEFT),
                "active" => 1,
                "created_at" => $date,
                "updated_at" => $date,
                "deleted_at" => null,
                "bulk_appointment_id" => null,
                "bulk_informations" => null,
                "checked_in_at" => null,
                'create_user_id' => $CreateUser->id,
                "drive_on_area_permitted" => 0,
                "license_plate" => null,
                "license_plate_formatted" => null,
                "loading_ramp_id" => null,
                "main_employee_id" => 1,
                "main_visitor_id" => $id,
                "order_number" => null,
                "organizer_employee_id" => null,
                "process_status" => ProcessStatus::Open->value,
                "require_escort" => 0,
                "subject" => "SingleVisit Multiple Days",
                "token" => TokenPrefix::Appointment->value.'sinmul',
                "valid_from" => date('Y-m-d H:i:s', time() - 86400),
                "valid_until" => date('Y-m-d', time() + (86400 * 3)).' 19:00:00',
                "visit_reason_id" => 12,
                "visitors" => null,
                "web_token" => TokenPrefix::Web->value.'000000000000000000000000000000'.str_pad($id, 2, '0', STR_PAD_LEFT),
                "with_minors" => 0,
            ], [
                //  Massentermin (Master)
                "id" => ($bulkId = ++$id),
                'uuid' => 'AAAAAAAA-AAAA-AAAA-AAAA-0000000000'.str_pad($id, 2, '0', STR_PAD_LEFT),
                "active" => 1,
                "created_at" => $date,
                "updated_at" => $date,
                "deleted_at" => null,
                "bulk_appointment_id" => null,
                "bulk_informations" => '{"visit_reason_id":14, "visit_type_id":10, "visit_type_identifier":"SingleVisit"}',
                "checked_in_at" => null,
                'create_user_id' => $CreateUser->id,
                "drive_on_area_permitted" => 0,
                "license_plate" => null,
                "license_plate_formatted" => null,
                "loading_ramp_id" => null,
                "main_employee_id" => 1,
                "main_visitor_id" => null,
                "order_number" => null,
                "organizer_employee_id" => null,
                "process_status" => ProcessStatus::Open->value,
                "require_escort" => 0,
                "subject" => "BulkAppointment",
                "token" => TokenPrefix::Appointment->value.'bulk00',
                "valid_from" => date('Y-m-d H:i:s', time() - 86400),
                "valid_until" => date('Y-m-d', time() + (86400 * 3)).' 19:00:00',
                "visit_reason_id" => 10,
                "visitors" => '[{"id": "1", "email": "tony.trucker@lucky-pc.de", "company": "Trucker Ltd.", "last_name": "Trucker", "first_name": "Tony", "mobile_phone_number": "+491638441315"}, {"id": "2", "email": "ludwig.lastwagen@lucky-pc.de", "company": "Besucher GmbH", "last_name": "Lastwagen", "first_name": "Ludwig", "mobile_phone_number": "+491638441315"}]',
                "web_token" => TokenPrefix::Web->value.'000000000000000000000000000000'.str_pad($id, 2, '0', STR_PAD_LEFT),
                "with_minors" => 0,
            ], [
                //  Einzeltermin 1 zum Massentermin (offen)
                "id" => ++$id,
                'uuid' => 'AAAAAAAA-AAAA-AAAA-AAAA-0000000001'.str_pad(++$bulkCounter, 2, '0', STR_PAD_LEFT),
                "active" => 1,
                "created_at" => $date,
                "updated_at" => $date,
                "deleted_at" => null,
                "bulk_appointment_id" => $bulkId,
                "bulk_informations" => null,
                "checked_in_at" => null,
                'create_user_id' => $CreateUser->id,
                "drive_on_area_permitted" => 0,
                "license_plate" => null,
                "license_plate_formatted" => null,
                "loading_ramp_id" => null,
                "main_employee_id" => 1,
                "main_visitor_id" => 1,
                "order_number" => null,
                "organizer_employee_id" => null,
                "process_status" => ProcessStatus::Open->value,
                "require_escort" => 0,
                "subject" => "BulkAppointment",
                "token" => TokenPrefix::Appointment->value.'bulk'.str_pad($bulkCounter, 2, '0', STR_PAD_LEFT),
                "valid_from" => date('Y-m-d H:i:s', time() - 86400),
                "valid_until" => date('Y-m-d', time() + (86400 * 3)).' 19:00:00',
                "visit_reason_id" => 14,
                "visitors" => null,
                "web_token" => TokenPrefix::Web->value.'000000000000000000000000000000'.str_pad($bulkCounter, 2, '0', STR_PAD_LEFT),
                "with_minors" => 0,
            ], [
                //  Einzeltermin 2 zum Massentermin (offen)
                "id" => ++$id,
                'uuid' => 'AAAAAAAA-AAAA-AAAA-AAAA-0000000001'.str_pad(++$bulkCounter, 2, '0', STR_PAD_LEFT),
                "active" => 1,
                "created_at" => $date,
                "updated_at" => $date,
                "deleted_at" => null,
                "bulk_appointment_id" => $bulkId,
                "bulk_informations" => null,
                "checked_in_at" => null,
                'create_user_id' => $CreateUser->id,
                "drive_on_area_permitted" => 0,
                "license_plate" => null,
                "license_plate_formatted" => null,
                "loading_ramp_id" => null,
                "main_employee_id" => 1,
                "main_visitor_id" => 2,
                "order_number" => null,
                "organizer_employee_id" => null,
                "process_status" => ProcessStatus::Open->value,
                "require_escort" => 0,
                "subject" => "BulkAppointment",
                "token" => TokenPrefix::Appointment->value.'bulk'.str_pad($bulkCounter, 2, '0', STR_PAD_LEFT),
                "valid_from" => date('Y-m-d H:i:s', time() - 86400),
                "valid_until" => date('Y-m-d', time() + (86400 * 3)).' 19:00:00',
                "visit_reason_id" => 14,
                "visitors" => null,
                "web_token" => TokenPrefix::Web->value.'000000000000000000000000000000'.str_pad($bulkCounter, 2, '0', STR_PAD_LEFT),
                "with_minors" => 0,
            ], [
                //  Anlieferung (in Warteposition)
                "id" => ++$id,
                'uuid' => 'AAAAAAAA-AAAA-AAAA-AAAA-0000000000'.str_pad($id, 2, '0', STR_PAD_LEFT),
                "active" => 1,
                "created_at" => date('Y-m-d H:i', time() - 3600),
                "updated_at" => date('Y-m-d H:i', time() - 3600),
                "deleted_at" => null,
                "bulk_appointment_id" => null,
                "bulk_informations" => null,
                "checked_in_at" => date('Y-m-d H:i', time() - 1200),
                'create_user_id' => $CreateUser->id,
                "drive_on_area_permitted" => 1,
                "license_plate" => 'BD63MSR',
                "license_plate_formatted" => 'BD 63 MSR',
                "loading_ramp_id" => null,
                "main_employee_id" => 1,
                "main_visitor_id" => 3,
                "order_number" => "O456789012",
                "organizer_employee_id" => null,
                "process_status" => ProcessStatus::CheckedIn->value,
                "require_escort" => 0,
                "subject" => "Delivery, waiting",
                "token" => TokenPrefix::Appointment->value.'delwai',
                "valid_from" => date('Y-m-d H:i:s', time() - 600),
                "valid_until" => date('Y-m-d', time() + 3600),
                "visit_reason_id" => 19,
                "visitors" => null,
                "web_token" => TokenPrefix::Web->value.'000000000000000000000000000000'.str_pad($id, 2, '0', STR_PAD_LEFT),
                "with_minors" => 0,
            ], [
                //  Anlieferung (hereingerufen)
                "id" => ++$id,
                'uuid' => 'AAAAAAAA-AAAA-AAAA-AAAA-0000000000'.str_pad($id, 2, '0', STR_PAD_LEFT),
                "active" => 1,
                "created_at" => date('Y-m-d H:i', time() - 3600),
                "updated_at" => date('Y-m-d H:i', time() - 3600),
                "deleted_at" => null,
                "bulk_appointment_id" => null,
                "bulk_informations" => null,
                "checked_in_at" => date('Y-m-d H:i', time() - 1100),
                'create_user_id' => $CreateUser->id,
                "drive_on_area_permitted" => 1,
                "license_plate" => 'YR53JEP',
                "license_plate_formatted" => 'YR 53 JEP',
                "loading_ramp_id" => 10,
                "main_employee_id" => 1,
                "main_visitor_id" => 5,
                "order_number" => "O567890123",
                "organizer_employee_id" => null,
                "process_status" => ProcessStatus::CalledIn->value,
                "require_escort" => 0,
                "subject" => "Delivery, called in",
                "token" => TokenPrefix::Appointment->value.'delcal',
                "valid_from" => date('Y-m-d H:i:s', time() - 600),
                "valid_until" => date('Y-m-d', time() + 3600),
                "visit_reason_id" => 19,
                "visitors" => null,
                "web_token" => TokenPrefix::Web->value.'000000000000000000000000000000'.str_pad($id, 2, '0', STR_PAD_LEFT),
                "with_minors" => 0,
            ], [
                //  Anlieferung (eingefahren)
                "id" => ++$id,
                'uuid' => 'AAAAAAAA-AAAA-AAAA-AAAA-0000000000'.str_pad($id, 2, '0', STR_PAD_LEFT),
                "active" => 1,
                "created_at" => date('Y-m-d H:i', time() - 3600),
                "updated_at" => date('Y-m-d H:i', time() - 3600),
                "deleted_at" => null,
                "bulk_appointment_id" => null,
                "bulk_informations" => null,
                "checked_in_at" => date('Y-m-d H:i', time() - 1000),
                'create_user_id' => $CreateUser->id,
                "drive_on_area_permitted" => 1,
                "license_plate" => 'EX322JB',
                "license_plate_formatted" => 'EX 322 JB',
                "loading_ramp_id" => 9,
                "main_employee_id" => 1,
                "main_visitor_id" => 4,
                "order_number" => "O678901234",
                "organizer_employee_id" => null,
                "process_status" => ProcessStatus::Entered->value,
                "require_escort" => 0,
                "subject" => "Delivery, entered",
                "token" => TokenPrefix::Appointment->value.'delent',
                "valid_from" => date('Y-m-d H:i:s', time() - 600),
                "valid_until" => date('Y-m-d', time() + 3600),
                "visit_reason_id" => 19,
                "visitors" => null,
                "web_token" => TokenPrefix::Web->value.'000000000000000000000000000000'.str_pad($id, 2, '0', STR_PAD_LEFT),
                "with_minors" => 0,
            ], [
                //  Einzelbesuch, eintägig (> offen)
                "id" => ++$id,
                'uuid' => 'AAAAAAAA-AAAA-AAAA-AAAA-0000000000'.str_pad($id, 2, '0', STR_PAD_LEFT),
                "active" => 1,
                "created_at" => date('Y-m-d H:i', time() - 3600),
                "updated_at" => date('Y-m-d H:i', time() - 3600),
                "deleted_at" => null,
                "bulk_appointment_id" => null,
                "bulk_informations" => null,
                "checked_in_at" => date('Y-m-d', time()),
                'create_user_id' => $CreateUser->id,
                "drive_on_area_permitted" => 0,
                "license_plate" => null,
                "license_plate_formatted" => null,
                "loading_ramp_id" => null,
                "main_employee_id" => 1,
                "main_visitor_id" => 3,
                "order_number" => null,
                "organizer_employee_id" => 2,
                "process_status" => ProcessStatus::Open->value,
                "require_escort" => 0,
                "subject" => "SingleVisit, with organizer",
                "token" => TokenPrefix::Appointment->value.'sinorg',
                "valid_from" => date('Y-m-d H:i:s', time()),
                "valid_until" => date('Y-m-d', time()).' 19:00:00',
                "visit_reason_id" => 12,
                "visitors" => null,
                "web_token" => TokenPrefix::Web->value.'000000000000000000000000000000'.str_pad($id, 2, '0', STR_PAD_LEFT),
                "with_minors" => 0,
            ], [
                //  Einzelbesuch, eintägig (> CheckedIn)
                "id" => ++$id,
                'uuid' => 'AAAAAAAA-AAAA-AAAA-AAAA-0000000000'.str_pad($id, 2, '0', STR_PAD_LEFT),
                "active" => 1,
                "created_at" => date('Y-m-d H:i', time() - 3600),
                "updated_at" => date('Y-m-d H:i', time() - 3600),
                "deleted_at" => null,
                "bulk_appointment_id" => null,
                "bulk_informations" => null,
                "checked_in_at" => date('Y-m-d', time()),
                'create_user_id' => $CreateUser->id,
                "drive_on_area_permitted" => 0,
                "license_plate" => null,
                "license_plate_formatted" => null,
                "loading_ramp_id" => null,
                "main_employee_id" => 1,
                "main_visitor_id" => 3,
                "order_number" => null,
                "organizer_employee_id" => null,
                "process_status" => ProcessStatus::Entered->value,
                "require_escort" => 0,
                "subject" => "SingleVisit, running",
                "token" => TokenPrefix::Appointment->value.'sinrun',
                "valid_from" => date('Y-m-d H:i:s', time()),
                "valid_until" => date('Y-m-d', time()).' 19:00:00',
                "visit_reason_id" => 12,
                "visitors" => null,
                "web_token" => TokenPrefix::Web->value.'000000000000000000000000000000'.str_pad($id, 2, '0', STR_PAD_LEFT),
                "with_minors" => 0,
            ], [
                //  Einzelbesuch, mehrtägig (> CheckedIn)
                "id" => ++$id,
                'uuid' => 'AAAAAAAA-AAAA-AAAA-AAAA-0000000000'.str_pad($id, 2, '0', STR_PAD_LEFT),
                "active" => 1,
                "created_at" => date('Y-m-d H:i', time() - 3600),
                "updated_at" => date('Y-m-d H:i', time() - 3600),
                "deleted_at" => null,
                "bulk_appointment_id" => null,
                "bulk_informations" => null,
                "checked_in_at" => date('Y-m-d', time()),
                'create_user_id' => $CreateUser->id,
                "drive_on_area_permitted" => 0,
                "license_plate" => null,
                "license_plate_formatted" => null,
                "loading_ramp_id" => null,
                "main_employee_id" => 1,
                "main_visitor_id" => 6,
                "order_number" => null,
                "organizer_employee_id" => null,
                "process_status" => ProcessStatus::Entered->value,
                "require_escort" => 0,
                "subject" => "SingleVisit, running",
                "token" => TokenPrefix::Appointment->value.'mulrun',
                "valid_from" => date('Y-m-d H:i:s', time()),
                "valid_until" => date('Y-m-d', time() + 7200).' 15:00:00',
                "visit_reason_id" => 12,
                "visitors" => null,
                "web_token" => TokenPrefix::Web->value.'000000000000000000000000000000'.str_pad($id, 2, '0', STR_PAD_LEFT),
                "with_minors" => 0,
            ],

        ]);
    } // run()

} // class VisitAppointmentSeeder extends Seeder {}
