<?php
/**
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-modules/visitor-management
 * @subpackage  Seeders
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanModules\VisitorManagement\Database\Seeders\Dev;


use BplanModules\VisitorManagement\Models\VisitEmployee;
use Illuminate\Database\Seeder;


/**
 *
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class VisitEmployeeSeeder extends Seeder
{


    /**
     * Run the database seeds.
     *
     * @return void
     *
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function run()
    {
        $date = date('Y-m-d H:i:s');

        VisitEmployee::insert([
            [
                "active" => 1,
                "created_at" => $date,
                "deleted_at" => null,
                "updated_at" => $date,
                "contact" => 1,
                "contact_group_id" => 2,
                "department" => "Site",
                "email" => 'wassilios.meletiadis@bplan-solutions.de',
                "emergency_contact" => 1,
                "first_name" => "Manfred",
                "function" => "Manufacturing",
                "global_contact" => 1,
                "import_failure_count" => 0,
                "import_failures" => null,
                "last_name" => "Mitarbeiter",
                "license_plate" => "AAA-AA-1234;BBB-BB-2345",
                "mobile_phone_number" => "1638441315",
                "mobile_phone_number_country_code" => "+49",
                "personnel_number" => "111111",
                "phone_number" => null,
                "phone_number_country_code" => null,
                "user_id" => 4,
            ],
            [
                "active" => 1,
                "created_at" => $date,
                "deleted_at" => null,
                "updated_at" => $date,
                "contact" => 1,
                "contact_group_id" => 2,
                "department" => "Site",
                "email" => 'lucky@bplan-solutions.de',
                "emergency_contact" => 1,
                "first_name" => "Bernd",
                "function" => "Manufacturing",
                "global_contact" => 0,
                "import_failure_count" => 0,
                "import_failures" => null,
                "last_name" => "das Brot",
                "license_plate" => "B-B-99",
                "mobile_phone_number" => "1638441315",
                "mobile_phone_number_country_code" => "+49",
                "personnel_number" => "222222",
                "phone_number" => '22039898983',
                "phone_number_country_code" => "+49",
                "user_id" => null,
            ],
            [
                "active" => 1,
                "created_at" => $date,
                "deleted_at" => null,
                "updated_at" => $date,
                "contact" => 1,
                "contact_group_id" => 3,
                "department" => "Site",
                "email" => 'andrea.bockholt@bplan-solutions.de',
                "emergency_contact" => 0,
                "first_name" => "Andrea",
                "function" => "Manufacturing",
                "global_contact" => 1,
                "import_failure_count" => 0,
                "import_failures" => null,
                "last_name" => "Bockholt",
                "license_plate" => "B-B-99",
                "mobile_phone_number" => "1631414362",
                "mobile_phone_number_country_code" => "+49",
                "personnel_number" => "333333",
                "phone_number" => null,
                "phone_number_country_code" => null,
                "user_id" => 4,
            ],
            [
                "active" => 1,
                "created_at" => $date,
                "deleted_at" => null,
                "updated_at" => $date,
                "contact" => 1,
                "contact_group_id" => null,
                "department" => "Site",
                "email" => 'emilio.cannarozzo@bplan-solutions.de',
                "emergency_contact" => 4,
                "first_name" => "Emilio",
                "function" => "Manufacturing",
                "global_contact" => 1,
                "import_failure_count" => 0,
                "import_failures" => null,
                "last_name" => "Cannarozzo",
                "license_plate" => "B-B-99",
                "mobile_phone_number" => "17680338219",
                "mobile_phone_number_country_code" => "+49",
                "personnel_number" => "444444",
                "phone_number" => '22039898983',
                "phone_number_country_code" => "+49",
                "user_id" => 4,
            ],
            [
                "active" => 1,
                "created_at" => $date,
                "deleted_at" => null,
                "updated_at" => $date,
                "contact" => 0,
                "contact_group_id" => null,
                "department" => "Site",
                "email" => 'tolga.kocer@bplan-solutions.de',
                "emergency_contact" => 0,
                "first_name" => "Tolga",
                "function" => "Manufacturing",
                "global_contact" => 0,
                "import_failure_count" => 0,
                "import_failures" => null,
                "last_name" => "Kocer",
                "license_plate" => "B-B-99",
                "mobile_phone_number" => "17680338219",
                "mobile_phone_number_country_code" => "+49",
                "personnel_number" => "555555",
                "phone_number" => null,
                "phone_number_country_code" => null,
                "user_id" => 4,
            ],
            [
                "active" => 1,
                "created_at" => $date,
                "deleted_at" => null,
                "updated_at" => $date,
                "contact" => 0,
                "contact_group_id" => null,
                "department" => "Site",
                "email" => 'otto.organisator@lucky-pc.de',
                "emergency_contact" => 0,
                "first_name" => "Otto",
                "function" => "Manufacturing",
                "global_contact" => 0,
                "import_failure_count" => 0,
                "import_failures" => null,
                "last_name" => "Organisator",
                "license_plate" => "O CC 987",
                "mobile_phone_number" => "17680338219",
                "mobile_phone_number_country_code" => "+49",
                "personnel_number" => "666666",
                "phone_number" => null,
                "phone_number_country_code" => null,
                "user_id" => 4,
            ],

        ]);
    } // run()


} // class VisitEmployeeSeeder extends Seeder {}
