<?php
/**
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-modules/visitor-management
 * @subpackage  Seeders
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <http://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanModules\VisitorManagement\Database\Seeders\Dev;


use BplanModules\VisitorManagement\Models\VisitEquipmentItem;
use Illuminate\Database\Seeder;


/**
 *
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class VisitEquipmentItemSeeder extends Seeder
{

    /**
     * Run the database seeds.
     *
     * @return void
     *
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function run()
    {
        $date = date('Y-m-d H:i:s');

        VisitEquipmentItem::insert([
            [
                "id" => 1,
                "active" => 1,
                "created_at" => $date,
                "updated_at" => $date,
                "deleted_at" => null,
                "labels" => '{"de":"Warnweste", "en":"Safety vest"}',
            ],
            [
                "id" => 2,
                "active" => 1,
                "created_at" => $date,
                "updated_at" => $date,
                "deleted_at" => null,
                "labels" => '{"de":"Schutzhelm", "en":"Safety helmet"}',
            ], [
                "id" => 3,
                "active" => 1,
                "created_at" => $date,
                "updated_at" => $date,
                "deleted_at" => null,
                "labels" => '{"de":"Arbeitshandschuhe", "en":"Work Glove"}',
            ],

        ]);
    } // run()

} // class VisitEquipmentSeeder extends Seeder {}
