<?php
/**
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-modules/visitor-management
 * @subpackage  Seeders
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanModules\VisitorManagement\Database\Seeders\Dev;


use BplanModules\VisitorManagement\Models\VisitLocation;
use Illuminate\Database\Seeder;


/**
 *
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class VisitLocationSeeder extends Seeder
{

    /**
     * Run the database seeds.
     *
     * @return void
     *
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function run()
    {
        $date = date('Y-m-d H:i:s');

        VisitLocation::insert([
            [
                "id" => 1,
                "active" => 1,
                "created_at" => $date,
                "updated_at" => $date,
                "deleted_at" => null,
                "address_addition" => null,
                "city" => 'Köln',
                "coordinates" => null,
                "email" => 'info@bplan-solutions.de',
                "house_number" => '22',
                "labels" => '{"de":"Zentrale", "en":"Main Office", "it":"Centrale"}',
                "location_type_id" => 3,
                "master_id" => null,
                "phone_number" => '+4922039898980',
                "street" => 'Max-Reichpietsch-Strasse',
                "zip_code" => '51147',
            ], [
                "id" => 2,
                "active" => 1,
                "created_at" => $date,
                "updated_at" => $date,
                "deleted_at" => null,
                "address_addition" => null,
                "city" => null,
                "coordinates" => null,
                "email" => null,
                "house_number" => null,
                "labels" => '{"de":"Tor 1", "en":"Gate 1", "it":"Porta 1"}',
                "location_type_id" => 3,
                "master_id" => 1,
                "phone_number" => '+4922039898989',
                "street" => null,
                "zip_code" => null,
            ], [
                "id" => 3,
                "active" => 1,
                "created_at" => $date,
                "updated_at" => $date,
                "deleted_at" => null,
                "address_addition" => null,
                "city" => null,
                "coordinates" => null,
                "email" => null,
                "house_number" => null,
                "labels" => '{"de":"Service Desk", "en":"Service Desk", "it":"Desk di servizio"}',
                "location_type_id" => 3,
                "master_id" => 1,
                "phone_number" => '+4922039898980',
                "street" => null,
                "zip_code" => null,
            ], [
                "id" => 4,
                "active" => 1,
                "created_at" => $date,
                "updated_at" => $date,
                "deleted_at" => null,
                "address_addition" => null,
                "city" => null,
                "coordinates" => null,
                "email" => null,
                "house_number" => null,
                "labels" => '{"de":"Lagerraum 1", "en":"Storage Room 1", "it":"Magazzino 1"}',
                "location_type_id" => 3,
                "master_id" => 1,
                "phone_number" => null,
                "street" => null,
                "zip_code" => null,
            ], [
                "id" => 5,
                "active" => 1,
                "created_at" => $date,
                "updated_at" => $date,
                "deleted_at" => null,
                "address_addition" => null,
                "city" => null,
                "coordinates" => null,
                "email" => null,
                "house_number" => null,
                "labels" => '{"de":"Regal 3", "en":"Rack 3", "it":"Scaffale 3"}',
                "location_type_id" => 3,
                "master_id" => 4,
                "phone_number" => null,
                "street" => null,
                "zip_code" => null,
            ], [
                "id" => 6,
                "active" => 1,
                "created_at" => $date,
                "updated_at" => $date,
                "deleted_at" => null,
                "address_addition" => null,
                "city" => null,
                "coordinates" => null,
                "email" => null,
                "house_number" => null,
                "labels" => '{"de":"Fach 98", "en":"Compartment 98", "it":"Cassetto 98"}',
                "location_type_id" => 3,
                "master_id" => 4,
                "phone_number" => null,
                "street" => null,
                "zip_code" => null,
            ], [
                "id" => 7,
                "active" => 1,
                "created_at" => $date,
                "updated_at" => $date,
                "deleted_at" => null,
                "address_addition" => null,
                "city" => null,
                "coordinates" => null,
                "email" => null,
                "house_number" => null,
                "labels" => '{"de":"Fach 99", "en":"Compartment 99", "it":"Cassetto 99"}',
                "location_type_id" => 3,
                "master_id" => 4,
                "phone_number" => null,
                "street" => null,
                "zip_code" => null,
            ], [
                "id" => 8,
                "active" => 1,
                "created_at" => $date,
                "updated_at" => $date,
                "deleted_at" => null,
                "address_addition" => null,
                "city" => null,
                "coordinates" => null,
                "email" => null,
                "house_number" => null,
                "labels" => '{"de":"Besprechnungsraum 1", "en":"Meeting Room 1", "it":"Sala delle conferenze 1"}',
                "location_type_id" => 2,
                "master_id" => 1,
                "phone_number" => null,
                "street" => null,
                "zip_code" => null,
            ], [
                "id" => 9,
                "active" => 1,
                "created_at" => $date,
                "updated_at" => $date,
                "deleted_at" => null,
                "address_addition" => null,
                "city" => null,
                "coordinates" => null,
                "email" => null,
                "house_number" => null,
                "labels" => '{"de":"Laderampe 1", "en":"Loading Ramp 1", "it":"Rampa di carico 1"}',
                "location_type_id" => 1,
                "master_id" => 1,
                "phone_number" => null,
                "street" => null,
                "zip_code" => null,
            ], [
                "id" => 10,
                "active" => 1,
                "created_at" => $date,
                "updated_at" => $date,
                "deleted_at" => null,
                "address_addition" => null,
                "city" => null,
                "coordinates" => null,
                "email" => null,
                "house_number" => null,
                "labels" => '{"de":"Laderampe 2", "en":"Loading Ramp 2", "it":"Rampa di carico 2"}',
                "location_type_id" => 1,
                "master_id" => 1,
                "phone_number" => null,
                "street" => null,
                "zip_code" => null,
            ],

        ]);
    } // run()

} // class VisitLocationSeeder extends Seeder {}
