<?php
/**
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-modules/visitor-management
 * @subpackage  Seeders
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanModules\VisitorManagement\Database\Seeders;


use BplanModules\VisitorManagement\Enums\VisitReasonDefaultIdentifier;
use BplanModules\VisitorManagement\Enums\VisitTypeIdentifier;
use BplanModules\VisitorManagement\Models\VisitReason;
use BplanModules\VisitorManagement\Models\VisitType;
use Illuminate\Database\Seeder;


/**
 *
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class VisitReasonSeeder extends Seeder
{

    /**
     * Run the database seeds.
     *
     * @return void
     *
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function run()
    {
        $date = date('Y-m-d H:i:s');

        $VisitTypeCollection = VisitType::get();

        $visitTypes = array_combine($VisitTypeCollection->pluck('identifier')->toArray(), $VisitTypeCollection->toArray());

        VisitReason::insert([
            [
                "id" => 1,
                "active" => 1,
                "created_at" => $date,
                "updated_at" => $date,
                "identifier" => VisitReasonDefaultIdentifier::AccessAuthorization->value,
                "internal" => 1,
                "labels" => '{"de":"Allgemein", "en":"General", "it": "Generale", "it":"Generale"}',
                "visit_type_id" => $visitTypes[VisitTypeIdentifier::AccessAuthorization->name]['id'],
            ], [
                "id" => 2,
                "active" => 1,
                "created_at" => $date,
                "updated_at" => $date,
                "identifier" => VisitReasonDefaultIdentifier::BulkAppointment->value,
                "internal" => 1,
                "labels" => '{"de":"Massentermin, allgemein", "en":"Bulk appointment, general", "it":"Appuntamenti massa, generale"}',
                "visit_type_id" => $visitTypes[VisitTypeIdentifier::BulkAppointment->name]['id'],
            ], [
                "id" => 3,
                "active" => 1,
                "created_at" => $date,
                "updated_at" => $date,
                "identifier" => VisitReasonDefaultIdentifier::Contractor->value,
                "internal" => 1,
                "labels" => '{"de":"Fremdarbeiter, allgemein", "en":"Contractor, general", "it":"Lavoratore straniero, generale"}',
                "visit_type_id" => $visitTypes[VisitTypeIdentifier::Contractor->name]['id'],
            ], [
                "id" => 4,
                "active" => 1,
                "created_at" => $date,
                "updated_at" => $date,
                "identifier" => VisitReasonDefaultIdentifier::Delivery->value,
                "internal" => 1,
                "labels" => '{"de":"Logistik Anlieferung", "en":"Logistic Delivery", "it":"Raccolta logistica"}',
                "visit_type_id" => $visitTypes[VisitTypeIdentifier::Delivery->name]['id'],
            ], [
                "id" => 5,
                "active" => 1,
                "created_at" => $date,
                "updated_at" => $date,
                "identifier" => VisitReasonDefaultIdentifier::DeliveryAndPickup->value,
                "internal" => 1,
                "labels" => '{"de":"Logistik Anlieferung & Abholung", "en":"Logistic Delivery & Pickup", "it":"Consegna e raccolta logistica"}',
                "visit_type_id" => $visitTypes[VisitTypeIdentifier::DeliveryAndPickup->name]['id'],
            ], [
                "id" => 6,
                "active" => 1,
                "created_at" => $date,
                "updated_at" => $date,
                "identifier" => VisitReasonDefaultIdentifier::ParcelService->value,
                "internal" => 1,
                "labels" => '{"de":"Paketdienst, allgemein", "en":"Parcel Service, general", "it":"Corriere, generale"}',
                "visit_type_id" => $visitTypes[VisitTypeIdentifier::ParcelService->name]['id'],
            ], [
                "id" => 7,
                "active" => 1,
                "created_at" => $date,
                "updated_at" => $date,
                "identifier" => VisitReasonDefaultIdentifier::Pickup->value,
                "internal" => 1,
                "labels" => '{"de":"Logistik Abholung", "en":"Logistic Pickup", "it":"Raccolta logistica"}',
                "visit_type_id" => $visitTypes[VisitTypeIdentifier::Pickup->name]['id'],
            ], [
                "id" => 8,
                "active" => 1,
                "created_at" => $date,
                "updated_at" => $date,
                "identifier" => VisitReasonDefaultIdentifier::Shunting->value,
                "internal" => 1,
                "labels" => '{"de":"Rangieren, allgemein", "en":"Shunting, general", "it":"Manovrare, generale"}',
                "visit_type_id" => $visitTypes[VisitTypeIdentifier::Shunting->name]['id'],
            ], [
                "id" => 9,
                "active" => 1,
                "created_at" => $date,
                "updated_at" => $date,
                "identifier" => VisitReasonDefaultIdentifier::SingleVisit->value,
                "internal" => 1,
                "labels" => '{"de":"Einzelbesuch, allgemein", "en":"Single visit, general", "it":"Visita individuale, generale"}',
                "visit_type_id" => $visitTypes[VisitTypeIdentifier::SingleVisit->name]['id'],
            ], [
                "id" => 10,
                "active" => 1,
                "created_at" => $date,
                "updated_at" => $date,
                "identifier" => VisitReasonDefaultIdentifier::Technician->value,
                "internal" => 1,
                "labels" => '{"de":"Techniker, allgemein", "en":"Technician, general", "it":"Tecnico, generale"}',
                "visit_type_id" => $visitTypes[VisitTypeIdentifier::Technician->name]['id'],
            ],

        ]);
    } // run()

} // class VisitReasonSeeder extends Seeder {}
