<div x-data="editAppointment" x-cloak x-show="show" id="editAppointmentModal" tabindex="-1"
    x-on:show-edit-appointment-modal.window="showModal($event)" x-on:appointment-edited.window="edited($event)"
    x-on:appointment-deleted.window="deleted($event)" x-on:appointment-pagination-updated="paginationUpdated"
    x-on:save-edit-appointment="onSave"
    class="fixed top-0 left-0 right-0 z-50 flex items-center justify-center w-full h-screen overflow-x-hidden overflow-y-auto md:inset-0 md:h-full">
    <div class="fixed inset-0 transition-opacity bg-gray-500 bg-opacity-75"></div>
    <div class="relative w-full h-full max-w-5xl p-4 md:h-auto">
        <!-- Modal content -->
        <div class="relative p-4 bg-white rounded-lg shadow dark:bg-gray-800 sm:p-5">
            <!-- Modal header -->
            <div class="flex items-center justify-between pb-4 mb-4 border-b rounded-t sm:mb-5 dark:border-gray-600">

                <div class="flex items-center space-x-2 text-gray-900 dark:text-white">
                    {{-- calendar-date-range --}}
                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor" class="size-6">
                        <path
                            d="M12 11.993a.75.75 0 0 0-.75.75v.006c0 .414.336.75.75.75h.006a.75.75 0 0 0 .75-.75v-.006a.75.75 0 0 0-.75-.75H12ZM12 16.494a.75.75 0 0 0-.75.75v.005c0 .414.335.75.75.75h.005a.75.75 0 0 0 .75-.75v-.005a.75.75 0 0 0-.75-.75H12ZM8.999 17.244a.75.75 0 0 1 .75-.75h.006a.75.75 0 0 1 .75.75v.006a.75.75 0 0 1-.75.75h-.006a.75.75 0 0 1-.75-.75v-.006ZM7.499 16.494a.75.75 0 0 0-.75.75v.005c0 .414.336.75.75.75h.005a.75.75 0 0 0 .75-.75v-.005a.75.75 0 0 0-.75-.75H7.5ZM13.499 14.997a.75.75 0 0 1 .75-.75h.006a.75.75 0 0 1 .75.75v.005a.75.75 0 0 1-.75.75h-.006a.75.75 0 0 1-.75-.75v-.005ZM14.25 16.494a.75.75 0 0 0-.75.75v.006c0 .414.335.75.75.75h.005a.75.75 0 0 0 .75-.75v-.006a.75.75 0 0 0-.75-.75h-.005ZM15.75 14.995a.75.75 0 0 1 .75-.75h.005a.75.75 0 0 1 .75.75v.006a.75.75 0 0 1-.75.75H16.5a.75.75 0 0 1-.75-.75v-.006ZM13.498 12.743a.75.75 0 0 1 .75-.75h2.25a.75.75 0 1 1 0 1.5h-2.25a.75.75 0 0 1-.75-.75ZM6.748 14.993a.75.75 0 0 1 .75-.75h4.5a.75.75 0 0 1 0 1.5h-4.5a.75.75 0 0 1-.75-.75Z" />
                        <path fill-rule="evenodd"
                            d="M18 2.993a.75.75 0 0 0-1.5 0v1.5h-9V2.994a.75.75 0 1 0-1.5 0v1.497h-.752a3 3 0 0 0-3 3v11.252a3 3 0 0 0 3 3h13.5a3 3 0 0 0 3-3V7.492a3 3 0 0 0-3-3H18V2.993ZM3.748 18.743v-7.5a1.5 1.5 0 0 1 1.5-1.5h13.5a1.5 1.5 0 0 1 1.5 1.5v7.5a1.5 1.5 0 0 1-1.5 1.5h-13.5a1.5 1.5 0 0 1-1.5-1.5Z"
                            clip-rule="evenodd" />
                    </svg>


                    <h3 class="text-lg font-semibold text-gray-900 dark:text-white">
                        @lang('visitor-management::visit-appointments.modal.edit.heading')
                    </h3>
                    <span>#{{ $appointment?->id }}</span>
                </div>
                <button x-on:click="hideModal()" type="button"
                    class="text-gray-400 bg-transparent hover:bg-gray-200 hover:text-gray-900 rounded-lg text-sm p-1.5 ml-auto inline-flex items-center dark:hover:bg-gray-600 dark:hover:text-white">
                    <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
                        <path fill-rule="evenodd"
                            d="M4.293 4.293a1 1 0 011.414 0L10 8.586l4.293-4.293a1 1 0 111.414 1.414L11.414 10l4.293 4.293a1 1 0 01-1.414 1.414L10 11.414l-4.293 4.293a1 1 0 01-1.414-1.414L8.586 10 4.293 5.707a1 1 0 010-1.414z"
                            clip-rule="evenodd"></path>
                    </svg>
                    <span class="sr-only">
                        @lang('globals::global.action.close')
                    </span>
                </button>
            </div>
            <!-- Modal body -->
            <div>
                <div
                    class="mb-8 text-sm font-medium text-center text-gray-500 border-b border-gray-200 dark:text-gray-400 dark:border-gray-700">
                    <ul class="flex flex-wrap -mb-px">
                        <li class="me-2" x-on:click="tab = 'main'">
                            <button type="button"
                                :class="{
                                    'hover:text-gray-600 hover:border-gray-300 dark:hover:text-gray-300 border-transparent': tab !=
                                        'main',
                                    'active text-primary-600 border-primary-600 dark:text-primary-500 dark:border-primary-500': tab ==
                                        'main'
                                }"
                                class="inline-block p-4 border-b-2 rounded-t-lg">
                                @lang('visitor-management::visit-appointments.tab.appointment')
                            </button>
                        </li>
                        <li class="me-2" x-on:click="tab = 'equipment'"
                            x-show="userHasHostRole && isBulkVisit === false">
                            <button type="button"
                                :class="{
                                    'hover:text-gray-600 hover:border-gray-300 dark:hover:text-gray-300 border-transparent': tab !=
                                        'equipment',
                                    'active equipment-primary-600 border-primary-600 dark:text-primary-500 dark:border-primary-500': tab ==
                                        'equipment'
                                }"
                                class="inline-block p-4 border-b-2 rounded-t-lg" aria-current="page">
                                <div>
                                    @lang('visitor-management::visit-appointments.tab.equipment-items')
                                </div>
                            </button>
                        </li>
                    </ul>
                </div>
                <div x-show="tab == 'main'">
                    {{-- STEPPER --}}
                    <ol
                        class="flex items-center w-full text-sm font-medium text-center text-gray-500 dark:text-gray-400 sm:text-base">
                        {{-- x-on:click="appointmentStep =  @js(\BplanModules\VisitorManagement\Enums\AppointmentSteps::General->value)" --}}
                        <li :class="{ 'text-primary-600 dark:text-primary-500': appointmentStep == @js(\BplanModules\VisitorManagement\Enums\AppointmentSteps::General->value) }"
                            class="flex md:w-full items-center sm:after:content-[''] after:w-full after:h-1 after:border-b after:border-gray-200 after:border-1 after:hidden sm:after:inline-block after:mx-6 xl:after:mx-10 dark:after:border-gray-700">
                            <span
                                class="flex items-center after:content-['/'] sm:after:hidden after:mx-2 after:text-gray-200 dark:after:text-gray-500">
                                <svg x-show="appointmentStep > @js(\BplanModules\VisitorManagement\Enums\AppointmentSteps::General->value)"
                                    class="w-3.5 h-3.5 sm:w-4 sm:h-4 me-2.5" aria-hidden="true"
                                    xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 20 20">
                                    <path
                                        d="M10 .5a9.5 9.5 0 1 0 9.5 9.5A9.51 9.51 0 0 0 10 .5Zm3.707 8.207-4 4a1 1 0 0 1-1.414 0l-2-2a1 1 0 0 1 1.414-1.414L9 10.586l3.293-3.293a1 1 0 0 1 1.414 1.414Z" />
                                </svg>
                                <span x-show="appointmentStep == @js(\BplanModules\VisitorManagement\Enums\AppointmentSteps::General->value)"
                                    class="relative flex items-center justify-center size-5 shrink-0 me-1"
                                    aria-hidden="true">
                                    <span class="absolute rounded-full size-4 bg-primary-200"></span>
                                    <span class="relative block rounded-full size-2 bg-primary-600"></span>
                                </span>
                                @lang('visitor-management::visit-appointments.wizard.general')
                            </span>
                        </li>
                        {{-- x-on:click="appointmentStep =  @js(\BplanModules\VisitorManagement\Enums\AppointmentSteps::Visitors->value)" --}}
                        <li :class="{ 'text-primary-600 dark:text-primary-500': appointmentStep == @js(\BplanModules\VisitorManagement\Enums\AppointmentSteps::Visitors->value) }"
                            class="flex md:w-full items-center after:content-[''] after:w-full after:h-1 after:border-b after:border-gray-200 after:border-1 after:hidden sm:after:inline-block after:mx-6 xl:after:mx-10 dark:after:border-gray-700">
                            <span
                                class="flex items-center after:content-['/'] sm:after:hidden after:mx-2 after:text-gray-200 dark:after:text-gray-500">
                                <svg x-show="appointmentStep > @js(\BplanModules\VisitorManagement\Enums\AppointmentSteps::Visitors->value)"
                                    class="w-3.5 h-3.5 sm:w-4 sm:h-4 me-2.5" aria-hidden="true"
                                    xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 20 20">
                                    <path
                                        d="M10 .5a9.5 9.5 0 1 0 9.5 9.5A9.51 9.51 0 0 0 10 .5Zm3.707 8.207-4 4a1 1 0 0 1-1.414 0l-2-2a1 1 0 0 1 1.414-1.414L9 10.586l3.293-3.293a1 1 0 0 1 1.414 1.414Z" />
                                </svg>
                                <span x-show="appointmentStep == @js(\BplanModules\VisitorManagement\Enums\AppointmentSteps::Visitors->value)"
                                    class="relative flex items-center justify-center size-5 shrink-0 me-1"
                                    aria-hidden="true">
                                    <span class="absolute rounded-full size-4 bg-primary-200"></span>
                                    <span class="relative block rounded-full size-2 bg-primary-600"></span>
                                </span>
                                @lang('visitor-management::visit-appointments.wizard.visitors')
                            </span>
                        </li>
                        <li :class="{ 'text-primary-600 dark:text-primary-500': appointmentStep == @js(\BplanModules\VisitorManagement\Enums\AppointmentSteps::Visitors->value) }"
                            class="flex items-center">
                            <span x-show="appointmentStep == @js(\BplanModules\VisitorManagement\Enums\AppointmentSteps::Overview->value)"
                                class="relative flex items-center justify-center size-5 shrink-0 me-1"
                                aria-hidden="true">
                                <span class="absolute rounded-full size-4 bg-primary-200"></span>
                                <span class="relative block rounded-full size-2 bg-primary-600"></span>
                            </span>
                            @lang('visitor-management::visit-appointments.wizard.summary')
                        </li>
                    </ol>
                    <div id="tabContainer" class="my-8">
                        {{-- GENERAL --}}
                        <div x-show="appointmentStep == @js(\BplanModules\VisitorManagement\Enums\AppointmentSteps::General->value)"
                            class="grid gap-4 my-4 sm:grid-cols-2">
                            <div class="flex items-center"
                                x-show="visitReasonId == null || (visitReasons?.find((element) => element.id == visitReasonId)?.visit_type.dependencies?.spontaneous_visit ?? {{ \BplanBase\Globals\Enums\RequireStatus::Optional }}) > {{ \BplanBase\Globals\Enums\RequireStatus::NotUsed }}">
                                <label class="inline-flex items-center cursor-pointer">
                                    <input id="isSpontaneousVisit" :disabled="!userHasHostRole || editSucceeded"
                                        wire:model="isSpontaneousVisit" type="checkbox" value=""
                                        class="sr-only peer">
                                    <div
                                        class="relative w-11 h-6 bg-gray-200 peer-focus:outline-none peer-focus:ring-4 peer-focus:ring-primary-300 dark:peer-focus:ring-primary-800 rounded-full peer dark:bg-gray-700 peer-checked:after:translate-x-full rtl:peer-checked:after:-translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:start-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all dark:border-gray-600 peer-checked:bg-primary-600">
                                    </div>
                                    <span class="text-sm font-medium text-gray-900 ms-3 dark:text-gray-300">
                                        @lang('visitor-management::visit-appointments.label.spontaneous_visit')
                                    </span>
                                </label>
                                <x-input-error for="isSpontaneousVisit" />
                            </div>
                            <div class="col-span-2">
                                <div class="flex items-center mb-2 space-x-1">
                                    <label for="subject"
                                        class="block text-sm font-medium text-gray-900 dark:text-white">
                                        @lang('visitor-management::visit-appointments.label.subject')
                                        <x-global-components::global.input-required-hint
                                            x-show="(visitReasons?.find((element) => element.id == visitReasonId)?.visit_type?.dependencies?.spontaneous_visit ?? {{ \BplanBase\Globals\Enums\RequireStatus::Required }}) >= {{ \BplanBase\Globals\Enums\RequireStatus::Required }}" />
                                    </label>
                                </div>
                                <input :disabled="!userHasHostRole || editSucceeded"
                                    @keyup.enter="$wire.editAppointment" type="text" wire:model="subject"
                                    id="subject"
                                    class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500"
                                    placeholder="@lang('visitor-management::visit-appointments.placeholder.subject')">
                                <x-input-error for="subject" />
                            </div>
                            <div x-cloak>
                                <label for="visitReasonId"
                                    class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">
                                    @lang('visitor-management::visit-appointments.label.visit-reason')
                                    <x-global-components::global.input-required-hint />
                                </label>
                                <select :disabled="!userHasHostRole || editSucceeded" x-model="visitReasonId"
                                    id="visitReasonId"
                                    class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-500 focus:border-primary-500 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500"
                                    placeholder="@lang('visitor-management::visit-appointments.label.visit-reason')">
                                    @foreach ($visitReasonsByVisitType as $visitType => $_visitReasons)
                                        <optgroup wire:key="visittype-{{ $visitType }}"
                                            label="{{ __('visitor-management::visit-types.identifier.' . $visitType) }}"
                                            @if (
                                                (!empty($bulkVisitTypeIdentifier) && $bulkVisitTypeIdentifier != $visitType) ||
                                                    (empty($bulkVisitTypeIdentifier) && $visitType != $appointment?->visitType->identifier)) x-show="false" @endif>
                                            @foreach ($_visitReasons as $visitReason)
                                                <option wire:key="visitreason-{{ $visitReason->id }}"
                                                    value="{{ $visitReason->id }}">
                                                    {{ $visitReason->labels->{app()->getLocale()} ?? 'N/A' }}
                                                    {{ !empty($bulkVisitTypeIdentifier) ? '(' . __('visitor-management::visit-appointments.label.mass-appointment') . ')' : '' }}
                                                </option>
                                            @endforeach
                                        </optgroup>
                                    @endforeach
                                </select>
                                <x-input-error for="visitReasonId" />
                            </div>
                            <div class="col-start-1"
                                x-show="visitReasonId == null || (visitReasons?.find((element) => element.id == visitReasonId)?.visit_type.dependencies?.valid_from ?? {{ \BplanBase\Globals\Enums\RequireStatus::Optional }}) > {{ \BplanBase\Globals\Enums\RequireStatus::NotUsed }}">
                                <div class="flex items-center mb-2 space-x-1">
                                    <label for="editStartDate"
                                        class="block text-sm font-medium text-gray-900 dark:text-white">
                                        @lang('visitor-management::visit-appointments.label.start-date')
                                        <x-global-components::global.input-required-hint />
                                    </label>
                                </div>
                                <div wire:ignore>
                                    <input :disabled="!userHasHostRole || editSucceeded"
                                        @keyup.enter="$wire.editAppointment" type="text" wire:model="startDate"
                                        readonly="readonly" id="editStartDate"
                                        class="flatpickr-input bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500"
                                        placeholder="@lang('visitor-management::visit-appointments.placeholder.start-date')">
                                </div>
                                <x-input-error for="startDate" />
                            </div>
                            <div
                                x-show="visitReasonId == null || (visitReasons?.find((element) => element.id == visitReasonId)?.visit_type.dependencies?.valid_from ?? {{ \BplanBase\Globals\Enums\RequireStatus::Optional }}) > {{ \BplanBase\Globals\Enums\RequireStatus::NotUsed }}">
                                <div class="flex items-center mb-2 space-x-1">
                                    <label for="editStartTime"
                                        class="block text-sm font-medium text-gray-900 dark:text-white">
                                        @lang('visitor-management::visit-appointments.label.start-time')
                                        <x-global-components::global.input-required-hint />
                                    </label>
                                </div>
                                <div class="relative">
                                    <div
                                        class="absolute inset-y-0 end-0 top-0 flex items-center pe-3.5 pointer-events-none">
                                        <svg class="w-4 h-4 text-gray-500 dark:text-gray-400" aria-hidden="true"
                                            xmlns="http://www.w3.org/2000/svg" fill="currentColor"
                                            viewBox="0 0 24 24">
                                            <path fill-rule="evenodd"
                                                d="M2 12C2 6.477 6.477 2 12 2s10 4.477 10 10-4.477 10-10 10S2 17.523 2 12Zm11-4a1 1 0 1 0-2 0v4a1 1 0 0 0 .293.707l3 3a1 1 0 0 0 1.414-1.414L13 11.586V8Z"
                                                clip-rule="evenodd" />
                                        </svg>
                                    </div>
                                    <div wire:ignore>
                                        <input :disabled="!userHasHostRole || editSucceeded"
                                            @keyup.enter="$wire.editAppointment" type="time"
                                            wire:model="startTime" id="editStartTime"
                                            class="flatpickr-input bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500"
                                            placeholder="@lang('visitor-management::visit-appointments.placeholder.start-time')">
                                    </div>
                                </div>
                                <x-input-error for="editStartTime" />
                            </div>
                            <div class="col-start-1"
                                x-show="visitReasonId == null || (visitReasons?.find((element) => element.id == visitReasonId)?.visit_type.dependencies?.end ?? {{ \BplanBase\Globals\Enums\RequireStatus::Optional }}) > {{ \BplanBase\Globals\Enums\RequireStatus::NotUsed }}">
                                <div class="flex items-center mb-2 space-x-1">
                                    <label for="editEndDate"
                                        class="block text-sm font-medium text-gray-900 dark:text-white">
                                        @lang('visitor-management::visit-appointments.label.end-date')
                                        <x-global-components::global.input-required-hint />
                                    </label>
                                </div>
                                <div wire:ignore>
                                    <input :disabled="!userHasHostRole || editSucceeded"
                                        @keyup.enter="$wire.editAppointment" type="text" wire:model="endDate"
                                        readonly="readonly" id="editEndDate"
                                        class="flatpickr-input bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500"
                                        placeholder="@lang('visitor-management::visit-appointments.placeholder.end-date')">
                                </div>
                                <x-input-error for="editEndDate" />
                                <x-input-error for="appointmentEnd" />
                            </div>
                            <div
                                x-show="visitReasonId == null || (visitReasons?.find((element) => element.id == visitReasonId)?.visit_type.dependencies?.end ?? {{ \BplanBase\Globals\Enums\RequireStatus::Optional }}) > {{ \BplanBase\Globals\Enums\RequireStatus::NotUsed }}">
                                <div class="flex items-center mb-2 space-x-1">
                                    <label for="editEndTime"
                                        class="block text-sm font-medium text-gray-900 dark:text-white">
                                        @lang('visitor-management::visit-appointments.label.end-time')
                                        <x-global-components::global.input-required-hint />
                                    </label>
                                </div>
                                <div class="relative">
                                    <div
                                        class="absolute inset-y-0 end-0 top-0 flex items-center pe-3.5 pointer-events-none">
                                        <svg class="w-4 h-4 text-gray-500 dark:text-gray-400" aria-hidden="true"
                                            xmlns="http://www.w3.org/2000/svg" fill="currentColor"
                                            viewBox="0 0 24 24">
                                            <path fill-rule="evenodd"
                                                d="M2 12C2 6.477 6.477 2 12 2s10 4.477 10 10-4.477 10-10 10S2 17.523 2 12Zm11-4a1 1 0 1 0-2 0v4a1 1 0 0 0 .293.707l3 3a1 1 0 0 0 1.414-1.414L13 11.586V8Z"
                                                clip-rule="evenodd" />
                                        </svg>
                                    </div>
                                    <div wire:ignore>
                                        <input :disabled="!userHasHostRole || editSucceeded"
                                            @keyup.enter="$wire.editAppointment" type="time" wire:model="endTime"
                                            id="editEndTime"
                                            class="flatpickr-input bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500"
                                            placeholder="@lang('visitor-management::visit-appointments.placeholder.end-time')">
                                    </div>
                                </div>
                                <x-input-error for="editEndTime" />
                            </div>
                        </div>
                        {{-- VISITORS --}}
                        <div x-show="appointmentStep == @js(\BplanModules\VisitorManagement\Enums\AppointmentSteps::Visitors->value)"
                            class="grid gap-4 my-4 sm:grid-cols-2">
                            <div
                                x-show="visitReasonId == null || (visitReasons?.find((element) => element.id == visitReasonId)?.visit_type.dependencies?.main_employee_id ?? {{ \BplanBase\Globals\Enums\RequireStatus::Optional }}) > {{ \BplanBase\Globals\Enums\RequireStatus::NotUsed }}">
                                <label for="comboBoxMainEmployee"
                                    class="flex mb-2 space-x-1 text-sm font-medium text-gray-900 dark:text-white">
                                    @lang('visitor-management::visit-appointments.label.organizer')
                                    <x-global-components::global.input-required-hint
                                        x-show="(visitReasons?.find((element) => element.id == visitReasonId)?.visit_type.dependencies?.organizer_employee_id ?? {{ \BplanBase\Globals\Enums\RequireStatus::Optional }}) >= {{ \BplanBase\Globals\Enums\RequireStatus::Required }}" />
                                    <x-global-components::global.information-icon
                                        data-tippy-content="{{ __('visitor-management::visit-appointments.label.info.organizer') }}" />
                                </label>
                                <x-global-components::inputs.combo-box itemsKey="organizers" :items="$filteredComboBoxData['organizers']" :placeholder="__('visitor-management::visit-employees.search_for_employees')"
                                    :multiple="false" />
                                <div class="mt-2">
                                    @foreach ($comboBoxData['organizers'] as $index => $comboBoxMainEmployees)
                                        @if (isset($comboBoxMainEmployees['isSelected']) && $comboBoxMainEmployees['isSelected'])
                                            <x-global-components::inputs.combo-box-badge :label="$comboBoxMainEmployees['label'] ?? ''" itemsKey="organizers"
                                                :index="$index" />
                                        @endif
                                    @endforeach
                                </div>
                                <x-input-error for="organizerEmployeeId" />
                            </div>
                            <div
                                x-show="visitReasonId == null || (visitReasons?.find((element) => element.id == visitReasonId)?.visit_type.dependencies?.main_employee_id ?? {{ \BplanBase\Globals\Enums\RequireStatus::Optional }}) > {{ \BplanBase\Globals\Enums\RequireStatus::NotUsed }}">
                                <label for="comboBoxMainEmployee"
                                    class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">
                                    @lang('visitor-management::visit-appointments.label.employee')
                                    <x-global-components::global.input-required-hint
                                        x-show="(visitReasons?.find((element) => element.id == visitReasonId)?.visit_type.dependencies?.main_employee_id ?? {{ \BplanBase\Globals\Enums\RequireStatus::Optional }}) >= {{ \BplanBase\Globals\Enums\RequireStatus::Required }}" />
                                </label>
                                <x-global-components::inputs.combo-box itemsKey="mainEmployees" :items="$filteredComboBoxData['mainEmployees']" :placeholder="__('visitor-management::visit-appointments.search-label.employees')"
                                    :multiple="false" />
                                <div class="mt-2">
                                    @foreach ($comboBoxData['mainEmployees'] as $index => $comboBoxMainEmployees)
                                        @if (isset($comboBoxMainEmployees['isSelected']) && $comboBoxMainEmployees['isSelected'])
                                            <x-global-components::inputs.combo-box-badge :label="$comboBoxMainEmployees['label'] ?? ''" itemsKey="mainEmployees"
                                                :index="$index" />
                                        @endif
                                    @endforeach
                                </div>
                                <x-input-error for="mainEmployeeId" />
                            </div>
                            <div
                                x-show="isBulkVisit == false && (visitReasonId == null || (visitReasons?.find((element) => element.id == visitReasonId)?.visit_type.dependencies?.main_visitor_id ?? {{ \BplanBase\Globals\Enums\RequireStatus::Optional }}) > {{ \BplanBase\Globals\Enums\RequireStatus::NotUsed }})">
                                <label for="comboBoxMainVisitor"
                                    class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">
                                    @lang('visitor-management::visit-appointments.label.main-visitor')
                                    <x-global-components::global.input-required-hint
                                        x-show="(visitReasons?.find((element) => element.id == visitReasonId)?.visit_type.dependencies?.main_visitor_id ?? {{ \BplanBase\Globals\Enums\RequireStatus::Optional }}) >= {{ \BplanBase\Globals\Enums\RequireStatus::Required }}" />
                                </label>
                                <x-global-components::inputs.combo-box itemsKey="mainVisitors" :items="$filteredComboBoxData['mainVisitors']" :placeholder="__('visitor-management::visit-appointments.search-label.visitors')"
                                    :multiple="false" />
                                <div class="mt-2">
                                    @foreach ($comboBoxData['mainVisitors'] as $index => $comboBoxMainVisitors)
                                        @if (isset($comboBoxMainVisitors['isSelected']) && $comboBoxMainVisitors['isSelected'])
                                            <x-global-components::inputs.combo-box-badge :label="$comboBoxMainVisitors['label'] ?? ''" itemsKey="mainVisitors"
                                                :index="$index" />
                                        @endif
                                    @endforeach
                                </div>
                                <x-input-error for="mainVisitorId" />
                            </div>
                            <div
                                x-show="isBulkVisit || visitReasonId == null || (visitReasons?.find((element) => element.id == visitReasonId)?.visit_type.dependencies?.visitors ?? {{ \BplanBase\Globals\Enums\RequireStatus::Optional }}) > {{ \BplanBase\Globals\Enums\RequireStatus::NotUsed }}">
                                <label for="comboBoxVisitors"
                                    class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">
                                    @lang('visitor-management::visit-appointments.label.visitors')
                                    <x-global-components::global.input-required-hint
                                        x-show="(visitReasons?.find((element) => element.id == visitReasonId)?.visit_type.dependencies?.visitors ?? {{ \BplanBase\Globals\Enums\RequireStatus::Optional }}) >= {{ \BplanBase\Globals\Enums\RequireStatus::Required }}" />
                                </label>
                                {{-- UPLOAD VISITORS --}}

                                <button
                                    x-show="(visitReasons?.find((element) => element.id == visitReasonId)?.visit_type.identifier ?? 'invalid') == @js(\BplanModules\VisitorManagement\Enums\VisitTypeIdentifier::GroupVisit)"
                                    x-on:click="$dispatch('show-upload-visitors-modal', { appointment: @js($appointment) })"
                                    type="button"
                                    class="px-3 py-2 text-xs font-medium text-center text-white rounded-lg bg-primary-700 hover:bg-primary-800 focus:ring-4 focus:outline-none focus:ring-primary-300 dark:bg-primary-600 dark:hover:bg-primary-700 dark:focus:ring-bluprimarye-800">
                                    @lang('visitor-management::visit-appointments.action.import-visitors')
                                </button>
                                <x-global-components::inputs.combo-box
                                    x-show="(visitReasons?.find((element) => element.id == visitReasonId)?.visit_type.identifier ?? 'invalid') != '{{ \BplanModules\VisitorManagement\Enums\VisitTypeIdentifier::GroupVisit->value }}'"
                                    itemsKey="visitors" :items="$filteredComboBoxData['visitors']" :placeholder="__('visitor-management::visit-appointments.search-label.visitors')" />

                                <div class="mt-2 flex flex-wrap gap-1">
                                    @if ($appointment?->visitType->identifier != \BplanModules\VisitorManagement\Enums\VisitTypeIdentifier::GroupVisit->value)
                                        @foreach ($comboBoxData['visitors'] as $index => $comboBoxVisitor)
                                            @if (isset($comboBoxVisitor['isSelected']) && $comboBoxVisitor['isSelected'])
                                                <x-global-components::inputs.combo-box-badge :label="$comboBoxVisitor['label'] ?? ''" itemsKey="visitors"
                                                    :index="$index" />
                                                {{-- :isDeleteable="!empty($appointment->finished_at)" --}}
                                            @endif
                                        @endforeach
                                    @elseif ($appointment?->visitType->identifier == \BplanModules\VisitorManagement\Enums\VisitTypeIdentifier::GroupVisit->value)
                                        @if (isset($appointmentVisitors) && !empty($appointmentVisitors))
                                            @foreach ($appointmentVisitors as $index => $visitor)
                                                <span
                                                    class="bg-primary-100 text-primary-800 text-xs font-medium me-2 px-2.5 py-0.5 rounded dark:bg-primary-900 dark:text-primary-300">
                                                    {{ $visitor->first_name }} {{ $visitor->last_name }}
                                                    ({{ $visitor->email ?? '-' }})
                                                    <button type="button"
                                                        wire:click="removeVisitor(@js($index))"
                                                        class="inline-flex items-center p-1 text-sm bg-transparent rounded-sm ms-2 text-primary-400 hover:bg-primary-200 hover:text-primary-900 dark:hover:bg-primary-800 dark:hover:text-primary-300"
                                                        data-dismiss-target="#badge-dismiss-default"
                                                        aria-label="Remove">
                                                        <svg class="w-2 h-2" aria-hidden="true"
                                                            xmlns="http://www.w3.org/2000/svg" fill="none"
                                                            viewBox="0 0 14 14">
                                                            <path stroke="currentColor" stroke-linecap="round"
                                                                stroke-linejoin="round" stroke-width="2"
                                                                d="m1 1 6 6m0 0 6 6M7 7l6-6M7 7l-6 6" />
                                                        </svg>
                                                    </button>
                                                </span>
                                            @endforeach
                                        @endif
                                    @endif
                                </div>
                                <x-input-error for="visitors" />
                            </div>
                            <div class="col-start-1">
                                <div class="flex items-center col-start-1 mb-2"
                                    x-show="visitReasonId == null || (visitReasons?.find((element) => element.id == visitReasonId)?.visit_type.dependencies?.drive_on_area_permitted ?? {{ \BplanBase\Globals\Enums\RequireStatus::Optional }}) > {{ \BplanBase\Globals\Enums\RequireStatus::NotUsed }}">
                                    <label class="inline-flex items-center cursor-pointer">
                                        <input id="driveOnAreaPermitted" :disabled="!userHasHostRole || editSucceeded"
                                            wire:model="driveOnAreaPermitted" type="checkbox" value=""
                                            class="sr-only peer">
                                        <div
                                            class="relative w-11 h-6 bg-gray-200 peer-focus:outline-none peer-focus:ring-4 peer-focus:ring-primary-300 dark:peer-focus:ring-primary-800 rounded-full peer dark:bg-gray-700 peer-checked:after:translate-x-full rtl:peer-checked:after:-translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:start-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all dark:border-gray-600 peer-checked:bg-primary-600">
                                        </div>
                                        <span class="text-sm font-medium text-gray-900 ms-3 dark:text-gray-300">
                                            @lang('visitor-management::visit-appointments.label.drive-on-area')
                                        </span>
                                    </label>
                                    <x-input-error for="driveOnAreaPermitted" />
                                </div>
                                <div class="my-2"
                                    :class="{ 'cursor-not-allowed opacity-25': !driveOnAreaPermitted }"
                                    :style="{ 'pointer-events': driveOnAreaPermitted ? 'all' : 'none' }"
                                    x-show="visitReasonId == null || (visitReasons?.find((element) => element.id == visitReasonId)?.visit_type.dependencies?.license_plate_formatted ?? {{ \BplanBase\Globals\Enums\RequireStatus::Optional }}) > {{ \BplanBase\Globals\Enums\RequireStatus::NotUsed }} || driveOnAreaPermitted == true">
                                    <div class="flex items-center mb-2 space-x-1">
                                        <label for="name"
                                            class="inline-flex text-sm font-medium text-gray-900 dark:text-white">
                                            @lang('visitor-management::visit-appointments.label.license-plate')
                                            <x-global-components::global.input-required-hint
                                                x-show="!isSpontaneousVisit && (visitReasons?.find((element) => element.id == visitReasonId)?.visit_type?.dependencies?.license_plate_formatted ?? {{ \BplanBase\Globals\Enums\RequireStatus::Optional }}) >= {{ \BplanBase\Globals\Enums\RequireStatus::Required }} " />
                                            {{-- <x-global-components::global.information-icon
                                            data-tippy-content="{{ __('global.license_plate_information') }}" /> --}}
                                        </label>
                                    </div>
                                    {{-- <x-visitor-management::global.input-license-plates :licensePlates="$licensePlates" target="create" /> --}}
                                    <input :disabled="!userHasHostRole || editSucceeded"
                                        @keyup.enter="$wire.editAppointment" type="text" x-on:change
                                        wire:model="licensePlateFormatted" id="licensePlateFormatted"
                                        class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500"
                                        placeholder="@lang('visitor-management::visit-appointments.label.license-plate')">
                                    <x-input-error for="licensePlateFormatted" />
                                </div>
                                <x-input-error for="licensePlates" />
                            </div>
                            <div
                                x-show="visitReasonId == null || (visitReasons?.find((element) => element.id == visitReasonId)?.visit_type?.dependencies?.order_number ?? {{ \BplanBase\Globals\Enums\RequireStatus::Optional }}) > {{ \BplanBase\Globals\Enums\RequireStatus::NotUsed }}">
                                <div class="mt-8"
                                    x-show="visitReasonId == null || (visitReasons?.find((element) => element.id == visitReasonId)?.visit_type.dependencies?.drive_on_area_permitted ?? {{ \BplanBase\Globals\Enums\RequireStatus::Optional }}) > {{ \BplanBase\Globals\Enums\RequireStatus::NotUsed }}">
                                    {{-- Abstand um checkbox (Zufahrt erlaubt) auszugleichen --}}
                                </div>
                                <div class="flex items-center mb-2 space-x-1">
                                    <label for="name"
                                        class="block text-sm font-medium text-gray-900 dark:text-white">
                                        @lang('visitor-management::visit-appointments.label.order-number')
                                        <x-global-components::global.input-required-hint
                                            x-show="(visitReasons?.find((element) => element.id == visitReasonId)?.visit_type.dependencies?.order_number ?? {{ \BplanBase\Globals\Enums\RequireStatus::Optional }}) >= {{ \BplanBase\Globals\Enums\RequireStatus::Required }}" />
                                    </label>
                                </div>
                                <input :disabled="!userHasHostRole || editSucceeded"
                                    @keyup.enter="$wire.editAppointment" type="text" x-on:change
                                    wire:model="orderNumber" id="order_number"
                                    class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500"
                                    placeholder="@lang('visitor-management::visit-appointments.placeholder.order-number')">
                                <x-input-error for="order_number" />
                            </div>
                            <div class="flex items-center col-start-1"
                                :class="{ 'cursor-not-allowed opacity-25': requireEscort }"
                                x-show="visitReasonId == null || (visitReasons?.find((element) => element.id == visitReasonId)?.visit_type.dependencies?.internal_visit ?? {{ \BplanBase\Globals\Enums\RequireStatus::Optional }}) > {{ \BplanBase\Globals\Enums\RequireStatus::NotUsed }}">
                                <label class="inline-flex items-center cursor-pointer">
                                    <input id="internalVisit"
                                        :disabled="!userHasHostRole || requireEscort || editSucceeded"
                                        wire:model="internalVisit" type="checkbox" value=""
                                        class="sr-only peer">
                                    <div
                                        class="relative w-11 h-6 bg-gray-200 peer-focus:outline-none peer-focus:ring-4 peer-focus:ring-primary-300 dark:peer-focus:ring-primary-800 rounded-full peer dark:bg-gray-700 peer-checked:after:translate-x-full rtl:peer-checked:after:-translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:start-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all dark:border-gray-600 peer-checked:bg-primary-600">
                                    </div>
                                    <span class="text-sm font-medium text-gray-900 ms-3 dark:text-gray-300">
                                        @lang('visitor-management::visit-appointments.label.internal-visit')
                                    </span>
                                </label>
                                <x-input-error for="internalVisit" />
                            </div>
                            <div class="flex items-center"
                                x-show="visitReasonId == null || visitReasons?.find((element) => element.id == visitReasonId)?.visit_type.with_minors != '{{ \BplanModules\VisitorManagement\Enums\VisitTypeIdentifier::AccessAuthorization->value }}'">
                                <label class="inline-flex items-center cursor-pointer">
                                    <input id="withMinors" :disabled="!userHasHostRole || editSucceeded"
                                        wire:model.live="withMinors" type="checkbox" value=""
                                        class="sr-only peer">
                                    <div
                                        class="relative w-11 h-6 bg-gray-200 peer-focus:outline-none peer-focus:ring-4 peer-focus:ring-primary-300 dark:peer-focus:ring-primary-800 rounded-full peer dark:bg-gray-700 peer-checked:after:translate-x-full rtl:peer-checked:after:-translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:start-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all dark:border-gray-600 peer-checked:bg-primary-600">
                                    </div>
                                    <span class="text-sm font-medium text-gray-900 ms-3 dark:text-gray-300">
                                        @lang('visitor-management::visit-appointments.label.with-minors')
                                    </span>
                                </label>
                                <x-input-error for="withMinors" />
                            </div>
                            <div class="flex items-center"
                                :class="{ 'cursor-not-allowed opacity-25': internalVisit }"
                                x-show="visitReasonId == null || (visitReasons?.find((element) => element.id == visitReasonId)?.visit_type.dependencies?.require_escort ?? {{ \BplanBase\Globals\Enums\RequireStatus::Optional }}) > {{ \BplanBase\Globals\Enums\RequireStatus::NotUsed }}">
                                <label class="inline-flex items-center cursor-pointer">
                                    <input id="requireEscort"
                                        :disabled="!userHasHostRole || internalVisit || editSucceeded"
                                        wire:model.live="requireEscort" type="checkbox" value=""
                                        class="sr-only peer">
                                    <div
                                        class="relative w-11 h-6 bg-gray-200 peer-focus:outline-none peer-focus:ring-4 peer-focus:ring-primary-300 dark:peer-focus:ring-primary-800 rounded-full peer dark:bg-gray-700 peer-checked:after:translate-x-full rtl:peer-checked:after:-translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:start-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all dark:border-gray-600 peer-checked:bg-primary-600">
                                    </div>
                                    <span class="text-sm font-medium text-gray-900 ms-3 dark:text-gray-300">
                                        @lang('visitor-management::visit-appointments.label.require-escort')
                                    </span>
                                </label>
                                <x-input-error for="requireEscort" />
                            </div>
                        </div>
                        {{-- OVERVIEW --}}
                        <div x-show="appointmentStep == @js(\BplanModules\VisitorManagement\Enums\AppointmentSteps::Overview->value)"
                            class="grid gap-4 my-4 sm:grid-cols-2 md:grid-cols-3">
                            <dl class="grid grid-cols-2 md:col-span-2">
                                <div>
                                    <dt class="mb-2 font-semibold leading-none text-gray-900 dark:text-white">
                                        @lang('visitor-management::visit-appointments.label.employee')
                                    </dt>
                                    <dd class="mb-4 font-light text-gray-500 sm:mb-5 dark:text-gray-400">
                                        @forelse ($comboBoxData['mainEmployees'] ?? [] as $index => $comboBoxMainEmployees)
                                            @if (isset($comboBoxMainEmployees['isSelected']) && $comboBoxMainEmployees['isSelected'])
                                                <span
                                                    class="bg-gray-100 text-gray-800 text-xs font-medium inline-flex items-center px-2.5 py-0.5 rounded me-2 dark:bg-gray-700 dark:text-gray-400 border border-gray-500 ">
                                                    {{-- USER ICON --}}
                                                    <svg class="w-2.5 h-2.5 me-1.5" xmlns="http://www.w3.org/2000/svg"
                                                        viewBox="0 0 24 24" fill="currentColor">
                                                        <path fill-rule="evenodd"
                                                            d="M7.5 6a4.5 4.5 0 1 1 9 0 4.5 4.5 0 0 1-9 0ZM3.751 20.105a8.25 8.25 0 0 1 16.498 0 .75.75 0 0 1-.437.695A18.683 18.683 0 0 1 12 22.5c-2.786 0-5.433-.608-7.812-1.7a.75.75 0 0 1-.437-.695Z"
                                                            clip-rule="evenodd" />
                                                    </svg>
                                                    {{ $comboBoxMainEmployees['label'] ?? '-' }}
                                                </span>
                                            @endif
                                        @empty
                                            -
                                        @endforelse

                                        @if (
                                            (count(array_filter($comboBoxData['mainEmployees'], function (array $visitor) {
                                                    return isset($visitor['isSelected']) && $visitor['isSelected'] == true;
                                                })) ??
                                                0) ==
                                                0)
                                            -
                                        @endif
                                    </dd>
                                </div>
                                <div>
                                    <dt class="mb-2 font-semibold leading-none text-gray-900 dark:text-white">
                                        @lang('visitor-management::visit-appointments.label.main-visitor')
                                    </dt>
                                    <dd class="mb-4 font-light text-gray-500 sm:mb-5 dark:text-gray-400">
                                        @forelse ($comboBoxData['mainVisitors'] ?? [] as $index => $comboBoxMainEmployees)
                                            @if (isset($comboBoxMainEmployees['isSelected']) && $comboBoxMainEmployees['isSelected'])
                                                <span
                                                    class="bg-gray-100 text-gray-800 text-xs font-medium inline-flex items-center px-2.5 py-0.5 rounded me-2 dark:bg-gray-700 dark:text-gray-400 border border-gray-500 ">
                                                    {{-- USER ICON --}}
                                                    <svg class="w-2.5 h-2.5 me-1.5" xmlns="http://www.w3.org/2000/svg"
                                                        viewBox="0 0 24 24" fill="currentColor">
                                                        <path fill-rule="evenodd"
                                                            d="M7.5 6a4.5 4.5 0 1 1 9 0 4.5 4.5 0 0 1-9 0ZM3.751 20.105a8.25 8.25 0 0 1 16.498 0 .75.75 0 0 1-.437.695A18.683 18.683 0 0 1 12 22.5c-2.786 0-5.433-.608-7.812-1.7a.75.75 0 0 1-.437-.695Z"
                                                            clip-rule="evenodd" />
                                                    </svg>
                                                    {{ $comboBoxMainEmployees['label'] ?? '-' }}
                                                </span>
                                            @endif
                                        @empty
                                            -
                                        @endforelse

                                        @if (
                                            (count(array_filter($comboBoxData['mainVisitors'], function (array $visitor) {
                                                    return isset($visitor['isSelected']) && $visitor['isSelected'] == true;
                                                })) ??
                                                0) ==
                                                0)
                                            -
                                        @endif
                                    </dd>
                                </div>
                                <div>
                                    <dt class="mb-2 font-semibold leading-none text-gray-900 dark:text-white">
                                        @lang('visitor-management::visit-appointments.label.visitors')
                                    </dt>
                                    <dd class="mb-4 font-light text-gray-500 sm:mb-5 dark:text-gray-400">
                                        @foreach ($comboBoxData['visitors'] ?? [] as $index => $comboBoxVisitor)
                                            @if (isset($comboBoxVisitor['isSelected']) && $comboBoxVisitor['isSelected'])
                                                <span
                                                    class="bg-gray-100 text-gray-800 text-xs font-medium inline-flex items-center px-2.5 py-0.5 rounded me-2 dark:bg-gray-700 dark:text-gray-400 border border-gray-500 ">
                                                    {{-- USER ICON --}}
                                                    <svg class="w-2.5 h-2.5 me-1.5" xmlns="http://www.w3.org/2000/svg"
                                                        viewBox="0 0 24 24" fill="currentColor">
                                                        <path fill-rule="evenodd"
                                                            d="M7.5 6a4.5 4.5 0 1 1 9 0 4.5 4.5 0 0 1-9 0ZM3.751 20.105a8.25 8.25 0 0 1 16.498 0 .75.75 0 0 1-.437.695A18.683 18.683 0 0 1 12 22.5c-2.786 0-5.433-.608-7.812-1.7a.75.75 0 0 1-.437-.695Z"
                                                            clip-rule="evenodd" />
                                                    </svg>
                                                    {{ $comboBoxVisitor['label'] ?? '-' }}
                                                </span>
                                            @endif
                                        @endforeach

                                        @if (
                                            (count(array_filter($comboBoxData['visitors'], function (array $visitor) {
                                                    return isset($visitor['isSelected']) && $visitor['isSelected'] == true;
                                                })) ??
                                                0) ==
                                                0)
                                            -
                                        @endif

                                    </dd>
                                </div>
                                <div>
                                    <dt class="mb-2 font-semibold leading-none text-gray-900 dark:text-white">
                                        @lang('visitor-management::visit-appointments.label.drive-on-area')
                                    </dt>
                                    <dd class="mb-4 font-light text-gray-500 sm:mb-5 dark:text-gray-400">
                                        @if ($driveOnAreaPermitted)
                                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"
                                                fill="currentColor" class="text-green-500 size-6">
                                                <path fill-rule="evenodd"
                                                    d="M2.25 12c0-5.385 4.365-9.75 9.75-9.75s9.75 4.365 9.75 9.75-4.365 9.75-9.75 9.75S2.25 17.385 2.25 12Zm13.36-1.814a.75.75 0 1 0-1.22-.872l-3.236 4.53L9.53 12.22a.75.75 0 0 0-1.06 1.06l2.25 2.25a.75.75 0 0 0 1.14-.094l3.75-5.25Z"
                                                    clip-rule="evenodd" />
                                            </svg>
                                        @else
                                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"
                                                fill="currentColor" class="text-red-500 size-6">
                                                <path fill-rule="evenodd"
                                                    d="M12 2.25c-5.385 0-9.75 4.365-9.75 9.75s4.365 9.75 9.75 9.75 9.75-4.365 9.75-9.75S17.385 2.25 12 2.25Zm-1.72 6.97a.75.75 0 1 0-1.06 1.06L10.94 12l-1.72 1.72a.75.75 0 1 0 1.06 1.06L12 13.06l1.72 1.72a.75.75 0 1 0 1.06-1.06L13.06 12l1.72-1.72a.75.75 0 1 0-1.06-1.06L12 10.94l-1.72-1.72Z"
                                                    clip-rule="evenodd" />
                                            </svg>
                                        @endif
                                    </dd>
                                </div>
                                <div
                                    x-show="visitReasonId == null || (visitReasons?.find((element) => element.id == visitReasonId)?.visit_type.dependencies?.license_plate_formatted ?? {{ \BplanBase\Globals\Enums\RequireStatus::Optional }}) > {{ \BplanBase\Globals\Enums\RequireStatus::NotUsed }} || driveOnAreaPermitted == true">
                                    <dt class="mb-2 font-semibold leading-none text-gray-900 dark:text-white">
                                        @lang('visitor-management::visit-appointments.label.license_plate')
                                    </dt>
                                    <dd class="mb-4 font-light text-gray-500 sm:mb-5 dark:text-gray-400">
                                        {{ $licensePlateFormatted ?? '-' }}
                                    </dd>
                                </div>
                                <div>
                                    <dt class="mb-2 font-semibold leading-none text-gray-900 dark:text-white">
                                        @lang('visitor-management::visit-appointments.label.internal-visit')
                                    </dt>
                                    <dd class="mb-4 font-light text-gray-500 sm:mb-5 dark:text-gray-400">
                                        @if ($internalVisit)
                                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"
                                                fill="currentColor" class="text-green-500 size-6">
                                                <path fill-rule="evenodd"
                                                    d="M2.25 12c0-5.385 4.365-9.75 9.75-9.75s9.75 4.365 9.75 9.75-4.365 9.75-9.75 9.75S2.25 17.385 2.25 12Zm13.36-1.814a.75.75 0 1 0-1.22-.872l-3.236 4.53L9.53 12.22a.75.75 0 0 0-1.06 1.06l2.25 2.25a.75.75 0 0 0 1.14-.094l3.75-5.25Z"
                                                    clip-rule="evenodd" />
                                            </svg>
                                        @else
                                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"
                                                fill="currentColor" class="text-red-500 size-6">
                                                <path fill-rule="evenodd"
                                                    d="M12 2.25c-5.385 0-9.75 4.365-9.75 9.75s4.365 9.75 9.75 9.75 9.75-4.365 9.75-9.75S17.385 2.25 12 2.25Zm-1.72 6.97a.75.75 0 1 0-1.06 1.06L10.94 12l-1.72 1.72a.75.75 0 1 0 1.06 1.06L12 13.06l1.72 1.72a.75.75 0 1 0 1.06-1.06L13.06 12l1.72-1.72a.75.75 0 1 0-1.06-1.06L12 10.94l-1.72-1.72Z"
                                                    clip-rule="evenodd" />
                                            </svg>
                                        @endif
                                    </dd>
                                </div>
                                <div>
                                    <dt class="mb-2 font-semibold leading-none text-gray-900 dark:text-white">
                                        @lang('visitor-management::visit-appointments.label.require-escort')
                                    </dt>
                                    <dd class="mb-4 font-light text-gray-500 sm:mb-5 dark:text-gray-400">
                                        @if ($requireEscort)
                                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"
                                                fill="currentColor" class="text-green-500 size-6">
                                                <path fill-rule="evenodd"
                                                    d="M2.25 12c0-5.385 4.365-9.75 9.75-9.75s9.75 4.365 9.75 9.75-4.365 9.75-9.75 9.75S2.25 17.385 2.25 12Zm13.36-1.814a.75.75 0 1 0-1.22-.872l-3.236 4.53L9.53 12.22a.75.75 0 0 0-1.06 1.06l2.25 2.25a.75.75 0 0 0 1.14-.094l3.75-5.25Z"
                                                    clip-rule="evenodd" />
                                            </svg>
                                        @else
                                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"
                                                fill="currentColor" class="text-red-500 size-6">
                                                <path fill-rule="evenodd"
                                                    d="M12 2.25c-5.385 0-9.75 4.365-9.75 9.75s4.365 9.75 9.75 9.75 9.75-4.365 9.75-9.75S17.385 2.25 12 2.25Zm-1.72 6.97a.75.75 0 1 0-1.06 1.06L10.94 12l-1.72 1.72a.75.75 0 1 0 1.06 1.06L12 13.06l1.72 1.72a.75.75 0 1 0 1.06-1.06L13.06 12l1.72-1.72a.75.75 0 1 0-1.06-1.06L12 10.94l-1.72-1.72Z"
                                                    clip-rule="evenodd" />
                                            </svg>
                                        @endif
                                    </dd>
                                </div>
                                <div>
                                    <dt class="mb-2 font-semibold leading-none text-gray-900 dark:text-white">
                                        @lang('visitor-management::visit-appointments.label.with-minors')
                                    </dt>
                                    <dd class="mb-4 font-light text-gray-500 sm:mb-5 dark:text-gray-400">
                                        @if ($withMinors)
                                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"
                                                fill="currentColor" class="text-green-500 size-6">
                                                <path fill-rule="evenodd"
                                                    d="M2.25 12c0-5.385 4.365-9.75 9.75-9.75s9.75 4.365 9.75 9.75-4.365 9.75-9.75 9.75S2.25 17.385 2.25 12Zm13.36-1.814a.75.75 0 1 0-1.22-.872l-3.236 4.53L9.53 12.22a.75.75 0 0 0-1.06 1.06l2.25 2.25a.75.75 0 0 0 1.14-.094l3.75-5.25Z"
                                                    clip-rule="evenodd" />
                                            </svg>
                                        @else
                                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"
                                                fill="currentColor" class="text-red-500 size-6">
                                                <path fill-rule="evenodd"
                                                    d="M12 2.25c-5.385 0-9.75 4.365-9.75 9.75s4.365 9.75 9.75 9.75 9.75-4.365 9.75-9.75S17.385 2.25 12 2.25Zm-1.72 6.97a.75.75 0 1 0-1.06 1.06L10.94 12l-1.72 1.72a.75.75 0 1 0 1.06 1.06L12 13.06l1.72 1.72a.75.75 0 1 0 1.06-1.06L13.06 12l1.72-1.72a.75.75 0 1 0-1.06-1.06L12 10.94l-1.72-1.72Z"
                                                    clip-rule="evenodd" />
                                            </svg>
                                        @endif
                                    </dd>
                                </div>
                            </dl>
                            <dl class="flex flex-col p-4 space-y-2 rounded bg-gray-50 dark:bg-gray-500">
                                <div>
                                    <dt class="mb-2 font-semibold leading-none text-gray-900 dark:text-white">
                                        @lang('visitor-management::visit-appointments.label.subject')
                                    </dt>
                                    <dd class="mb-4 font-light text-gray-500 sm:mb-5 dark:text-gray-400">
                                        {{ $subject ?? '-' }}
                                    </dd>
                                </div>
                                <div>
                                    <dt class="mb-2 font-semibold leading-none text-gray-900 dark:text-white">
                                        @lang('visitor-management::visit-appointments.label.start-date')
                                    </dt>
                                    <dd class="mb-4 font-light text-gray-500 sm:mb-5 dark:text-gray-400">
                                        {{ \Carbon\Carbon::parse($appointmentBegin)->format(__('globals::global.datetime.format')) }}
                                    </dd>
                                </div>
                                <div>
                                    <dt class="mb-2 font-semibold leading-none text-gray-900 dark:text-white">
                                        @lang('visitor-management::visit-appointments.label.end-date')
                                    </dt>
                                    <dd class="mb-4 font-light text-gray-500 sm:mb-5 dark:text-gray-400">
                                        {{ \Carbon\Carbon::parse($appointmentEnd)->format(__('globals::global.datetime.format')) }}
                                    </dd>
                                </div>
                                <div>
                                    <dt class="mb-2 font-semibold leading-none text-gray-900 dark:text-white">
                                        @lang('visitor-management::visit-appointments.label.visit-reason')
                                    </dt>
                                    <dd class="mb-4 font-light text-gray-500 sm:mb-5 dark:text-gray-400">
                                        {{ $visitReasonLabels->{app()->getLocale()} ?? 'N/A' }}
                                    </dd>
                                </div>
                            </dl>
                        </div>
                    </div>
                </div>
                <div x-show="tab == 'equipment'">
                    @foreach ($equipmentItems as $equipmentItem)
                        <div>
                            {{-- <label for="counter-input" class="block mb-1 text-sm font-medium text-gray-900 dark:text-white">
                                    {{ $equipmentItem->labels->{app()->getLocale()} ?? 'N/A' }}
                                </label> --}}
                            {{-- <div class="relative flex items-center"> --}}
                            <div class="max-w-sm mx-auto">
                                <label for="appointmentEquipmentItems.{{ $equipmentItem->id }}.amount"
                                    class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">{{ $equipmentItem->labels->{app()->getLocale()} ?? 'N/A' }}</label>
                                <input type="number" id="appointmentEquipmentItems.{{ $equipmentItem->id }}.amount"
                                    value="{{ $appointmentEquipmentItems[$equipmentItem->id]['amount'] ?? 0 }}"
                                    wire:model="appointmentEquipmentItems.{{ $equipmentItem->id }}.amount"
                                    class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500"
                                    placeholder="90210" required />
                            </div>
                            {{-- <button type="button" id="decrement-button" data-input-counter-decrement="counter-input-{{$equipmentItem->id}}" class="inline-flex items-center justify-center flex-shrink-0 w-5 h-5 bg-gray-100 border border-gray-300 rounded-md dark:bg-gray-700 dark:hover:bg-gray-600 dark:border-gray-600 hover:bg-gray-200 focus:ring-gray-100 dark:focus:ring-gray-700 focus:ring-2 focus:outline-none">
                                        <svg class="w-2.5 h-2.5 text-gray-900 dark:text-white" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 18 2">
                                            <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M1 1h16"/>
                                        </svg>
                                    </button> --}}
                            {{-- <input value="{{ $appointmentEquipmentItems[$equipmentItem->id]['amount'] ?? 0}}" wire:model.live="appointmentEquipmentItems.{{$equipmentItem->id}}.amount" type="text" id="counter-input-{{$equipmentItem->id}}" data-input-counter class="flex-shrink-0 text-sm font-normal text-center text-gray-900 bg-transparent border-0 dark:text-white focus:outline-none focus:ring-0 max-w-16" placeholder="" required /> --}}
                            {{-- <button type="button" id="increment-button" data-input-counter-increment="counter-input-{{$equipmentItem->id}}" class="inline-flex items-center justify-center flex-shrink-0 w-5 h-5 bg-gray-100 border border-gray-300 rounded-md dark:bg-gray-700 dark:hover:bg-gray-600 dark:border-gray-600 hover:bg-gray-200 focus:ring-gray-100 dark:focus:ring-gray-700 focus:ring-2 focus:outline-none">
                                        <svg class="w-2.5 h-2.5 text-gray-900 dark:text-white" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 18 18">
                                            <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 1v16M1 9h16"/>
                                        </svg>
                                    </button> --}}
                            {{-- </div> --}}
                        </div>
                    @endforeach
                </div>

                <div x-cloak x-show="tab == 'main' && !editSucceeded" class="flex justify-between">
                    <div>
                        <button
                            x-show="userHasHostRole && tab == 'main' && appointmentStep > @js(\BplanModules\VisitorManagement\Enums\AppointmentSteps::General->value)"
                            wire:click="previousStep" type="button"
                            class="py-2.5 px-5 mb-2 text-sm font-medium text-gray-900 focus:outline-none bg-white rounded-lg border border-gray-200 hover:bg-gray-100 hover:text-primary-700 focus:z-10 focus:ring-4 focus:ring-gray-100 dark:focus:ring-gray-700 dark:bg-gray-800 dark:text-gray-400 dark:border-gray-600 dark:hover:text-white dark:hover:bg-gray-700">
                            @lang('globals::global.pagination.previous')
                        </button>
                    </div>
                    <div class="flex items-center">
                        <button x-show="userHasHostRole && !isSaving && tab == 'main' && !showRemove"
                            class="text-red-600 dark:text-red-500 hover:underline" x-on:click="showRemove = true">
                            @lang('globals::global.action.delete')
                        </button>
                        <div x-cloak x-show="showRemove" wire:loading.remove wire:target="deleteAppointment">
                            <p class="text-xs text-gray-900 dark:text-white">
                                @lang('globals::global.confirm.delete')</p>
                            <div>
                                <button x-on:click="showRemove = false"
                                    class="font-medium text-fkbgreen-700 dark:text-fkbgreen-600 hover:underline">
                                    @lang('globals::global.action.cancel')
                                </button>
                                <button x-on:click="showRemove = false" wire:click="deleteAppointment"
                                    class="font-medium text-red-600 dark:text-red-500 hover:underline">
                                    @lang('globals::global.action.delete')
                                </button>
                            </div>
                        </div>
                    </div>
                    <div x-show="userHasHostRole && appointmentStep < @js(\BplanModules\VisitorManagement\Enums\AppointmentSteps::Overview->value)">
                        <button wire:click="nextStep" type="button"
                            class="py-2.5 px-5 me-2 mb-2 text-sm font-medium text-gray-900 focus:outline-none bg-white rounded-lg border border-gray-200 hover:bg-gray-100 hover:text-primary-700 focus:z-10 focus:ring-4 focus:ring-gray-100 dark:focus:ring-gray-700 dark:bg-gray-800 dark:text-gray-400 dark:border-gray-600 dark:hover:text-white dark:hover:bg-gray-700">
                            @lang('globals::global.pagination.next')
                        </button>
                    </div>
                    <button
                        x-show="userHasHostRole && !isSaving && !editSucceeded && appointmentStep == @js(\BplanModules\VisitorManagement\Enums\AppointmentSteps::Overview->value)"
                        wire:loading.remove x-on:click="$dispatch('show-notify-visitors-modal')"
                        wire:target="editAppointment, deleteAppointment" type="button"
                        class="text-white inline-flex items-center bg-primary-700 hover:bg-primary-800 focus:ring-4 focus:outline-none focus:ring-primary-300 font-medium rounded-lg text-sm px-5 py-2.5 text-center dark:bg-primary-600 dark:hover:bg-primary-700 dark:focus:ring-primary-800">
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor"
                            class="w-5 h-5 mr-1 -ml-1">
                            <path fill-rule="evenodd"
                                d="M19.916 4.626a.75.75 0 0 1 .208 1.04l-9 13.5a.75.75 0 0 1-1.154.114l-6-6a.75.75 0 0 1 1.06-1.06l5.353 5.353 8.493-12.74a.75.75 0 0 1 1.04-.207Z"
                                clip-rule="evenodd" />
                        </svg>
                        @lang('globals::global.action.save')
                    </button>
                    <x-global-components::global.loading-spinner x-show="isSaving" />
                </div>
                <div x-show="tab == 'equipment'" class="flex items-center justify-center mt-4">
                    <button x-show="userHasHostRole" wire:loading.remove
                        wire:target="saveEquipmentItems, editAppointment, deleteAppointment"
                        wire:click="saveEquipmentItems" type="button"
                        class="text-white inline-flex items-center bg-primary-700 hover:bg-primary-800 focus:ring-4 focus:outline-none focus:ring-primary-300 font-medium rounded-lg text-sm px-5 py-2.5 text-center dark:bg-primary-600 dark:hover:bg-primary-700 dark:focus:ring-primary-800">
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor"
                            class="w-5 h-5 mr-1 -ml-1">
                            <path fill-rule="evenodd"
                                d="M19.916 4.626a.75.75 0 0 1 .208 1.04l-9 13.5a.75.75 0 0 1-1.154.114l-6-6a.75.75 0 0 1 1.06-1.06l5.353 5.353 8.493-12.74a.75.75 0 0 1 1.04-.207Z"
                                clip-rule="evenodd" />
                        </svg>
                        @lang('globals::global.action.save')
                    </button>
                    <x-global-components::global.loading-spinner wire:loading wire:target="saveEquipmentItems" />
                </div>
            </div>
        </div>

        <livewire:visitor-management::visit-appointments.modals.notify-visitors />

        <script>
            document.addEventListener('alpine:init', () => {
                Alpine.data('editAppointment', () => ({
                    show: false,
                    tab: 'main',
                    appointmentStep: @entangle('appointmentStep'),
                    editSucceeded: false,
                    showRemove: false,
                    visitReasons: @js($visitReasons),
                    visitReasonId: @entangle('visitReasonId'),
                    isSpontaneousVisit: @entangle('isSpontaneousVisit'),
                    internalVisit: @entangle('internalVisit'),
                    requireEscort: @entangle('requireEscort'),
                    driveOnAreaPermitted: @entangle('driveOnAreaPermitted'),
                    isBulkVisit: @entangle('isBulkVisit'),
                    isSaving: false,
                    userHasHostRole: @js(auth()->user()->hasRole('Host')),
                    init() {
                        let dateOptions = {
                            locale: @js(app()->getLocale()),
                            dateFormat: "Y-m-d",
                            altInput: true,
                            altFormat: @js(__('globals::global.date.format')),
                        };

                        let timeOptions = {
                            locale: @js(app()->getLocale()),
                            altInput: true,
                            altFormat: "H:i",
                            enableTime: true,
                            noCalendar: true,
                            dateFormat: "H:i",
                            time_24hr: true
                        };

                        flatpickr("#editStartDate", dateOptions);
                        flatpickr("#editEndDate", dateOptions);

                        flatpickr("#editStartTime", timeOptions);
                        flatpickr("#editEndTime", timeOptions);
                    },
                    // CREATE
                    edited(event) {
                        this.editSucceeded = true;
                        this.hideModal();
                    },
                    deleted(event) {
                        this.editSucceeded = true;
                        this.hideModal();
                    },
                    resetModal() {
                        this.editSucceeded = false;
                        this.showRemove = false;
                        this.appointmentStep = this.userHasHostRole ? @js(\BplanModules\VisitorManagement\Enums\AppointmentSteps::General->value) :
                            @js(\BplanModules\VisitorManagement\Enums\AppointmentSteps::Overview->value);
                        this.isSaving = false;

                        @this.resetModal()
                    },
                    hideModal() {
                        this.show = false;
                        this.resetModal();
                    },
                    showModal(event) {
                        this.tab = 'main';
                        this.show = true;

                        let dateValidFrom = new Date(event.detail.appointment.valid_from);
                        let dateValidUntil = new Date(event.detail.appointment.valid_until);

                        document.getElementById('editStartDate')._flatpickr.setDate(dateValidFrom, true);
                        document.getElementById('editEndDate')._flatpickr.setDate(dateValidUntil, true);
                        document.getElementById('editStartTime')._flatpickr.setDate(dateValidFrom, true);
                        document.getElementById('editEndTime')._flatpickr.setDate(dateValidUntil, true);

                        setTimeout(() => {
                            document.getElementById('subject').focus();
                        }, 100);
                    },
                    paginationUpdated(event) {
                        this.appointmentStep = event.detail.step;
                    },
                    onSave() {
                        this.isSaving = true;
                        this.showRemove = false;
                    }
                }));
            });
        </script>

        <livewire:visitor-management::visit-appointments.modals.upload-visitors />
    </div>
