<?php
/**
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-modules/visitor-management
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */


use BplanModules\VisitorManagement\Http\Controllers\Api\Terminal\VisitAppointmentController;
use BplanModules\VisitorManagement\Http\Controllers\Api\Terminal\VisitContactController;
use BplanModules\VisitorManagement\Http\Controllers\Api\Terminal\VisitContactGroupController;
use BplanModules\VisitorManagement\Http\Controllers\Api\Terminal\VisitContactOptionController;
use BplanModules\VisitorManagement\Http\Controllers\Api\Terminal\VisitLanguageController;
use BplanModules\VisitorManagement\Http\Controllers\Api\Terminal\VisitOpeningHourController;
use BplanModules\VisitorManagement\Http\Procedures\LayouterProcedure;
use BplanModules\VisitorManagement\Http\Procedures\PhoneNumberVerificationProcedure;
use BplanModules\VisitorManagement\Http\Procedures\TerminalEventProcedure;
use Illuminate\Support\Facades\Route;
use LaravelJsonApi\Laravel\Facades\JsonApiRoute;
use LaravelJsonApi\Laravel\Routing\ResourceRegistrar;


JsonApiRoute::server('terminal')
    ->prefix('terminal')
    ->withoutMiddleware(\Illuminate\Routing\Middleware\SubstituteBindings::class)
    ->resources(function (ResourceRegistrar $Server) {

        /*
        **  Individuelle show-Route, die ein Appointment über die ID, die OrderNumber oder
        **  über das Token ermittelt. */
        Route::get('/visit-appointments/{various}', [VisitAppointmentController::class, 'show'])->name('appointment');

        $Server->resource('visit-appointments', VisitAppointmentController::class)->except('delete');

        /*
        **  Individuelle index-Route, die dafür sorgt, dass die Labels in allen Terminal-Sprachen verfügbar sind. */
        $Server->resource('visit-contact-groups', VisitContactGroupController::class)->only('index');

        /*
        **  Individuelle index-Route, die dafür sorgt, dass die Labels in allen Terminal-Sprachen verfügbar sind. */
        $Server->resource('visit-contact-options', VisitContactOptionController::class)->only('index');

        /*
        **  Individuelle index-Route, die dafür sorgt, dass die Labels in allen Terminal-Sprachen verfügbar sind. */
        $Server->resource('visit-languages', VisitLanguageController::class)->only('index');

        /*
        **  Individuelle index-Route, die eine Liste von Mitarbeitern über eine ContactGroup-ID
        **  ermittelt. */
        Route::get('/visit-contacts/{contactGroupId}', [VisitContactController::class, 'index'])->name('contacts');

        /*
        **  Individuelle get-Route, die die aktuellen Öffnungszeiten zu einem definierten VisitType liefert. */
        Route::get('/visit-opening-hours/by-visit-type/{various}', [VisitOpeningHourController::class, 'getCurrentOpeningHours'])->name('current-opening-hours');

        /*
        **  Individuelle get-Route, die die Öffnungszeiten eines bestimmten Wochentags zum angegebenen VisitType liefert. */
        Route::get('/visit-opening-hours/by-visit-type/{various}/{weekday}', [VisitOpeningHourController::class, 'getWeekDayOpeningHours'])->name('weekday-opening-hours');

    }
);

$routePrefix = config('project.layouter.route-prefix');

$prefix = null;

if ($routePrefix !== null) {
    $prefix = $routePrefix;
}
Route::prefix($prefix)
    ->group(function () {
        Route::rpc('/visit-layouter', [LayouterProcedure::class], '_')->name('layouter.rpc.endpoint');
        Route::rpc('/visit-phone-number-verification', [PhoneNumberVerificationProcedure::class], '_')->name('phone-number-verification.rpc.endpoint');
        Route::rpc('/visit-terminal-event', [TerminalEventProcedure::class], '_')->name('terminal-event.rpc.endpoint');
    }
);
