<?php
/**
 * Create Action Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-modules/visitor-management
 * @subpackage  Actions
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <http://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanModules\VisitorManagement\Actions\VisitAppointment;


use BplanModules\VisitorManagement\Enums\VisitTypeIdentifier;
use BplanModules\VisitorManagement\Models\VisitAppointment;
use BplanModules\VisitorManagement\Models\VisitReason;
use BplanModules\VisitorManagement\Repositories\VisitReasonRepository;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Collection;


/**
 * Anonymisiert Gruppenbesucher
 *
 * @version     1.0.0 / 2025-03-22
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class AnonymizeGroupVisitors
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * Anonymisiert die Group-Visitors zu den übergebenen Appointments
     *
     * @param       array|Collection $appointments
     *              Ein Array mit Appoinment-IDs oder eine Collection von Appointments.
     *
     * @return      int
     *
     * @version     1.0.0 / 2025-03-22
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function execute(array|Collection $appointments): int
    {
        $VisitReasons = VisitReasonRepository::getByVisitType(VisitTypeIdentifier::GroupVisit);

        $visitReaonIds = $VisitReasons->pluck('id')->toArray();

        if (is_array($appointments)) {
            if (empty($appointments)) {
                return 0;
            }
            $appointments = VisitAppointment::whereIn('id', $appointments)
                ->whereIn('visit_reason_id', $visitReaonIds)
                ->get();

        } else {
            if ($appointments->isEmpty()) {
                return 0;
            }
        }
        $count = 0;

        foreach ($appointments as $Appointment) {
            /*
            **  Schleifendurchlauf abbrechen, wenn es sich nicht um einen Gruppenbesuch handelt. */
            if (in_array($Appointment->visit_reason_id, $visitReaonIds) === false) {
                continue;
            }
            $visitors = collect($Appointment->visitors)->map(function ($visitor) use (& $count) {
                if (empty($visitor->anonymized)) {
                    $visitor->anonymized = 1;
                    $visitor->email = null;
                    $visitor->first_name = '*';
                    $visitor->last_name = '*';
                    $visitor->mobile_phone_number = '*';
                    $visitor->mobile_phone_number_country_code = '*';

                    $count++;
                }
                return $visitor;
            });
            $Appointment->visitors = $visitors;

            $Appointment->save();
        }
        return $count;

    } // execute()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class AnonymizeGroupVisitors {}
