<?php
/**
 * Action Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-modules/visitor-management
 * @subpackage  Actions
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <http://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanModules\VisitorManagement\Actions\VisitAppointment;


use BplanModules\VisitorManagement\Enums\ProcessStatus;
use BplanModules\VisitorManagement\Models\VisitAppointment;
use Carbon\Carbon;


/**
 * Führt einen CheckOut bei allen offenen Terminen durch
 *
 * Diese Action sollte nur einmalig, kurz nach Mitternacht, ausgeführt werden.
 * Außerdem sollte sie vor dem Prozess "FinishAppointments" gestartet werden.
 *
 * @version     1.0.0 / 2025-03-22
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class CheckOutOpen
{

/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * Führt einen CheckOut bei allen offenen Terminen durch
     *
     * @return      int Liefert die Anzahl der betroffenen Datensätze.
     *
     * @version     1.0.0 / 2025-03-22
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function execute(): int
    {
        $Now = Carbon::now();

        return VisitAppointment::where('process_status', '>=', ProcessStatus::CheckedIn->value)
            ->where('process_status', '<', ProcessStatus::CheckedOut->value)
            ->update([
                'checked_out_at' => $Now,
                'process_status' => ProcessStatus::CheckedOut->value,
            ]
        );
    } // execute()


} // class CheckOutOpen {}
