<?php
/**
 * Update Action Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @generated   2025-04-19 23:55:42
 * @package     bplan-modules/visitor-management
 * @subpackage  Actions
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanModules\VisitorManagement\Actions\VisitOpeningHourException;


use BplanModules\VisitorManagement\Models\VisitOpeningHourException;


/**
 * Update Action Class
 *
 * @version     1.1.0 / 2025-04-19
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class Update
{

/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @param       int|string|VisitOpeningHourException $visitOpeningHourException
     *
     * @param       array $attributes
     *
     * @return      VisitOpeningHourException
     *
     * @version     2.0.0 / 2025-04-19
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function execute(int|string|VisitOpeningHourException $visitOpeningHourException, array $attributes): VisitOpeningHourException
    {
        /*
        **  Datum und VisitType dürfen nie geändert werden. */
        unset($attributes['date']);
        unset($attributes['visit_type_id']);

        if ($visitOpeningHourException instanceof VisitOpeningHourException) {
            $Model = $visitOpeningHourException;
        } else {
            $Model = VisitOpeningHourException::findOrFail($visitOpeningHourException);
        }
        $Model->fill($attributes);

        $Model->save();

        return $Model;

    } // execute()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class Update {}
