<?php
/**
 * Create Action Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     Avient
 * @subpackage  Actions
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2024, 2025 bplan-solutions GmbH & Co. KG <http://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanModules\VisitorManagement\Actions\VisitVisitor;


use BplanModules\VisitorManagement\Models\VisitAppointment;
use BplanModules\VisitorManagement\Models\VisitVisitor;
use BplanModules\VisitorManagement\Repositories\VisitAppointmentRepository;
use BplanModules\VisitorManagement\Services\VisitAppointmentService;
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;


/**
 * Anonymisiert Besucher
 *
 * @version     1.0.0 / 2025-03-22
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class AnonymizeVisitors
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * Anonymisiert die Besucher mit dn übergebenen IDs
     *
     * @return      int
     *
     * @version     1.0.0 / 2025-03-22
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function execute(array $visitorIds): int
    {
        if (empty($visitorIds)) {
            return 0;
        }
        return VisitVisitor::where('anonymized', '=', false)
            ->whereIn('id', $visitorIds)
            ->update([
                'anonymized' => true,
                'email' => null,
                'first_name' => '*',
                'last_name' => '*',
                'mobile_phone_number' => '*',
                'mobile_phone_number_country_code' => '*',
            ]
        );
    } // execute()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class AnonymizeVisitors {}
