<?php
/**
 * Import Command Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-modules/visitor-management
 * @subpackage  Commands
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <http://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanModules\VisitorManagement\Console\Commands;


use BplanModules\VisitorManagement\Enums\ImportContext;
use BplanModules\VisitorManagement\Imports\EmployeesImport;
use Illuminate\Console\Command;


/**
 * Import Command Class
 *
 * @version     1.2.0 / 2024-09-13
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class ImportEmployees extends Command
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var     string $description
     */
    protected $description = 'Employee importer';


    /**
     * @var     string $signature
     */
    protected $signature = 'import:employees';


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @version     1.2.1 / 2024-09-24
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function handle()
    {
        $this->output->title('Starting import');

        $basePath = EmployeesImport::getStoragePath(ImportContext::Queue);

        $files = scandir($basePath);

        $EmployeesImport = new EmployeesImport(ImportContext::Queue);

        foreach ($files as $file) {
            if (!is_file($basePath.'/'.$file)) {
                continue;
            }
            if ($file[0] === '.' || $file[0] === '#' || substr($file, 0, 2) === '~$') {
                continue;
            }
            $EmployeesImport->setImportFileName($file);

            $this->output->info('Importing file "'.$file.'".');

            $EmployeesImport->withOutput($this->output)->importFile($basePath.'/'.$file);
        }
        $this->output->success('Import successful');

    } // handle()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class ImportEmployees extends Command {}
