<?php
/**
 * Helper Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-modules/visitor-management
 * @subpackage  Helpers
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanModules\VisitorManagement\Helpers;


use BplanModules\VisitorManagement\Enums\LanguageContext;
use BplanModules\VisitorManagement\Models\VisitLanguage;
use Illuminate\Database\Eloquent\Collection as EloquentCollection;


/**
 * Helper Class
 *
 * @version     1.0.0 / 2025-01-27
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class Collection
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * Ergänzt fehlende Labels in den Models der übergebenen Collection
     *
     * @param       EloquentCollection $Collection
     *
     * @param       LanguageContext $LanguageContext
     *
     * @return      EloquentCollection
     *
     * @version     1.0.0 / 2025-01-27
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public static function completeLabels(EloquentCollection $Collection, LanguageContext $LanguageContext = LanguageContext::Both): EloquentCollection
    {
        $LanguageCollection = Language::where('context', '&', $LanguageContext->value)
            ->get();

        $defaultLanguage = config('app.fallback_locale', 'en');

        foreach ($Collection as $Model) {
            /*
            **  Models abarbeiten und fehlende Label-Übersetzungen durch das Label der
            **  Standardsprache ergänzen. */
            foreach ($LanguageCollection as $Language) {
                /*
                **  Die Labels direkt $Models->labels->{$Language->code} zuzuweisen funktioniert
                **  nicht. Deshalb werden die Labels erst in ein Array und hinterher wieder in ein
                **  Objekt umgewandelt. */
                $labels = (array) $Model->labels;

                if (!isset($Model->labels->{$Language->code})) {
                    $labels[$Language->code] = $labels[$defaultLanguage];
                }
                $Model->labels = (object) $labels;
            }
        }
        return $Collection;

    } // completeLabels()


} // class Collection {}
