<?php
/**
 * JSON:API Controller Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-modules/visitor-management
 * @subpackage  ApiControllers
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanModules\VisitorManagement\Http\Controllers\Api\Terminal;


use BplanModules\VisitorManagement\Models\VisitOpeningHour;
use BplanModules\VisitorManagement\Models\VisitOpeningHourException;
use BplanModules\VisitorManagement\Repositories\VisitOpeningHourExceptionRepository;
use BplanModules\VisitorManagement\Repositories\VisitOpeningHourRepository;
use LaravelJsonApi\Core\Responses\DataResponse;


/**
 * JSON:API Controller Class
 *
 * @version     2.1.0 / 2025-03-27
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class OpeningHourController extends Controller
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * Liefert die aktuellen Öffnungszeiten
     *
     * Prüft ob die aktuelle Zeit innerhalb der gespeicherten Öffnungzeit liegt und
     * liefert das Ergebnis der Prüfung.
     *
     * @param       int|string $various
     *              Eine VisitType-ID oder ein VisitType-Identifier.
     *
     * @return      DataResponse<OpeningHour|OpeningHourException>
     *
     * @version     2.1.0 / 2025-03-27
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function getCurrentOpeningHours(int|string $various): DataResponse
    {
        /*
        **  Prüfen ob es eine Ausnahme für den aktuellen Tag gibt. */
        $Result = VisitOpeningHourExceptionRepository::getVisitTypeOpeningHourExceptionByDate($various, date: null);

        if ($Result !== null) {
            return DataResponse::make($Result);
        }
        /*
        **  Wenn es keine Ausnahme für das aktuelle Datum gibt, dann werden die Öffnungszeiten
        **  zum aktuellen Wochentag ermitteln. */
        $Result = VisitOpeningHourRepository::getVisitTypeOpeningHoursByWeekday($various, weekday: null, returnOrFail: false);

        return DataResponse::make($Result);

    } // getCurrentOpeningHours()


    /**
     * Liefert die Öffnungszeiten eines VisitTypes zu einem bestimmten Wochentag
     *
     * @param       int|string $various
     *              Eine VisitType-ID oder ein VisitType-Identifier.
     *
     * @param       int|string $weekday
     *              Die Nummer (0 = Sonntag, 1 = Montag, ...) oder der Name (Sunday, Monday, ...)
     *              eines Wochentags.
     *
     * @return      DataResponse<OpeningHour>
     *
     * @version     1.1.0 / 2025-03-27
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function getWeekDayOpeningHours(int|string $various, int|string $weekday): DataResponse
    {
        $Result = VisitOpeningHourRepository::getVisitTypeOpeningHoursByWeekday($various, weekday: $weekday, returnOrFail: false);

        return DataResponse::make($Result);

    } // getWeekDayOpeningHours()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class OpeningHourController extends Controller {}
