<?php
/**
 * Livewire Component
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @generated   2025-04-18 16:14:49
 * @package     bplan-modules/visitor-management
 * @subpackage  LivewireComponents
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanModules\VisitorManagement\Livewire\VisitAccessAuthorizations;


use BplanModules\VisitorManagement\Enums\VisitTypeIdentifier;
use BplanModules\VisitorManagement\Models\VisitAppointment;
use Carbon\Carbon;
use Livewire\Attributes\Url;
use Livewire\Component;
use Livewire\WithPagination;


/**
 * Livewire Component
 *
 * @version     1.0.0 / 2025-04-18
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 */
class Index extends Component
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    use WithPagination;


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     */
    #[Url('id')]
    public ?int $accessAuthorizationIdToOpen;


    /**
     *
     */
    #[Url(keep: false)]
    public $filterAppointments = [];


    /**
     *
     */
    public ?string $filterEndDate;


    /**
     *
     */
    public ?string $filterStartDate;


    /**
     *
     */
    protected $listeners = [
        'access-authorization-created' => 'render',
        'access-authorization-edited' => 'render',
        'access-authorization-deleted' => 'render',
    ];


    /**
     *
     */
    public string $search = '';


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @version     1.0.0 / 2025-04-18
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     */
    private function getAccessAuthorizations()
    {
        $accessAuthorizations = VisitAppointment::whereRelation('visitType', 'visit_types.identifier', VisitTypeIdentifier::AccessAuthorization);
        $search = $this->search;

        if(!empty($search)) {
            $accessAuthorizations->where('subject', 'like', "%$search%");
        }
        if (!empty($this->filterStartDate)) {
            $startDate = Carbon::parse($this->filterStartDate)->startOfDay();
            $accessAuthorizations->where('valid_from', '>=', $startDate);
        }
        if (!empty($this->filterEndDate)) {
            $endDate = Carbon::parse($this->filterEndDate)->endOfDay();
            $accessAuthorizations->where('valid_until', '<=', $endDate);
        }
        return $accessAuthorizations->orderBy('valid_from', 'desc')->paginate(12);

    } // getAccessAuthorizations()


    /**
     *
     * @version     1.0.0 / 2025-04-18
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     */
    public function init()
    {
        if(isset($this->accessAuthorizationIdToOpen))
        {
            $accessAuthorizationToOpen = VisitAppointment::find($this->accessAuthorizationIdToOpen);
            $this->dispatch('show-edit-access-authorization-modal', accessAuthorization: $accessAuthorizationToOpen);
        }
    } // init()


    /**
     *
     * @version     1.0.0 / 2025-04-18
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     */
    public function render()
    {
        $this->dispatch('init-tippyjs');
        return view('visitor-management::livewire.visit-access-authorizations.index', [
            'accessAuthorizations' => $this->getAccessAuthorizations(),
        ]);
    } // render()


    /**
     *
     * @version     1.0.0 / 2025-04-18
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     */
    public function updated($name, $value)
    {
        switch ($name) {
            case 'filterStartDate':
            case 'filterEndDate':
            case 'search':
                $this->resetPage();
                break;

            default:
                # code...
                break;
        }
    } // updated()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class Index extends Component {}
