<?php
/**
 * Livewire Component
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @generated   2025-04-13 18:30:43
 * @package     bplan-modules/visitor-management
 * @subpackage  LivewireComponents
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanModules\VisitorManagement\Livewire\VisitContactOptions\Modals;


use BplanBase\Globals\Enums\LogLevel;
use BplanBase\Globals\Services\LogService;
use BplanModules\VisitorManagement\Models\VisitContactOption;
use BplanModules\VisitorManagement\Services\VisitContactOptionService;
use Laravel\Jetstream\InteractsWithBanner;
use Livewire\Attributes\On;
use Livewire\Attributes\Validate;
use Livewire\Component;


/**
 * Livewire Component
 *
 * @version     1.0.0 / 2025-04-13
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class Edit extends Component
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    use InteractsWithBanner;


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @var string|null
     */
    public ?string $context;


    /**
     *
     * @var array|null
     */
    #[Validate('required')]
    public ?array $labelsJson;


    /**
     *
     * @var string
     */
    public string $phonenumberDialCode = "";


    /**
     *
     * @var string|null
     */
    #[Validate('phone:INTERNATIONAL')]
    public ?string $phonenumber;


    /**
     *
     * @var VisitContactOption|null
     */
    public ?VisitContactOption $contactOption;


    /**
     *
     * @var LogService
     */
    protected LogService $logService;


    /**
     *
     * @var VisitContactOptionService
     */
    protected VisitContactOptionService $contactOptionService;


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @param       LogService $logService
     *
     * @param       VisitContactOptionService $Service
     *
     * @version     1.0.0 / 2025-04-13
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function boot(LogService $logService, VisitContactOptionService $contactOptionService)
    {
        $this->logService = $logService;
        $this->contactOptionService = $contactOptionService;

    } // boot()


    /**
     *
     * @version     1.0.0 / 2025-04-13
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function deleteContactOption()
    {
        $this->validate();

        try {
            $this->contactOptionService->delete($this->contactOption);

            $this->logService->log(LogLevel::Info, "Contact option #{$this->contactOption->id}, in context {$this->context} deleted by " . auth()->user()->name . ' (' . auth()->user()->email . ')');

            $this->dispatch('init-tippyjs');
            $this->dispatch('contact-option-deleted');
            $this->banner(trans('visitor-management::visit-contact-options.deleted_successfully'));

        } catch (\Throwable $th) {
            $this->logService->log(LogLevel::Error, 'ContactOptions/Modals/editNumber error deleteContactOption: ' . $th->getMessage() . ', file:' . $th->getFile() . ', line:' .  $th->getLine());
            $this->dangerBanner('Error when deleting contact option. Check the logs for more information.');
        }
    } // deleteContactOption()


    /**
     *
     * @version     1.0.0 / 2025-04-13
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function editContactOption()
    {
        $this->validate();

        $this->phonenumberDialCode = "+{$this->phonenumberDialCode}";
        $this->phonenumber = str_replace($this->phonenumberDialCode, '', $this->phonenumber);

        try {
            $this->contactOptionService->update($this->contactOption, [
                'labels' => $this->labelsJson,
                'value' => $this->phonenumber,
                'value_prefix' => $this->phonenumberDialCode,
            ]);

            $this->logService->log(LogLevel::Info, "Contact option {$this->phonenumber}, in context {$this->context} updated by " . auth()->user()->name . ' (' . auth()->user()->email . ')');

            $this->dispatch('init-tippyjs');
            $this->dispatch('contact-option-edited');
            $this->banner(trans('visitor-management::visit-contact-options.updated_successfully'));

        } catch (\Throwable $th) {
            $this->logService->log(LogLevel::Error, 'ContactOptions/Modals/editNumber error editContactOption: ' . $th->getMessage() . ', file:' . $th->getFile() . ', line:' .  $th->getLine());
            $this->dangerBanner('Error when editing contact option. Check the logs for more information.');
        }
    } // editContactOption()


    /**
     *
     * @version     1.0.0 / 2025-04-13
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    #[On('show-edit-contact-option-modal')]
    public function initModal(VisitContactOption $contactOption)
    {
        $this->contactOption = $contactOption;

        $this->labelsJson = (array) $contactOption->labels;
        $this->phonenumber = $contactOption->value;
        $this->context = $contactOption->context;

    } // initModal()


    /**
     *
     * @version     1.0.0 / 2025-04-13
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function mount()
    {
        //
    } // mount()


    /**
     *
     * @version     1.0.0 / 2025-04-13
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    #[On('multi-language-json-created')]
    public function onMultiLanguageJsonCreated(?array $json, string $target)
    {
        if ($target == 'edit') {
            $this->labelsJson = $json;
        }
    } // onMultiLanguageJsonCreated()


    /**
     *
     * @version     1.0.0 / 2025-04-13
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function render()
    {
        return view('visitor-management::livewire.visit-contact-options.modals.edit');

    } // render()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class Edit extends Component {}
