<?php
/**
 * Livewire Component
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @generated   2025-04-13 18:30:42
 * @package     bplan-modules/visitor-management
 * @subpackage  LivewireComponents
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanModules\VisitorManagement\Livewire\VisitLocations\Modals;


use BplanBase\Globals\Enums\LogLevel;
use BplanBase\Globals\Services\LogService;
use BplanModules\VisitorManagement\Models\VisitLocation;
use BplanModules\VisitorManagement\Models\VisitLocationType;
use BplanModules\VisitorManagement\Repositories\VisitLocationRepository;
use BplanModules\VisitorManagement\Repositories\VisitLocationTypeRepository;
use BplanModules\VisitorManagement\Services\VisitLocationService;
use Illuminate\Database\Eloquent\Collection;
use Laravel\Jetstream\InteractsWithBanner;
use Livewire\Attributes\On;
use Livewire\Attributes\Validate;
use Livewire\Component;


/**
 * Livewire Component
 *
 * @version     1.0.0 / 2025-04-13
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class Add extends Component
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    use InteractsWithBanner;


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @var array|null
     */
    #[Validate('required')]
    public ?array $labelsJson;


    /**
     *
     * @var string|null
     */
    #[Validate('nullable|numeric|exists:locations,id')]
    public ?string $master_location_id = null;


    /**
     *
     * @var string|null
     */
    #[Validate('nullable|numeric|exists:visit_location_types,id')]
    public ?string $location_type_id = null;


    /**
     *
     * @var string|null
     */
    // #[Validate('required')]
    public ?string $city = null;


    /**
     *
     * @var string|null
     */
    // #[Validate('required')]
    public ?string $postcode = null;


    /**
     *
     * @var string|null
     */
    // #[Validate('required')]
    public ?string $street = null;


    /**
     *
     * @var string|null
     */
    // #[Validate('required')]
    public ?string $housenumber = null;


    /**
     *
     * @var string|null
     */
    // #[Validate('required')]
    public ?string $email = null;


    /**
     *
     * @var string|null
     */
    // #[Validate('required')]
    public ?string $phonenumber = null;


    /**
     *
     * @var boolean
     */
    // #[Validate('required')]
    public bool $active = true;


    /**
     *
     * @var Collection|null
     */
    public ?Collection $locations;


    /**
     *
     * @var Collection|null
     */
    public ?Collection $locationTypes;


    /**
     *
     * @var LogService
     */
    protected LogService $logService;


    /**
     *
     * @var VisitLocationService
     */
    protected VisitLocationService $locationService;


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @version     1.0.0 / 2025-04-13
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function boot(LogService $logService, VisitLocationService $locationService)
    {
        $this->logService = $logService;
        $this->locationService = $locationService;

        $this->locations = VisitLocationRepository::getAll();
        $this->locationTypes = VisitLocationTypeRepository::getAll();

    } // boot()


    /**
     *
     * @version     1.0.0 / 2025-04-13
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function createLocation()
    {
        $this->validate();

        try {
            $this->locationService->create([
                'labels' => $this->labelsJson,
                'master_id' => $this->master_location_id != 0 ? $this->master_location_id : null ,
                'location_type_id' => $this->location_type_id != 0 ? $this->location_type_id : null ,
                'city' => $this->city,
                'zip_code' => $this->postcode,
                'street' => $this->street,
                'house_number' => $this->housenumber,
                'email' => $this->email,
                'phone_number' => $this->phonenumber,
                'active' => $this->active,
            ]);

            $this->logService->log(LogLevel::Info, "Location {$this->labelsJson['en']} added by " . auth()->user()->name . ' (' . auth()->user()->email . ')');

            $this->dispatch('init-tippyjs');
            $this->dispatch('location-created');
        } catch (\Throwable $th) {
            $this->logService->log(LogLevel::Error, 'Locations/Modals/CreateLocation error createLoaction: ' . $th->getMessage() . ', file:' . $th->getFile() . ', line:' .  $th->getLine());
            $this->dangerBanner('Error when creating location. Check the logs for more information.');
        }
    } // createLocation()


    /**
     *
     * @version     1.0.0 / 2025-04-13
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    #[On('multi-language-json-created')]
    public function onMultiLanguageJsonCreated(?array $json, string $target)
    {
        if ($target == 'create') {
            $this->labelsJson = $json;
        }
    } // onMultiLanguageJsonCreated()


    /**
     *
     * @version     1.0.0 / 2025-04-13
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function render()
    {
        return view('visitor-management::livewire.visit-locations.modals.add');

    } // render()


    /**
     *
     * @version     1.0.0 / 2025-04-13
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function resetModal()
    {
        $this->labelsJson = null;
        $this->city = null;
        $this->postcode = null;
        $this->street = null;
        $this->housenumber = null;
        $this->email = null;
        $this->phonenumber = null;
        $this->active = true;

    } // resetModal()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class Add extends Component {}
