<?php
/**
 * Livewire Component
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @generated   2025-03-25 09:32:39
 * @package     bplan-modules/visitor-management
 * @subpackage  LivewireComponents
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanModules\VisitorManagement\Livewire\VisitOpeningHours\Modals;


use BplanBase\Globals\Enums\LogLevel;
use BplanBase\Globals\Services\LogService;
use BplanModules\VisitorManagement\Models\VisitOpeningHour;
use BplanModules\VisitorManagement\Models\VisitType;
use BplanModules\VisitorManagement\Services\VisitOpeningHourService;
use Carbon\Carbon;
use Illuminate\Support\Facades\Log;
use Laravel\Jetstream\InteractsWithBanner;
use Livewire\Attributes\On;
use Livewire\Component;


/**
 * Livewire Component
 *
 * @version     2.0.0 / 2025-03-27
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 */
class Edit extends Component
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
    use InteractsWithBanner;

/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var         OpeningHourService $Service
     */
    protected VisitOpeningHourService $openingHourService;
    protected LogService $logService;

    public ?VisitType $visitType;
    public array $openingHours = [];
    public array $_weekdays = [
        'Sunday',
        'Monday',
        'Tuesday',
        'Wednesday',
        'Thursday',
        'Friday',
        'Saturday',
    ];


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    #[On('show-edit-opening-hours-modal')]
    public function init(VisitType $visitType)
    {
        $this->visitType = $visitType;

        foreach ($visitType->openingHours as $key => $visitTypeOpeningHour) {
            $this->openingHours[$visitType->identifier][$visitTypeOpeningHour->weekday]['id'] = $visitTypeOpeningHour->id;
            $this->openingHours[$visitType->identifier][$visitTypeOpeningHour->weekday]['open'] = $visitTypeOpeningHour->open;
            $this->openingHours[$visitType->identifier][$visitTypeOpeningHour->weekday]['begin'] = $visitTypeOpeningHour->begin;
            $this->openingHours[$visitType->identifier][$visitTypeOpeningHour->weekday]['end'] = $visitTypeOpeningHour->end;
            $this->openingHours[$visitType->identifier][$visitTypeOpeningHour->weekday]['weekday'] = $visitTypeOpeningHour->weekday;
        }
    }


    public function save()
    {
        try
        {
            foreach ($this->openingHours[$this->visitType->identifier] as $key => $openingHour) {
                if (isset($openingHour['open'])) {
                    if ($openingHour['open'] && (!isset($openingHour['begin']) || !isset($openingHour['end']))) {
                        $openingHour['open'] = false;
                    }

                    $this->openingHourService->update($openingHour['id'], [
                        'open' => $openingHour['open'],
                        'begin' => $openingHour['begin'] ?? null,
                        'end' => $openingHour['end'] ?? null,
                    ]);
                }
            }

            $this->dispatch('opening-hours-edited');
        }
        catch (\Throwable $th)
        {
            $this->logService->log(LogLevel::Error, 'OpeningHours/Modals/Edit save error: ' . $th->getMessage() . ', file:' . $th->getFile() . ', line:' .  $th->getLine());
            $this->dangerBanner('Error when editing opening hours. Check the logs for more information.');
        }
    }


    public function resetModal()
    {
        $this->resetExcept('_weekdays', 'openingHoursService');
    }


    /**
     *
     * @param       VisitOpeningHourService $service
     *
     * @version     1.0.0 / 2025-03-25
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     */
    public function boot(VisitOpeningHourService $openingHourService, LogService $logService)
    {
        $this->openingHourService = $openingHourService;
        $this->logService = $logService;

    } // boot()


    /**
     *
     * @version     1.0.0 / 2025-03-25
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     */
    public function mount(VisitType $visitType)
    {
        //
    } // mount()


    /**
     *
     * @version     1.0.0 / 2025-03-25
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     */
    public function render()
    {
        return view('visitor-management::livewire.visit-opening-hours.modals.edit');

    } // render()


    /**
     *
     * @return      array
     *
     * @version     1.0.0 / 2025-03-25
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     */
    public function rules(): array
    {
        $rules = [];

        return $rules;

    } // rules()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class Edit extends Component {}
