<?php
/**
 * Mailer Class
 *
 * @todo        config('mail.default') auswerten und alternative Mailer verwenden.
 *              Aktuell wird nur auf SMTP gesetzt. Sendmail und log sollten auch einfach umzusetzen sein.
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-modules/visitor-management
 * @subpackage  Mail
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <http://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanModules\VisitorManagement\Mail;


use Illuminate\Support\Facades\Log;
use PHPMailer\PHPMailer\PHPMailer as TheRealPHPMailer;
use PHPMailer\PHPMailer\SMTP;
use PHPMailer\PHPMailer\Exception;


/**
 * Mailer Class
 *
 * @version     2.0.0 / 2024-12-03
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class PHPMailer extends TheRealPHPMailer
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * Setting the PHPMailer->SMTPDebug property to these numbers or constants (defined in the SMTP
     *  class)results in different amounts of output:
     * - DEBUG_OFF (0): Disable debugging (you can also leave this out completely, 0 is the default).
     * - DEBUG_CLIENT (1): Output messages sent by the client.
     * - DEBUG_SERVER (2): as 1, plus responses received from the server (this is the most useful
     *   setting).
     * - DEBUG_CONNECTION (3): as 2, plus more information about the initial connection - this level
     *   can help diagnose STARTTLS failures.
     * - DEBUG_LOWLEVEL (4): as 3, plus even lower-level information, very verbose, don't use for
     *   debugging SMTP, only low-level problems.
     *
     * @var     int SMTP::DEBUG_CLIENT
     */
    const DEBUG_CLIENT = SMTP::DEBUG_CLIENT;


    /**
     * @var     int SMTP::DEBUG_CONNECTION
     */
    const DEBUG_CONNECTION = SMTP::DEBUG_CONNECTION;


    /**
     * @var     int SMTP::DEBUG_LOWLEVEL
     */
    const DEBUG_LOWLEVEL = SMTP::DEBUG_LOWLEVEL;


    /**
     * @var     int SMTP::DEBUG_OFF
     */
    const DEBUG_OFF = SMTP::DEBUG_OFF;


    /**
     * @var     int SMTP::DEBUG_SERVER
     */
    const DEBUG_SERVER = SMTP::DEBUG_SERVER;


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var     int $_debugLevel
     */
    private int $_debugLevel = self::DEBUG_OFF;


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @param       bool|null $exceptions
     *
     * @version     1.0.0 / 2024-11-30
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function __construct(bool|null $exceptions)
    {
        parent::__construct($exceptions);

        $from = config('mail.from');
        $smtp = config('mail.mailers.smtp');

        $this->CharSet = TheRealPHPMailer::CHARSET_UTF8;
        $this->isSMTP();
        $this->setFrom($from['address'], $from['name']);

        $this->Host = $smtp['host'];
        $this->Password = $smtp['password'];
        $this->Port = $smtp['port'];
        $this->Username = $smtp['username'];

        $this->SMTPAuth = true;
        $this->SMTPDebug = $this->_debugLevel;
        $this->SMTPSecure = PHPMailer::ENCRYPTION_SMTPS;

        $this->Debugoutput = static function ($str, $level) {
            Log::debug('Debug level '.$level.': message: '.$str);
        };
    } // __construct()


    /**
     *
     * @version     1.0.0 / 2024-11-30
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function send()
    {
        return parent::send();

    } // send()


    /**
     *
     * @return 	    $this
     *
     * @version     1.0.0 / 2024-12-03
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function setDebugLevel(int|null $level = null): self
    {
        if ($level === null) {
            $level = self::DEBUG_OFF;
        }
        $this->SMTPDebug = $this->_debugLevel = $level;

        return $this;

    } // setDebugLevel()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class PHPMailer extends TheRealPHPMailer {}
