<?php
/**
 * Model Class
 *
 * Wegen der Implementierung der Methode getCurrentlyOpenAttribute() aus der 
 * automatischen Generierung genommen.
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @generated   2025-04-21 22:26:12
 * @package     bplan-modules/visitor-management
 * @subpackage  Models
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanModules\VisitorManagement\Models;


use BplanModules\VisitorManagement\Observers\VisitOpeningHourExceptionObserver;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Attributes\ObservedBy;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\SoftDeletes;


/**
 * Model Class
 *
 * @version     1.4.0 / 2025-04-21
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
#[ObservedBy([VisitOpeningHourExceptionObserver::class])]
class VisitOpeningHourException extends Model
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    use SoftDeletes;


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * The accessors to append to the model's array form.
     *
     * @var         array<int, string> $appends
     *
     * @version     1.0.0 / 2025-04-21
     */
    protected $appends = [
        'currently_open',
    ];


    /**
     * @var         array<string, string> $casts
     *
     * @version     1.0.0 / 2025-04-21
     */
    protected $casts = [
        'active'     => 'boolean',
        'created_at' => 'datetime',
        'date'       => 'date',
        'deleted_at' => 'datetime',
        'open'       => 'boolean',
        'updated_at' => 'datetime',
    ];


    /**
     * The attributes that are mass assignable.
     *
     * @var         array<int, string> $fillable
     *
     * @version     1.0.0 / 2025-04-21
     */
    protected $fillable = [
        'active',
        'begin',
        'date',
        'end',
        'open',
        'visit_type_id',
    ];


    /**
     * The attributes that aren't mass assignable.
     *
     * @var         array<int, string> $guarded
     *
     * @version     1.0.0 / 2025-04-21
     */
    protected $guarded = [
        'created_at',
        'deleted_at',
        'updated_at',
    ];


    /**
     * The attributes that should be hidden for serialization.
     *
     * @var         array<int, string> $hidden
     *
     * @version     1.0.0 / 2025-04-21
     */
    protected $hidden = [];


    /**
     * The table associated with the model.
     *
     * @var         string $table
     */
    protected $table = 'visit_opening_hour_exceptions';


    /**
     * Indicates if the model should be timestamped.
     *
     * @var         bool $timestamps
     */
    public $timestamps = true;


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @return      mixed
     *
     * @version     1.0.0 / 2025-03-25
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function getCurrentlyOpenAttribute(): mixed
    {
        if ($this->open === false) {
            return false;
        }
        $Now = Carbon::now();

        list($h, $m) = explode(':', $this->begin);

        $Begin = Carbon::now()->setTime($h, $m, 0);

        list($h, $m) = explode(':', $this->end);

        $End = Carbon::now()->setTime($h, $m, 0);

        if ($Now->gte($Begin) && $Now->lte($End)) {
            return true;
        }
        return false;

    } // getCurrentlyOpenAttribute()


    /**
     *
     * @return      BelongsTo
     *
     * @version     1.0.0 / 2025-04-21
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function visitType(): BelongsTo
    {
        return $this->belongsTo(VisitType::class, 'visit_type_id');

    } // visitType()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class VisitOpeningHourException extends Model {}
