<?php
/**
 * Notification Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-modules/visitor-management
 * @subpackage  Notifications
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanModules\VisitorManagement\Notifications;


use BplanModules\VisitorManagement\Models\VisitAppointment;
use BplanModules\VisitorManagement\Models\VisitEmployee;
use BplanModules\VisitorManagement\Repositories\VisitEmployeeRepository;
use BplanComponents\LaravelSpryng\Notifications\SmsChannel;
use BplanComponents\LaravelSpryng\Notifications\SmsMessage;
use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;


/**
 * Notification Class
 *
 * Benachrichtigung an einen Mitarbeiter über die Ankunft eines Besuchers (per E-Mail und SMS).
 *
 * @version     1.1.0 / 2025-01-12
 * @history     VisitorArrrived, 1.2.0 / 2024-11-16
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class EmployeeVisitorArrived extends Notification
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */

    use Queueable;


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var     VisitAppointment $_Appointment
     */
    private $_Appointment;


    /**
     * @var     VisitEmployee $_Employee
     */
    private $_Employee;


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * Create a new notification instance.
     *
     * @param       VisitAppointment $Appointment
     *
     * @version     1.0.0 / 2024-12-09
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function __construct(VisitAppointment $Appointment)
    {
        $this->_Appointment = $Appointment;
        $this->_Employee = VisitEmployeeRepository::getById($Appointment->main_employee_id);

    } // __construct()


    /**
     * Get the array representation of the notification.
     *
     * @param       object $Notifiable
     *
     * @return      array<string, mixed>
     *
     * @version     1.0.0 / 2024-12-09
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function toArray(object $Notifiable): array
    {
        return [
            //
        ];
    } // toArray()


    /**
     * Get the mail representation of the notification.
     *
     * @param       object $Notifiable
     *
     * @throws      Exception
     *
     * @return      MailMessage
     *
     * @version     1.1.0 / 2025-01-12
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function toMail(object $Notifiable): MailMessage
    {
        $lang = 'de';

        $lc_button = trans('notifications.visitor-arrived.mail.button.view', [], $lang);
        $lc_greeting = trans('notifications.greeting', [], $lang);
        $lc_subject = trans('notifications.visitor-arrived.mail.subject', [], $lang);
        $lc_intro = trans('notifications.visitor-arrived.mail.intro', [
                'button' => $lc_button,
                'token' => $this->_Appointment->token

            ], $lang
        );
        $MailMessage = (new MailMessage)
            ->subject($lc_subject)
            ->greeting($lc_greeting)
            ->line($lc_intro)->action($lc_button, route('visit-appointments.index', [
                    'id' => $this->_Appointment->id,
                    'token' => $this->_Appointment->token
                ]
            ));

        return $MailMessage;

    } // toMail()


    /**
     *
     * @param       object $Notifiable
     *
     * @return 	    SmsMessage|string
     *
     * @version     1.1.0 / 2025-01-12
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function toSpryngSms(object $Notifiable): SmsMessage|string
    {
        $lang = 'de';

        $body = trans('notifications.visitor-arrived.sms.intro', [
                'token' => $this->_Appointment->token
            ], $lang
        );

        $SmsMessage = new SmsMessage($body);

        return $SmsMessage;

    } // toSpryngsms()


    /**
     * Get the notification's delivery channels.
     *
     * @param       object $Notifiable
     *
     * @return      array<int, string>
     *
     * @version     1.0.0 / 2024-12-09
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function via(object $Notifiable): array
    {
        return [
            'mail',
            SmsChannel::class,
        ];
    } // via()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class EmployeeVisitorArrived extends Notification {}
